/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf.utils.compiler;

import com.baidu.bjf.remoting.protobuf.utils.compiler.ClassUtils;
import com.baidu.bjf.remoting.protobuf.utils.compiler.Compiler;
import java.io.OutputStream;

public abstract class AbstractCompiler
implements Compiler {
    @Override
    public Class<?> compile(String className, String code, ClassLoader classLoader, OutputStream os, long lastModify) {
        code = code.trim();
        try {
            return Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            if (!code.endsWith("}")) {
                throw new IllegalStateException("The java code not endsWith \"}\", code: \n" + code + "\n");
            }
            try {
                return this.doCompile(className, code, os);
            }
            catch (RuntimeException t) {
                throw t;
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to compile class, cause: " + t.getMessage() + ", class: " + className + ", code: \n" + code + "\n, stack: " + ClassUtils.toString(t));
            }
        }
    }

    protected abstract Class<?> doCompile(String var1, String var2, OutputStream var3) throws Throwable;
}

