/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common.encrypt;

import com.baomidou.kisso.common.encrypt.Asn1Object;
import com.baomidou.kisso.common.encrypt.DerParser;
import com.baomidou.kisso.common.util.Base64Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;

public class RSA {
    public static final String SIGNATURE_ALGORITHM = "MD5withRSA";
    private static final String PUBLIC_KEY = "RSAPublicKey";
    private static final String PRIVATE_KEY = "RSAPrivateKey";
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;

    public static Map<String, Key> genKeyPair() throws NoSuchAlgorithmException {
        final KeyPair keyPair = RSA.getKeyPair(1024);
        return new HashMap<String, Key>(2){
            {
                super(x0);
                this.put(RSA.PUBLIC_KEY, keyPair.getPublic());
                this.put(RSA.PRIVATE_KEY, keyPair.getPrivate());
            }
        };
    }

    public static KeyPair getKeyPair(int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
        keyPairGen.initialize(keySize, new SecureRandom());
        return keyPairGen.generateKeyPair();
    }

    public static String sign(byte[] data, String privateKey) throws Exception {
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(RSA.privateKey(privateKey));
        signature.update(data);
        return Base64Util.encode(signature.sign());
    }

    public static boolean verify(byte[] data, String publicKey, String sign) throws Exception {
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(RSA.publicKey(publicKey));
        signature.update(data);
        return signature.verify(Base64Util.decode(sign));
    }

    public static byte[] decryptByPrivateKey(byte[] encryptedData, String privateKey) throws Exception {
        return RSA.cipherDecryptData(encryptedData, RSA.privateKey(privateKey));
    }

    public static byte[] decryptByPublicKey(byte[] encryptedData, String publicKey) throws Exception {
        return RSA.cipherDecryptData(encryptedData, RSA.publicKey(publicKey));
    }

    private static byte[] cipherDecryptData(byte[] data, Key key) throws Exception {
        return RSA.cipherData(data, key, 2, 128);
    }

    private static byte[] cipherEncryptData(byte[] data, Key key) throws Exception {
        return RSA.cipherData(data, key, 1, 117);
    }

    private static byte[] cipherData(byte[] data, Key key, int mode, int block) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(mode, key);
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > block ? cipher.doFinal(data, offSet, block) : cipher.doFinal(data, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * block;
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        return encryptedData;
    }

    public static byte[] encryptByPublicKey(byte[] data, String publicKey) throws Exception {
        return RSA.cipherEncryptData(data, RSA.publicKey(publicKey));
    }

    public static byte[] encryptByPrivateKey(byte[] data, String privateKey) throws Exception {
        return RSA.cipherEncryptData(data, RSA.privateKey(privateKey));
    }

    public static String getPrivateKey(Map<String, Key> keyMap) {
        return Base64Util.encode(keyMap.get(PRIVATE_KEY).getEncoded());
    }

    public static String getBase64PrivateKey(Map<String, Key> keyMap) {
        String privateKey = Base64.getMimeEncoder().encodeToString(keyMap.get(PRIVATE_KEY).getEncoded());
        return "-----BEGIN PRIVATE KEY-----\n" + privateKey + "\n-----END PRIVATE KEY-----";
    }

    public static String getPublicKey(Map<String, Key> keyMap) {
        return Base64Util.encode(keyMap.get(PUBLIC_KEY).getEncoded());
    }

    public static String getBase64PublicKey(Map<String, Key> keyMap) {
        String publicKey = Base64.getMimeEncoder().encodeToString(keyMap.get(PUBLIC_KEY).getEncoded());
        return "-----BEGIN PUBLIC KEY-----\n" + publicKey + "\n-----END PUBLIC KEY-----";
    }

    public static PrivateKey privateKey(String privateKey) throws InvalidKeySpecException {
        return RSA.privateKeyFromPKCS8(Base64Util.decode(privateKey));
    }

    public static PublicKey publicKey(String publicKey) throws InvalidKeySpecException {
        return RSA.publicKeyFrom(Base64Util.decode(publicKey));
    }

    public static PrivateKey privateKeyFromPKCS8(byte[] pkcs8) throws InvalidKeySpecException {
        try {
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(pkcs8);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(privateKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static PrivateKey privateKeyFromPKCS1(byte[] pkcs1) throws InvalidKeySpecException {
        try {
            RSAPrivateCrtKeySpec privateKeySpec = RSA.newRSAPrivateCrtKeySpec(pkcs1);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(privateKeySpec);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static PublicKey publicKeyFrom(byte[] derBytes) throws InvalidKeySpecException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(derBytes);
            return keyFactory.generatePublic(publicKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private static RSAPrivateCrtKeySpec newRSAPrivateCrtKeySpec(byte[] keyInPkcs1) throws IOException {
        DerParser parser = new DerParser(keyInPkcs1);
        Asn1Object sequence = parser.read();
        if (sequence.getType() != 16) {
            throw new IllegalArgumentException("Invalid DER: not a sequence");
        }
        DerParser p = sequence.getParser();
        p.read();
        return new RSAPrivateCrtKeySpec(RSA.readInteger(p), RSA.readInteger(p), RSA.readInteger(p), RSA.readInteger(p), RSA.readInteger(p), RSA.readInteger(p), RSA.readInteger(p), RSA.readInteger(p));
    }

    private static BigInteger readInteger(DerParser p) throws IOException {
        return p.read().getInteger();
    }
}

