/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common.encrypt;

import com.baomidou.kisso.SSOConfig;
import com.baomidou.kisso.common.encrypt.Algorithm;
import com.baomidou.kisso.common.encrypt.MD5;
import com.baomidou.kisso.common.encrypt.SSOEncrypt;
import com.baomidou.kisso.common.encrypt.base64.UrlBase64;
import com.baomidou.kisso.exception.KissoException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSOSymmetrical
implements SSOEncrypt {
    private static final Logger log = LoggerFactory.getLogger(SSOSymmetrical.class);
    private Algorithm algorithm = Algorithm.RC4;

    public SSOSymmetrical() {
    }

    public SSOSymmetrical(Algorithm algorithm) {
        this.algorithm = algorithm;
        log.info("Your current encryption algorithm is " + algorithm.getKey());
    }

    @Override
    public String encrypt(String value, String key) throws Exception {
        byte[] b = UrlBase64.encode(this.encrypt(this.algorithm, value.getBytes(SSOConfig.getSSOEncoding()), key));
        return new String(b, SSOConfig.getSSOEncoding());
    }

    @Override
    public String decrypt(String value, String key) throws Exception {
        byte[] b = this.decrypt(this.algorithm, UrlBase64.decode(value.getBytes(SSOConfig.getSSOEncoding())), key);
        return new String(b, SSOConfig.getSSOEncoding());
    }

    private Key toKey(Algorithm algorithm, String strKey) throws Exception {
        byte[] key = MD5.md5Raw(strKey.getBytes(SSOConfig.getSSOEncoding()));
        if (Algorithm.DES == algorithm) {
            DESKeySpec dks = new DESKeySpec(key);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(algorithm.getKey());
            SecretKey secretKey = keyFactory.generateSecret(dks);
            return secretKey;
        }
        return new SecretKeySpec(key, algorithm.getKey());
    }

    public byte[] decrypt(Algorithm algorithm, byte[] data, String key) {
        try {
            Cipher cipher = Cipher.getInstance(algorithm.toString());
            cipher.init(2, this.toKey(algorithm, key));
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            log.error("Encrypt setKey is exception.");
            throw new KissoException(e);
        }
    }

    public byte[] encrypt(Algorithm algorithm, byte[] data, String key) {
        try {
            Cipher cipher = Cipher.getInstance(algorithm.toString());
            cipher.init(1, this.toKey(algorithm, key));
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            log.error("Encrypt setKey is exception.");
            throw new KissoException(e);
        }
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }
}

