/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common.encrypt;

import com.baomidou.kisso.common.encrypt.Algorithm;
import com.baomidou.kisso.common.encrypt.Base32;
import com.baomidou.kisso.common.encrypt.HmacSHA256;
import com.baomidou.kisso.common.util.RandomUtil;
import com.baomidou.kisso.common.util.StringUtils;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class TOTP {
    private static final int[] DIGITS_POWER = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000};
    private static final int INTERVAL = 30;
    public static final int WINDOW = 3;
    public static final int PASS_CODE_LENGTH = 6;

    private TOTP() {
    }

    public static long getCode(String secretKey) {
        byte[] decodedKey = TOTP.decodeSecretKey(secretKey);
        long currentInterval = TOTP.getCurrentInterval();
        return TOTP.generate(decodedKey, currentInterval, 6, Algorithm.HMACSHA1.getKey());
    }

    public static String getOtpAuthUrl(String user, String issuer, String secretKey) {
        return "otpauth://totp/" + user + "?secret=" + secretKey + "&issuer=" + issuer;
    }

    public static boolean isValidCode(String secretKey, long totpCode) {
        if (StringUtils.isEmpty(secretKey) || totpCode < 0L) {
            return false;
        }
        byte[] decodedKey = TOTP.decodeSecretKey(secretKey);
        int window = 3;
        long currentInterval = TOTP.getCurrentInterval();
        for (int i = -window; i <= window; ++i) {
            long hash = TOTP.generate(decodedKey, currentInterval + (long)i, 6, Algorithm.HMACSHA1.getKey());
            if (hash != totpCode) continue;
            return true;
        }
        return false;
    }

    public static byte[] generateKey() throws Exception {
        byte[] key = HmacSHA256.generate(RandomUtil.get32UUID(), RandomUtil.getCharacterAndNumber(20));
        return Arrays.copyOf(key, 20);
    }

    public static String getSecretKey(byte[] key) {
        return Base32.encode(key);
    }

    public static String getSecretKey() {
        try {
            return TOTP.getSecretKey(TOTP.generateKey());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] decodeSecretKey(String secretKey) {
        return Base32.decode(secretKey);
    }

    public static String getFormatedKey(String secretKey) {
        return secretKey.toUpperCase().replaceAll("(.{4})(?=.{4})", "$1 ");
    }

    private static int generate(byte[] key, long time, int digits, String crypto) {
        byte[] msg = ByteBuffer.allocate(8).putLong(time).array();
        byte[] hash = TOTP.hmacSha(crypto, key, msg);
        int offset = hash[hash.length - 1] & 0xF;
        int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
        int otp = binary % DIGITS_POWER[digits];
        return otp;
    }

    private static byte[] hmacSha(String crypto, byte[] keyBytes, byte[] text) throws UndeclaredThrowableException {
        try {
            Mac hmac = Mac.getInstance(crypto);
            SecretKeySpec macKey = new SecretKeySpec(keyBytes, "RAW");
            hmac.init(macKey);
            return hmac.doFinal(text);
        }
        catch (GeneralSecurityException gse) {
            throw new UndeclaredThrowableException(gse);
        }
    }

    private static long getCurrentInterval() {
        long currentTimeSeconds = System.currentTimeMillis() / 1000L;
        return currentTimeSeconds / 30L;
    }
}

