/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common.signature;

import com.baomidou.kisso.common.signature.ISign;
import com.baomidou.kisso.common.signature.ShaAlgorithm;
import com.baomidou.kisso.exception.UnsupportedAlgorithmException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.Mac;

public class SignSymmetric
implements ISign {
    private final Key key;

    public SignSymmetric(Key key) {
        this.key = key;
    }

    @Override
    public byte[] sign(Provider provider, ShaAlgorithm shaAlgorithm, byte[] signingStringBytes) {
        try {
            Mac mac = provider == null ? Mac.getInstance(shaAlgorithm.getJmvName()) : Mac.getInstance(shaAlgorithm.getJmvName(), provider);
            mac.init(this.key);
            return mac.doFinal(signingStringBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedAlgorithmException(shaAlgorithm.getJmvName());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

