/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common.signature;

import com.baomidou.kisso.common.encrypt.MD5;
import com.baomidou.kisso.common.signature.ShaAlgorithm;
import com.baomidou.kisso.common.util.JoinUtil;
import com.baomidou.kisso.exception.AuthenticationException;
import com.baomidou.kisso.exception.MissingAlgorithmException;
import com.baomidou.kisso.exception.MissingKeyIdException;
import com.baomidou.kisso.exception.MissingRequiredHeaderException;
import com.baomidou.kisso.exception.MissingSignatureException;
import com.baomidou.kisso.exception.UnparsableSignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Signature {
    private final String keyId;
    private final ShaAlgorithm shaAlgorithm;
    private final String signature;
    private final List<String> headers;
    private static final Pattern RFC_2617_PARAM = Pattern.compile("(\\w+)=\"([^\"]*)\"");

    public Signature(String keyId, String shaAlgorithm, String signature, String ... headers) {
        this(keyId, Signature.getShaAlgorithm(shaAlgorithm), signature, headers);
    }

    private static ShaAlgorithm getShaAlgorithm(String shaAlgorithm) {
        if (shaAlgorithm == null) {
            throw new IllegalArgumentException("ShaAlgorithm cannot be null");
        }
        return ShaAlgorithm.get(shaAlgorithm);
    }

    public Signature(String keyId, ShaAlgorithm algorithm, String signature, String ... headers) {
        this(keyId, algorithm, signature, Arrays.asList(headers));
    }

    public Signature(String keyId, String shaAlgorithm, String signature, List<String> headers) {
        this(keyId, Signature.getShaAlgorithm(shaAlgorithm), signature, headers);
    }

    public Signature(String keyId, ShaAlgorithm shaAlgorithm, String signature, List<String> headers) {
        if (keyId == null || keyId.trim().isEmpty()) {
            throw new IllegalArgumentException("keyId is required.");
        }
        if (shaAlgorithm == null) {
            throw new IllegalArgumentException("shaAlgorithm is required.");
        }
        this.keyId = keyId;
        this.shaAlgorithm = shaAlgorithm;
        this.signature = signature;
        if (headers.size() == 0) {
            List<String> list = Arrays.asList("date");
            this.headers = Collections.unmodifiableList(list);
        } else {
            this.headers = Collections.unmodifiableList(this.lowercase(headers));
        }
    }

    private List<String> lowercase(List<String> headers) {
        ArrayList<String> list = new ArrayList<String>(headers.size());
        for (String header : headers) {
            list.add(header.toLowerCase());
        }
        return list;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public ShaAlgorithm getShaAlgorithm() {
        return this.shaAlgorithm;
    }

    public String getSignature() {
        return this.signature;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public static Signature fromString(String authorization) {
        try {
            String keyid;
            authorization = Signature.normalize(authorization);
            HashMap<String, String> map = new HashMap<String, String>(16);
            Matcher matcher = RFC_2617_PARAM.matcher(authorization);
            while (matcher.find()) {
                String key = matcher.group(1).toLowerCase();
                String value = matcher.group(2);
                map.put(key, value);
            }
            ArrayList<String> headers = new ArrayList<String>();
            String headerString = (String)map.get("headers");
            if (headerString != null) {
                Collections.addAll(headers, headerString.toLowerCase().split(" +"));
            }
            if ((keyid = (String)map.get("keyid")) == null) {
                throw new MissingKeyIdException();
            }
            String algorithm = (String)map.get("shaalgorithm");
            if (algorithm == null) {
                throw new MissingAlgorithmException();
            }
            String signature = (String)map.get("signature");
            if (signature == null) {
                throw new MissingSignatureException();
            }
            ShaAlgorithm parsedAlgorithm = ShaAlgorithm.get(algorithm);
            return new Signature(keyid, parsedAlgorithm, signature, headers);
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new UnparsableSignatureException(authorization, e);
        }
    }

    private static String normalize(String authorization) {
        String start = "signature ";
        String prefix = authorization.substring(0, "signature ".length()).toLowerCase();
        if (prefix.equals("signature ")) {
            authorization = authorization.substring("signature ".length());
        }
        return authorization.trim();
    }

    public static String createSigningString(List<String> required, String method, String uri, Map<String, String> headers) {
        headers = Signature.lowercase(headers);
        ArrayList<String> list = new ArrayList<String>(required.size());
        for (String key : required) {
            if ("(request-target)".equals(key)) {
                method = Signature.lowercase(method);
                list.add(JoinUtil.join(" ", "(request-target):", method, uri));
                continue;
            }
            String value = headers.get(key);
            if (value == null) {
                throw new MissingRequiredHeaderException(key);
            }
            list.add(key + ": " + value);
        }
        return JoinUtil.join("\n", list);
    }

    private static Map<String, String> lowercase(Map<String, String> headers) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            map.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        return map;
    }

    private static String lowercase(String spec) {
        return spec.toLowerCase();
    }

    public static String md5Signing(String accessSecret, Map<String, Object> params) {
        Objects.requireNonNull(accessSecret, "AccessSecret cannot be null");
        Object[] keys = params.keySet().toArray();
        Arrays.sort(keys);
        StringBuilder temp = new StringBuilder();
        boolean first = true;
        for (Object key : keys) {
            if (first) {
                first = false;
            } else {
                temp.append("&");
            }
            temp.append(key).append("=");
            Object value = params.get(key);
            String valueString = "";
            if (null != value) {
                valueString = String.valueOf(value);
            }
            temp.append(valueString);
        }
        temp.append("&").append("accessSecret").append("=").append(accessSecret);
        return MD5.toMD5(temp.toString());
    }

    public String toString() {
        return "Signature keyId=\"" + this.keyId + '\"' + ",shaAlgorithm=\"" + (Object)((Object)this.shaAlgorithm) + '\"' + ",headers=\"" + JoinUtil.join(" ", this.headers) + '\"' + ",signature=\"" + this.signature + '\"';
    }
}

