/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.inner;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ParameterUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.pagination.DialectFactory;
import com.baomidou.mybatisplus.extension.plugins.pagination.DialectModel;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.IDialect;
import com.baomidou.mybatisplus.extension.toolkit.JdbcUtils;
import com.baomidou.mybatisplus.extension.toolkit.PropertyMapper;
import com.baomidou.mybatisplus.extension.toolkit.SqlParserUtils;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.Distinct;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.GroupByElement;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.WithItem;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

public class PaginationInnerInterceptor
implements InnerInterceptor {
    protected static final List<SelectItem> COUNT_SELECT_ITEM = Collections.singletonList(PaginationInnerInterceptor.defaultCountSelectItem());
    protected static final Map<String, MappedStatement> countMsCache = new ConcurrentHashMap<String, MappedStatement>();
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected boolean overflow;
    protected Long maxLimit;
    private DbType dbType;
    private IDialect dialect;
    protected boolean optimizeJoin = true;

    private static SelectItem defaultCountSelectItem() {
        Function function = new Function();
        function.setName("COUNT");
        function.setAllColumns(true);
        return new SelectExpressionItem((Expression)function);
    }

    public PaginationInnerInterceptor(DbType dbType) {
        this.dbType = dbType;
    }

    public PaginationInnerInterceptor(IDialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public boolean willDoQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        Object o;
        BoundSql countSql;
        IPage page = ParameterUtils.findPage((Object)parameter).orElse(null);
        if (page == null || page.getSize() < 0L || !page.searchCount()) {
            return true;
        }
        MappedStatement countMs = this.buildCountMappedStatement(ms, page.countId());
        if (countMs != null) {
            countSql = countMs.getBoundSql(parameter);
        } else {
            countMs = this.buildAutoCountMappedStatement(ms);
            String countSqlStr = this.autoCountSql(page.optimizeCountSql(), boundSql.getSql());
            PluginUtils.MPBoundSql mpBoundSql = PluginUtils.mpBoundSql((BoundSql)boundSql);
            countSql = new BoundSql(countMs.getConfiguration(), countSqlStr, mpBoundSql.parameterMappings(), parameter);
            PluginUtils.setAdditionalParameter((BoundSql)countSql, (Map)mpBoundSql.additionalParameters());
        }
        CacheKey cacheKey = executor.createCacheKey(countMs, parameter, rowBounds, countSql);
        List result = executor.query(countMs, parameter, rowBounds, resultHandler, cacheKey, countSql);
        long total = 0L;
        if (CollectionUtils.isNotEmpty((Collection)result) && (o = result.get(0)) != null) {
            total = Long.parseLong(o.toString());
        }
        page.setTotal(total);
        return this.continuePage(page);
    }

    @Override
    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        Long _limit;
        IPage page = ParameterUtils.findPage((Object)parameter).orElse(null);
        if (null == page) {
            return;
        }
        boolean addOrdered = false;
        String buildSql = boundSql.getSql();
        List orders = page.orders();
        if (CollectionUtils.isNotEmpty((Collection)orders)) {
            addOrdered = true;
            buildSql = this.concatOrderBy(buildSql, orders);
        }
        Long l = _limit = page.maxLimit() != null ? page.maxLimit() : this.maxLimit;
        if (page.getSize() < 0L && null == _limit) {
            if (addOrdered) {
                PluginUtils.mpBoundSql((BoundSql)boundSql).sql(buildSql);
            }
            return;
        }
        this.handlerLimit(page, _limit);
        IDialect dialect = this.findIDialect(executor);
        Configuration configuration = ms.getConfiguration();
        DialectModel model = dialect.buildPaginationSql(buildSql, page.offset(), page.getSize());
        PluginUtils.MPBoundSql mpBoundSql = PluginUtils.mpBoundSql((BoundSql)boundSql);
        List mappings = mpBoundSql.parameterMappings();
        Map additionalParameter = mpBoundSql.additionalParameters();
        model.consumers(mappings, configuration, additionalParameter);
        mpBoundSql.sql(model.getDialectSql());
        mpBoundSql.parameterMappings(mappings);
    }

    protected IDialect findIDialect(Executor executor) {
        if (this.dialect != null) {
            return this.dialect;
        }
        if (this.dbType != null) {
            this.dialect = DialectFactory.getDialect(this.dbType);
            return this.dialect;
        }
        return DialectFactory.getDialect(JdbcUtils.getDbType(executor));
    }

    protected MappedStatement buildCountMappedStatement(MappedStatement ms, String countId) {
        if (StringUtils.isNotBlank((CharSequence)countId)) {
            String id = ms.getId();
            if (!countId.contains(".")) {
                countId = id.substring(0, id.lastIndexOf(".") + 1) + countId;
            }
            Configuration configuration = ms.getConfiguration();
            try {
                return (MappedStatement)CollectionUtils.computeIfAbsent(countMsCache, (Object)countId, key -> configuration.getMappedStatement(key, false));
            }
            catch (Exception e) {
                this.logger.warn(String.format("can not find this countId: [\"%s\"]", countId));
            }
        }
        return null;
    }

    protected MappedStatement buildAutoCountMappedStatement(MappedStatement ms) {
        String countId = ms.getId() + "_mpCount";
        Configuration configuration = ms.getConfiguration();
        return (MappedStatement)CollectionUtils.computeIfAbsent(countMsCache, (Object)countId, key -> {
            MappedStatement.Builder builder = new MappedStatement.Builder(configuration, key, ms.getSqlSource(), ms.getSqlCommandType());
            builder.resource(ms.getResource());
            builder.fetchSize(ms.getFetchSize());
            builder.statementType(ms.getStatementType());
            builder.timeout(ms.getTimeout());
            builder.parameterMap(ms.getParameterMap());
            builder.resultMaps(Collections.singletonList(new ResultMap.Builder(configuration, "mybatis-plus", Long.class, Collections.emptyList()).build()));
            builder.resultSetType(ms.getResultSetType());
            builder.cache(ms.getCache());
            builder.flushCacheRequired(ms.isFlushCacheRequired());
            builder.useCache(ms.isUseCache());
            return builder.build();
        });
    }

    protected String autoCountSql(boolean optimizeCountSql, String sql) {
        if (!optimizeCountSql) {
            return this.lowLevelCountSql(sql);
        }
        try {
            List joins;
            Select select = (Select)CCJSqlParserUtil.parse((String)sql);
            PlainSelect plainSelect = (PlainSelect)select.getSelectBody();
            Distinct distinct = plainSelect.getDistinct();
            GroupByElement groupBy = plainSelect.getGroupBy();
            List orderBy = plainSelect.getOrderByElements();
            if (CollectionUtils.isNotEmpty((Collection)orderBy)) {
                boolean canClean = true;
                if (groupBy != null) {
                    canClean = false;
                }
                if (canClean) {
                    for (OrderByElement order : orderBy) {
                        Expression expression = order.getExpression();
                        if (expression instanceof Column || !expression.toString().contains("?")) continue;
                        canClean = false;
                        break;
                    }
                }
                if (canClean) {
                    plainSelect.setOrderByElements(null);
                }
            }
            for (SelectItem item : plainSelect.getSelectItems()) {
                if (!item.toString().contains("?")) continue;
                return this.lowLevelCountSql(select.toString());
            }
            if (distinct != null || null != groupBy) {
                return this.lowLevelCountSql(select.toString());
            }
            if (this.optimizeJoin && CollectionUtils.isNotEmpty((Collection)(joins = plainSelect.getJoins()))) {
                boolean canRemoveJoin = true;
                String whereS = Optional.ofNullable(plainSelect.getWhere()).map(Object::toString).orElse("");
                whereS = whereS.toLowerCase();
                for (Join join : joins) {
                    if (!join.isLeft()) {
                        canRemoveJoin = false;
                        break;
                    }
                    FromItem rightItem = join.getRightItem();
                    String str = "";
                    if (rightItem instanceof Table) {
                        Table table = (Table)rightItem;
                        str = Optional.ofNullable(table.getAlias()).map(Alias::getName).orElse(table.getName()) + ".";
                    } else if (rightItem instanceof SubSelect) {
                        SubSelect subSelect = (SubSelect)rightItem;
                        if (subSelect.toString().contains("?")) {
                            canRemoveJoin = false;
                            break;
                        }
                        str = subSelect.getAlias().getName() + ".";
                    }
                    str = str.toLowerCase();
                    String onExpressionS = join.getOnExpression().toString();
                    if (!onExpressionS.contains("?") && !whereS.contains(str)) continue;
                    canRemoveJoin = false;
                    break;
                }
                if (canRemoveJoin) {
                    plainSelect.setJoins(null);
                }
            }
            plainSelect.setSelectItems(COUNT_SELECT_ITEM);
            return select.toString();
        }
        catch (JSQLParserException e) {
            this.logger.warn("optimize this sql to a count sql has exception, sql:\"" + sql + "\", exception:\n" + e.getCause());
        }
        catch (Exception e) {
            this.logger.warn("optimize this sql to a count sql has error, sql:\"" + sql + "\", exception:\n" + e);
        }
        return this.lowLevelCountSql(sql);
    }

    protected String lowLevelCountSql(String originalSql) {
        return SqlParserUtils.getOriginalCountSql(originalSql);
    }

    public String concatOrderBy(String originalSql, List<OrderItem> orderList) {
        try {
            Select select = (Select)CCJSqlParserUtil.parse((String)originalSql);
            SelectBody selectBody = select.getSelectBody();
            if (selectBody instanceof PlainSelect) {
                PlainSelect plainSelect = (PlainSelect)selectBody;
                List orderByElements = plainSelect.getOrderByElements();
                List<OrderByElement> orderByElementsReturn = this.addOrderByElements(orderList, orderByElements);
                plainSelect.setOrderByElements(orderByElementsReturn);
                return select.toString();
            }
            if (selectBody instanceof SetOperationList) {
                SetOperationList setOperationList = (SetOperationList)selectBody;
                List orderByElements = setOperationList.getOrderByElements();
                List<OrderByElement> orderByElementsReturn = this.addOrderByElements(orderList, orderByElements);
                setOperationList.setOrderByElements(orderByElementsReturn);
                return select.toString();
            }
            if (selectBody instanceof WithItem) {
                return originalSql;
            }
            return originalSql;
        }
        catch (JSQLParserException e) {
            this.logger.warn("failed to concat orderBy from IPage, exception:\n" + e.getCause());
        }
        catch (Exception e) {
            this.logger.warn("failed to concat orderBy from IPage, exception:\n" + e);
        }
        return originalSql;
    }

    protected List<OrderByElement> addOrderByElements(List<OrderItem> orderList, List<OrderByElement> orderByElements) {
        List<OrderByElement> additionalOrderBy = orderList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getColumn())).map(item -> {
            OrderByElement element = new OrderByElement();
            element.setExpression((Expression)new Column(item.getColumn()));
            element.setAsc(item.isAsc());
            element.setAscDescPresent(true);
            return element;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(orderByElements)) {
            return additionalOrderBy;
        }
        additionalOrderBy.addAll(orderByElements);
        return additionalOrderBy;
    }

    protected boolean continuePage(IPage<?> page) {
        if (page.getTotal() <= 0L) {
            return false;
        }
        if (page.getCurrent() > page.getPages()) {
            if (this.overflow) {
                this.handlerOverflow(page);
            } else {
                return false;
            }
        }
        return true;
    }

    protected void handlerLimit(IPage<?> page, Long limit) {
        long size = page.getSize();
        if (limit != null && limit > 0L && (size > limit || size < 0L)) {
            page.setSize(limit.longValue());
        }
    }

    protected void handlerOverflow(IPage<?> page) {
        page.setCurrent(1L);
    }

    @Override
    public void setProperties(Properties properties) {
        PropertyMapper.newInstance(properties).whenNotBlank("overflow", Boolean::parseBoolean, this::setOverflow).whenNotBlank("dbType", DbType::getDbType, this::setDbType).whenNotBlank("dialect", ClassUtils::newInstance, this::setDialect).whenNotBlank("maxLimit", Long::parseLong, this::setMaxLimit).whenNotBlank("optimizeJoin", Boolean::parseBoolean, this::setOptimizeJoin);
    }

    public Log getLogger() {
        return this.logger;
    }

    public boolean isOverflow() {
        return this.overflow;
    }

    public Long getMaxLimit() {
        return this.maxLimit;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public IDialect getDialect() {
        return this.dialect;
    }

    public boolean isOptimizeJoin() {
        return this.optimizeJoin;
    }

    public void setOverflow(boolean overflow) {
        this.overflow = overflow;
    }

    public void setMaxLimit(Long maxLimit) {
        this.maxLimit = maxLimit;
    }

    public void setDbType(DbType dbType) {
        this.dbType = dbType;
    }

    public void setDialect(IDialect dialect) {
        this.dialect = dialect;
    }

    public void setOptimizeJoin(boolean optimizeJoin) {
        this.optimizeJoin = optimizeJoin;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaginationInnerInterceptor)) {
            return false;
        }
        PaginationInnerInterceptor other = (PaginationInnerInterceptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOverflow() != other.isOverflow()) {
            return false;
        }
        if (this.isOptimizeJoin() != other.isOptimizeJoin()) {
            return false;
        }
        Long this$maxLimit = this.getMaxLimit();
        Long other$maxLimit = other.getMaxLimit();
        if (this$maxLimit == null ? other$maxLimit != null : !((Object)this$maxLimit).equals(other$maxLimit)) {
            return false;
        }
        Log this$logger = this.getLogger();
        Log other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        DbType this$dbType = this.getDbType();
        DbType other$dbType = other.getDbType();
        if (this$dbType == null ? other$dbType != null : !this$dbType.equals(other$dbType)) {
            return false;
        }
        IDialect this$dialect = this.getDialect();
        IDialect other$dialect = other.getDialect();
        return !(this$dialect == null ? other$dialect != null : !this$dialect.equals(other$dialect));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaginationInnerInterceptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOverflow() ? 79 : 97);
        result = result * 59 + (this.isOptimizeJoin() ? 79 : 97);
        Long $maxLimit = this.getMaxLimit();
        result = result * 59 + ($maxLimit == null ? 43 : ((Object)$maxLimit).hashCode());
        Log $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        DbType $dbType = this.getDbType();
        result = result * 59 + ($dbType == null ? 43 : $dbType.hashCode());
        IDialect $dialect = this.getDialect();
        result = result * 59 + ($dialect == null ? 43 : $dialect.hashCode());
        return result;
    }

    public String toString() {
        return "PaginationInnerInterceptor(logger=" + this.getLogger() + ", overflow=" + this.isOverflow() + ", maxLimit=" + this.getMaxLimit() + ", dbType=" + this.getDbType() + ", dialect=" + this.getDialect() + ", optimizeJoin=" + this.isOptimizeJoin() + ")";
    }

    public PaginationInnerInterceptor() {
    }
}

