/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.spring.boot;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.spring.config.ConfigPropertySourceFactory;
import com.ctrip.framework.apollo.spring.util.SpringInjector;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;

public class ApolloApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Logger logger = LoggerFactory.getLogger(ApolloApplicationContextInitializer.class);
    private static final Splitter NAMESPACE_SPLITTER = Splitter.on((String)",").omitEmptyStrings().trimResults();
    private static final String[] APOLLO_SYSTEM_PROPERTIES = new String[]{"app.id", "apollo.cluster", "apollo.cacheDir", "apollo.meta"};
    private final ConfigPropertySourceFactory configPropertySourceFactory = SpringInjector.getInstance(ConfigPropertySourceFactory.class);

    public void initialize(ConfigurableApplicationContext context) {
        ConfigurableEnvironment environment = context.getEnvironment();
        this.initializeSystemProperty(environment);
        String enabled = environment.getProperty("apollo.bootstrap.enabled", "false");
        if (!Boolean.valueOf(enabled).booleanValue()) {
            logger.debug("Apollo bootstrap config is not enabled for context {}, see property: ${{}}", (Object)context, (Object)"apollo.bootstrap.enabled");
            return;
        }
        logger.debug("Apollo bootstrap config is enabled for context {}", (Object)context);
        if (environment.getPropertySources().contains("ApolloBootstrapPropertySources")) {
            return;
        }
        String namespaces = environment.getProperty("apollo.bootstrap.namespaces", "application");
        logger.debug("Apollo bootstrap namespaces: {}", (Object)namespaces);
        List namespaceList = NAMESPACE_SPLITTER.splitToList((CharSequence)namespaces);
        CompositePropertySource composite = new CompositePropertySource("ApolloBootstrapPropertySources");
        for (String namespace : namespaceList) {
            Config config = ConfigService.getConfig(namespace);
            composite.addPropertySource((PropertySource)this.configPropertySourceFactory.getConfigPropertySource(namespace, config));
        }
        environment.getPropertySources().addFirst((PropertySource)composite);
    }

    void initializeSystemProperty(ConfigurableEnvironment environment) {
        for (String propertyName : APOLLO_SYSTEM_PROPERTIES) {
            this.fillSystemPropertyFromEnvironment(environment, propertyName);
        }
    }

    private void fillSystemPropertyFromEnvironment(ConfigurableEnvironment environment, String propertyName) {
        if (System.getProperty(propertyName) != null) {
            return;
        }
        String propertyValue = environment.getProperty(propertyName);
        if (Strings.isNullOrEmpty((String)propertyValue)) {
            return;
        }
        System.setProperty(propertyName, propertyValue);
    }
}

