/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.spring.util;

import com.ctrip.framework.apollo.exceptions.ApolloConfigException;
import com.ctrip.framework.apollo.spring.config.ConfigPropertySourceFactory;
import com.ctrip.framework.apollo.spring.property.PlaceholderHelper;
import com.ctrip.framework.apollo.spring.property.SpringValueRegistry;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;

public class SpringInjector {
    private static volatile Injector s_injector;
    private static final Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Injector getInjector() {
        if (s_injector == null) {
            Object object = lock;
            synchronized (object) {
                if (s_injector == null) {
                    try {
                        s_injector = Guice.createInjector((Module[])new Module[]{new SpringModule()});
                    }
                    catch (Throwable ex) {
                        ApolloConfigException exception = new ApolloConfigException("Unable to initialize Apollo Spring Injector!", ex);
                        Tracer.logError((Throwable)exception);
                        throw exception;
                    }
                }
            }
        }
        return s_injector;
    }

    public static <T> T getInstance(Class<T> clazz) {
        try {
            return (T)SpringInjector.getInjector().getInstance(clazz);
        }
        catch (Throwable ex) {
            Tracer.logError((Throwable)ex);
            throw new ApolloConfigException(String.format("Unable to load instance for %s!", clazz.getName()), ex);
        }
    }

    static {
        lock = new Object();
    }

    private static class SpringModule
    extends AbstractModule {
        private SpringModule() {
        }

        protected void configure() {
            this.bind(PlaceholderHelper.class).in(Singleton.class);
            this.bind(ConfigPropertySourceFactory.class).in(Singleton.class);
            this.bind(SpringValueRegistry.class).in(Singleton.class);
        }
    }
}

