/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.deeptestutils;

import com.diffblue.deeptestutils.CompareWithFieldList;
import com.diffblue.deeptestutils.UnexpectedValueException;
import java.util.ArrayList;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public final class IterAnswer<T>
implements Answer<T> {
    private String classname;
    private String methodname;
    private int idx = 0;
    private ArrayList<T> answers;
    private ArrayList<Object[]> expectedParameters;

    public IterAnswer(String cn, String mn, ArrayList<T> answerList, ArrayList<Object[]> eps) {
        this.classname = cn;
        this.methodname = mn;
        this.answers = answerList;
        this.expectedParameters = eps;
    }

    public T answer(InvocationOnMock invocation) {
        if (this.idx == this.answers.size()) {
            System.out.println("WARNING: more answers than in trace " + (this.idx + 1) + " instead of just " + this.idx + " will restart with first");
            this.idx = 0;
        }
        T result = this.answers.get(this.idx);
        if (!this.expectedParameters.isEmpty()) {
            Object[] expected = this.expectedParameters.get(this.idx);
            Object[] actual = invocation.getArguments();
            assert (expected.length == actual.length);
            for (int i = 0; i < expected.length; ++i) {
                try {
                    CompareWithFieldList.compare(expected[i], actual[i]);
                    continue;
                }
                catch (UnexpectedValueException e) {
                    String errormsg = "Mocked class " + this.classname + " method " + this.methodname + " invocation " + (this.idx + 1) + " parameter " + (i + 1) + ": " + e.getMessage();
                    throw new UnexpectedValueException(errormsg);
                }
            }
        }
        ++this.idx;
        return result;
    }
}

