/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.base.osgi;

import com.diffplug.spotless.extra.eclipse.base.osgi.BundleSet;
import com.diffplug.spotless.extra.eclipse.base.osgi.SimpleBundleCapability;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.osgi.internal.framework.FilterImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Requirement;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;

class EclipseBundleLookup
implements FrameworkWiring,
PackageAdmin {
    private static final Set<String> OSGI_KEYS_FOR_SYMBOLIC_NAMES = Collections.unmodifiableSet(Stream.of("osgi.identity", "osgi.bundle").collect(Collectors.toSet()));
    private final Bundle systemBundle;
    private final BundleSet bundles;

    EclipseBundleLookup(Bundle systemBundle, BundleSet bundles) {
        this.systemBundle = systemBundle;
        this.bundles = bundles;
    }

    @Deprecated
    public ExportedPackage[] getExportedPackages(Bundle bundle) {
        return null;
    }

    @Deprecated
    public ExportedPackage[] getExportedPackages(String name) {
        return null;
    }

    @Deprecated
    public ExportedPackage getExportedPackage(String name) {
        return null;
    }

    @Deprecated
    public void refreshPackages(Bundle[] bundles) {
    }

    public boolean resolveBundles(Bundle[] bundles) {
        return true;
    }

    public RequiredBundle[] getRequiredBundles(String symbolicName) {
        return null;
    }

    public Bundle[] getBundles(String symbolicName, String versionRange) {
        Bundle[] bundleArray;
        Bundle bundle = this.bundles.get(symbolicName);
        if (null == bundle) {
            bundleArray = null;
        } else {
            Bundle[] bundleArray2 = new Bundle[1];
            bundleArray = bundleArray2;
            bundleArray2[0] = bundle;
        }
        return bundleArray;
    }

    public Bundle[] getFragments(Bundle bundle) {
        return null;
    }

    public Bundle[] getHosts(Bundle bundle) {
        return null;
    }

    public Bundle getBundle(Class clazz) {
        return this.bundles.get(clazz.getName());
    }

    public int getBundleType(Bundle bundle) {
        return 0;
    }

    public Bundle getBundle() {
        return this.systemBundle;
    }

    public void refreshBundles(Collection<Bundle> bundles, FrameworkListener ... listeners) {
    }

    public boolean resolveBundles(Collection<Bundle> bundles) {
        return true;
    }

    public Collection<Bundle> getRemovalPendingBundles() {
        return Collections.emptyList();
    }

    public Collection<Bundle> getDependencyClosure(Collection<Bundle> bundles) {
        return Collections.emptyList();
    }

    public Collection<BundleCapability> findProviders(Requirement requirement) {
        String filterSpec = (String)requirement.getDirectives().get("filter");
        if (null == filterSpec) {
            throw new IllegalArgumentException("Requirement filter diretive 'filter' not found.");
        }
        try {
            FilterImpl requirementFilter = FilterImpl.newInstance((String)filterSpec);
            Collection<String> requiredSymbolicNames = EclipseBundleLookup.getRequestedSymbolicNames(requirementFilter);
            ArrayList<BundleCapability> capabilities = new ArrayList<BundleCapability>(requiredSymbolicNames.size());
            requiredSymbolicNames.forEach(symbolicName -> {
                Bundle bundle = this.bundles.get((String)symbolicName);
                if (bundle != null) {
                    capabilities.add(new SimpleBundleCapability(bundle));
                }
            });
            return capabilities;
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Filter specifiation invalid:\n" + filterSpec, e);
        }
    }

    private static Collection<String> getRequestedSymbolicNames(FilterImpl filter) {
        List<String> symbolicNames = filter.getStandardOSGiAttributes(new String[0]).entrySet().stream().filter(entry -> OSGI_KEYS_FOR_SYMBOLIC_NAMES.contains(entry.getKey())).map(entry -> (String)entry.getValue()).collect(Collectors.toList());
        filter.getChildren().forEach(childFilter -> symbolicNames.addAll(EclipseBundleLookup.getRequestedSymbolicNames(childFilter)));
        return symbolicNames;
    }
}

