/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.base.service;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.equinox.log.ExtendedLogService;
import org.eclipse.equinox.log.LogFilter;
import org.eclipse.equinox.log.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LoggerConsumer;
import org.slf4j.LoggerFactory;

public class SingleSlf4JService
implements ExtendedLogService,
ExtendedLogReaderService {
    private final org.slf4j.Logger delegate;
    private final Map<LogLevel, LogMethods> logLevel2methods;
    private final Set<LogListener> listener;
    private final BiFunction<String, LogLevel, String> messageCustomizer;

    public SingleSlf4JService(String name, BiFunction<String, LogLevel, String> messageCustomizer) {
        this.delegate = LoggerFactory.getLogger((String)name);
        this.logLevel2methods = new HashMap<LogLevel, LogMethods>();
        this.logLevel2methods.put(LogLevel.AUDIT, SingleSlf4JService.create(() -> true, m -> this.delegate.info(m), (m, e) -> this.delegate.info(m, e)));
        this.logLevel2methods.put(LogLevel.DEBUG, SingleSlf4JService.create(() -> this.delegate.isDebugEnabled(), m -> this.delegate.debug(m), (m, e) -> this.delegate.debug(m, e)));
        this.logLevel2methods.put(LogLevel.ERROR, SingleSlf4JService.create(() -> this.delegate.isErrorEnabled(), m -> this.delegate.error(m), (m, e) -> this.delegate.error(m, e)));
        this.logLevel2methods.put(LogLevel.INFO, SingleSlf4JService.create(() -> this.delegate.isInfoEnabled(), m -> this.delegate.info(m), (m, e) -> this.delegate.info(m, e)));
        this.logLevel2methods.put(LogLevel.TRACE, SingleSlf4JService.create(() -> this.delegate.isTraceEnabled(), m -> this.delegate.trace(m), (m, e) -> this.delegate.trace(m, e)));
        this.logLevel2methods.put(LogLevel.WARN, SingleSlf4JService.create(() -> this.delegate.isWarnEnabled(), m -> this.delegate.warn(m), (m, e) -> this.delegate.warn(m, e)));
        this.listener = new HashSet<LogListener>();
        this.messageCustomizer = messageCustomizer;
    }

    @Deprecated
    public void log(int level, String message) {
        this.log(this, level, message);
    }

    @Deprecated
    public void log(int level, String message, @Nullable Throwable exception) {
        this.log(this, level, message, exception);
    }

    @Deprecated
    public void log(ServiceReference sr, int level, String message) {
        this.log(this, level, message);
    }

    @Deprecated
    public void log(ServiceReference sr, int level, String message, Throwable exception) {
        this.log(this, level, message, exception);
    }

    public void log(Object context, int level, String message) {
        this.log(context, level, message, null);
    }

    public void log(Object context, int level, String message, @Nullable Throwable exception) {
        LogLevel logLevel = SingleSlf4JService.convertDeprectatedOsgiLevel(level);
        this.log(new SimpleLogEntry(logLevel, message, exception));
    }

    public boolean isLoggable(int level) {
        LogLevel logLevel = SingleSlf4JService.convertDeprectatedOsgiLevel(level);
        return this.logLevel2methods.get(logLevel).isEnabled();
    }

    private static LogLevel convertDeprectatedOsgiLevel(int level) {
        switch (level) {
            case 4: {
                return LogLevel.DEBUG;
            }
            case 3: {
                return LogLevel.INFO;
            }
            case 1: {
                return LogLevel.ERROR;
            }
            case 2: {
                return LogLevel.WARN;
            }
        }
        return LogLevel.AUDIT;
    }

    public String getName() {
        return this.delegate.getName();
    }

    public Logger getLogger(String loggerName) {
        return this;
    }

    public Logger getLogger(Bundle bundle, String loggerName) {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogListener(LogListener listener) {
        Set<LogListener> set = this.listener;
        synchronized (set) {
            this.listener.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLogListener(LogListener listener) {
        Set<LogListener> set = this.listener;
        synchronized (set) {
            this.listener.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(LogEntry entry) {
        Set<LogListener> set = this.listener;
        synchronized (set) {
            this.listener.stream().forEach(l -> l.logged(entry));
        }
        String customMessage = this.messageCustomizer.apply(entry.getMessage(), entry.getLogLevel());
        this.logLevel2methods.get(entry.getLogLevel()).log(customMessage, entry.getException());
    }

    @Deprecated
    public Enumeration<LogEntry> getLog() {
        return Collections.emptyEnumeration();
    }

    public void addLogListener(LogListener listener, LogFilter filter) {
        this.addLogListener(listener);
    }

    public org.osgi.service.log.Logger getLogger(Class<?> clazz) {
        return this;
    }

    @Deprecated
    public <L extends org.osgi.service.log.Logger> L getLogger(String name, Class<L> loggerType) {
        throw new UnsupportedOperationException("Logger factory for indifivaul types currently not supported.");
    }

    @Deprecated
    public <L extends org.osgi.service.log.Logger> L getLogger(Class<?> clazz, Class<L> loggerType) {
        return this.getLogger(this.getName(), loggerType);
    }

    @Deprecated
    public <L extends org.osgi.service.log.Logger> L getLogger(Bundle bundle, String name, Class<L> loggerType) {
        return this.getLogger(this.getName(), loggerType);
    }

    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    public void trace(String message) {
        this.log(new SimpleLogEntry(LogLevel.TRACE, message));
    }

    public void trace(String format, Object arg) {
        this.trace(String.format(format, arg));
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.trace(String.format(format, arg1, arg2));
    }

    public void trace(String format, Object ... arguments) {
        this.trace(String.format(format, arguments));
    }

    public <E extends Exception> void trace(LoggerConsumer<E> consumer) throws E {
        consumer.accept((org.osgi.service.log.Logger)this);
    }

    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    public void debug(String message) {
        this.log(new SimpleLogEntry(LogLevel.DEBUG, message));
    }

    public void debug(String format, Object arg) {
        this.debug(String.format(format, arg));
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.debug(String.format(format, arg1, arg2));
    }

    public void debug(String format, Object ... arguments) {
        this.debug(String.format(format, arguments));
    }

    public <E extends Exception> void debug(LoggerConsumer<E> consumer) throws E {
        consumer.accept((org.osgi.service.log.Logger)this);
    }

    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    public void info(String message) {
        this.log(new SimpleLogEntry(LogLevel.INFO, message));
    }

    public void info(String format, Object arg) {
        this.info(String.format(format, arg));
    }

    public void info(String format, Object arg1, Object arg2) {
        this.info(String.format(format, arg1, arg2));
    }

    public void info(String format, Object ... arguments) {
        this.info(String.format(format, arguments));
    }

    public <E extends Exception> void info(LoggerConsumer<E> consumer) throws E {
        consumer.accept((org.osgi.service.log.Logger)this);
    }

    public boolean isWarnEnabled() {
        return this.delegate.isWarnEnabled();
    }

    public void warn(String message) {
        this.log(new SimpleLogEntry(LogLevel.WARN, message));
    }

    public void warn(String format, Object arg) {
        this.warn(String.format(format, arg));
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.warn(String.format(format, arg1, arg2));
    }

    public void warn(String format, Object ... arguments) {
        this.warn(String.format(format, arguments));
    }

    public <E extends Exception> void warn(LoggerConsumer<E> consumer) throws E {
        consumer.accept((org.osgi.service.log.Logger)this);
    }

    public boolean isErrorEnabled() {
        return this.delegate.isErrorEnabled();
    }

    public void error(String message) {
        this.log(new SimpleLogEntry(LogLevel.ERROR, message));
    }

    public void error(String format, Object arg) {
        this.error(String.format(format, arg));
    }

    public void error(String format, Object arg1, Object arg2) {
        this.error(String.format(format, arg1, arg2));
    }

    public void error(String format, Object ... arguments) {
        this.error(String.format(format, arguments));
    }

    public <E extends Exception> void error(LoggerConsumer<E> consumer) throws E {
        consumer.accept((org.osgi.service.log.Logger)this);
    }

    public void audit(String message) {
        this.log(new SimpleLogEntry(LogLevel.AUDIT, message));
    }

    public void audit(String format, Object arg) {
        this.audit(String.format(format, arg));
    }

    public void audit(String format, Object arg1, Object arg2) {
        this.audit(String.format(format, arg1, arg2));
    }

    public void audit(String format, Object ... arguments) {
        this.audit(String.format(format, arguments));
    }

    private static LogMethods create(Supplier<Boolean> enabled, Consumer<String> log, BiConsumer<String, Throwable> logException) {
        return new LogMethods(enabled, log, logException);
    }

    private static class LogMethods {
        private final Supplier<Boolean> enabled;
        private final Consumer<String> log;
        private final BiConsumer<String, Throwable> logException;

        private LogMethods(Supplier<Boolean> enabled, Consumer<String> log, BiConsumer<String, Throwable> logException) {
            this.enabled = enabled;
            this.log = log;
            this.logException = logException;
        }

        public boolean isEnabled() {
            return this.enabled.get();
        }

        public void log(String message) {
            this.log.accept(message);
        }

        public void log(String message, @Nullable Throwable exception) {
            if (null == exception) {
                this.log(message);
            } else {
                this.logException.accept(message, exception);
            }
        }
    }

    private static class SimpleLogEntry
    implements LogEntry {
        private final LogLevel level;
        private final String message;
        private final Optional<Throwable> execption;

        public SimpleLogEntry(LogLevel level, String message) {
            this(level, message, Optional.empty());
        }

        public SimpleLogEntry(LogLevel level, String message, @Nullable Throwable execption) {
            this(level, message, Optional.ofNullable(execption));
        }

        private SimpleLogEntry(LogLevel level, String message, Optional<Throwable> execption) {
            this.level = level;
            this.message = message;
            this.execption = execption;
        }

        public Bundle getBundle() {
            return InternalPlatform.getDefault().getBundleContext().getBundle();
        }

        public ServiceReference getServiceReference() {
            return null;
        }

        @Deprecated
        public int getLevel() {
            switch (this.level) {
                case DEBUG: 
                case TRACE: {
                    return 4;
                }
                case AUDIT: 
                case INFO: {
                    return 3;
                }
                case ERROR: {
                    return 1;
                }
                case WARN: {
                    return 2;
                }
            }
            return 1;
        }

        public String getMessage() {
            return this.message;
        }

        public Throwable getException() {
            return this.execption.orElse(null);
        }

        public long getTime() {
            return 0L;
        }

        public String toString() {
            StringWriter result = new StringWriter();
            result.write(this.message);
            if (this.execption.isPresent()) {
                result.write(10);
                result.write(this.execption.get().toString());
                result.write(10);
                this.execption.get().printStackTrace(new PrintWriter(result));
            }
            return result.toString();
        }

        public LogLevel getLogLevel() {
            return this.level;
        }

        public String getLoggerName() {
            return this.getClass().getSimpleName();
        }

        public long getSequence() {
            return 0L;
        }

        public String getThreadInfo() {
            return null;
        }

        public StackTraceElement getLocation() {
            return null;
        }
    }
}

