/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.antlr4;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.ThrowingEx;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Antlr4FormatterStep {
    public static final String NAME = "antlr4Formatter";
    private static final String MAVEN_COORDINATE = "com.khubla.antlr4formatter:antlr4-formatter:";
    private static final String DEFAULT_VERSION = "1.2.1";

    private Antlr4FormatterStep() {
    }

    public static FormatterStep create(Provisioner provisioner) {
        return Antlr4FormatterStep.create(Antlr4FormatterStep.defaultVersion(), provisioner);
    }

    public static FormatterStep create(String version, Provisioner provisioner) {
        return FormatterStep.createLazy(NAME, () -> new State(version, provisioner), State::createFormat);
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final JarState jarState;

        State(String version, Provisioner provisioner) throws IOException {
            this.jarState = JarState.from(Antlr4FormatterStep.MAVEN_COORDINATE + version, provisioner);
        }

        FormatterFunc createFormat() throws ClassNotFoundException, NoSuchMethodException {
            ClassLoader classLoader = this.jarState.getClassLoader();
            Class<?> formatter = classLoader.loadClass("com.khubla.antlr4formatter.Antlr4Formatter");
            Method formatterMethod = formatter.getMethod("format", String.class);
            return input -> {
                try {
                    return (String)formatterMethod.invoke(null, input);
                }
                catch (InvocationTargetException e) {
                    throw ThrowingEx.unwrapCause(e);
                }
            };
        }
    }
}

