/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.ThrowingEx;
import com.diffplug.spotless.npm.JsonEscaper;
import com.diffplug.spotless.npm.JsonRawValue;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class SimpleJsonWriter {
    private final LinkedHashMap<String, Object> valueMap = new LinkedHashMap();

    public static SimpleJsonWriter of(Map<String, ?> values) {
        SimpleJsonWriter writer = new SimpleJsonWriter();
        writer.putAll(values);
        return writer;
    }

    SimpleJsonWriter putAll(Map<String, ?> values) {
        this.verifyValues(values);
        this.valueMap.putAll(values);
        return this;
    }

    SimpleJsonWriter put(String name, Object value) {
        this.verifyValues(Collections.singletonMap(name, value));
        this.valueMap.put(name, value);
        return this;
    }

    private void verifyValues(Map<String, ?> values) {
        if (values.values().stream().anyMatch(val -> !(val instanceof String) && !(val instanceof JsonRawValue) && !(val instanceof Number) && !(val instanceof Boolean))) {
            throw new IllegalArgumentException("Only values of type 'String', 'JsonRawValue', 'Number' and 'Boolean' are supported. You provided: " + values.values());
        }
    }

    String toJsonString() {
        String valueString = this.valueMap.entrySet().stream().map(entry -> "    " + JsonEscaper.jsonEscape(entry.getKey()) + ": " + JsonEscaper.jsonEscape(entry.getValue())).collect(Collectors.joining(",\n"));
        return "{\n" + valueString + "\n}";
    }

    JsonRawValue toJsonRawValue() {
        return JsonRawValue.wrap(this.toJsonString());
    }

    void toJsonFile(File file) {
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new RuntimeException("Cannot write to file");
        }
        try {
            Files.write(file.toPath(), this.toJsonString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw ThrowingEx.asRuntime(e);
        }
    }

    public String toString() {
        return this.toJsonString();
    }
}

