/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.npm.NpmResourceHelper;
import com.diffplug.spotless.npm.SimpleJsonWriter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

class SimpleRestClient {
    private final String baseUrl;

    private SimpleRestClient(String baseUrl) {
        this.baseUrl = Objects.requireNonNull(baseUrl);
    }

    static SimpleRestClient forBaseUrl(String baseUrl) {
        return new SimpleRestClient(baseUrl);
    }

    String postJson(String endpoint, Map<String, Object> jsonParams) throws SimpleRestException {
        SimpleJsonWriter jsonWriter = SimpleJsonWriter.of(jsonParams);
        String jsonString = jsonWriter.toJsonString();
        return this.postJson(endpoint, jsonString);
    }

    String post(String endpoint) throws SimpleRestException {
        return this.postJson(endpoint, (String)null);
    }

    String postJson(String endpoint, String rawJson) throws SimpleRestException {
        try {
            int status;
            URL url = new URL(this.baseUrl + endpoint);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setConnectTimeout(60000);
            con.setReadTimeout(120000);
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/json");
            con.setDoOutput(true);
            if (rawJson != null) {
                try (OutputStream out = con.getOutputStream();){
                    NpmResourceHelper.writeUtf8StringToOutputStream(rawJson, out);
                    out.flush();
                }
            }
            if ((status = con.getResponseCode()) != 200) {
                throw new SimpleRestResponseException(status, this.readError(con), "Unexpected response status code at " + endpoint);
            }
            String response = this.readResponse(con);
            return response;
        }
        catch (IOException e) {
            throw new SimpleRestIOException(e);
        }
    }

    private String readError(HttpURLConnection con) throws IOException {
        return this.readInputStream(con.getErrorStream());
    }

    private String readResponse(HttpURLConnection con) throws IOException {
        return this.readInputStream(con.getInputStream());
    }

    private String readInputStream(InputStream inputStream) throws IOException {
        try (BufferedInputStream input = new BufferedInputStream(inputStream);){
            String string = NpmResourceHelper.readUtf8StringFromInputStream(input);
            return string;
        }
    }

    static class SimpleRestIOException
    extends SimpleRestException {
        private static final long serialVersionUID = -7909757660531122308L;

        public SimpleRestIOException(Throwable cause) {
            super(cause);
        }
    }

    static class SimpleRestResponseException
    extends SimpleRestException {
        private static final long serialVersionUID = -7637152299410053401L;
        private final int statusCode;
        private final String responseMessage;
        private final String exceptionMessage;

        public SimpleRestResponseException(int statusCode, String responseMessage, String exceptionmessage) {
            this.statusCode = statusCode;
            this.responseMessage = responseMessage;
            this.exceptionMessage = exceptionmessage;
        }

        @Nonnull
        public int getStatusCode() {
            return this.statusCode;
        }

        @Nonnull
        public String getResponseMessage() {
            return this.responseMessage;
        }

        @Nonnull
        public String getExceptionMessage() {
            return this.exceptionMessage;
        }

        @Override
        public String getMessage() {
            return String.format("%s [HTTP %s] -- (%s)", this.getExceptionMessage(), this.getStatusCode(), this.getResponseMessage());
        }
    }

    static abstract class SimpleRestException
    extends RuntimeException {
        private static final long serialVersionUID = -8260821395756603787L;

        public SimpleRestException() {
        }

        public SimpleRestException(Throwable cause) {
            super(cause);
        }
    }
}

