/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.apache.http.client.protocol;

import com.facebook.presto.jdbc.internal.apache.http.HttpEntity;
import com.facebook.presto.jdbc.internal.apache.http.HttpEntityEnclosingRequest;
import com.facebook.presto.jdbc.internal.apache.http.HttpException;
import com.facebook.presto.jdbc.internal.apache.http.HttpRequest;
import com.facebook.presto.jdbc.internal.apache.http.HttpRequestInterceptor;
import com.facebook.presto.jdbc.internal.apache.http.HttpVersion;
import com.facebook.presto.jdbc.internal.apache.http.ProtocolVersion;
import com.facebook.presto.jdbc.internal.apache.http.annotation.Contract;
import com.facebook.presto.jdbc.internal.apache.http.annotation.ThreadingBehavior;
import com.facebook.presto.jdbc.internal.apache.http.client.config.RequestConfig;
import com.facebook.presto.jdbc.internal.apache.http.client.protocol.HttpClientContext;
import com.facebook.presto.jdbc.internal.apache.http.protocol.HttpContext;
import com.facebook.presto.jdbc.internal.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

