/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.com.facebook.airlift.json;

import com.facebook.presto.jdbc.internal.com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.jdbc.internal.com.facebook.airlift.json.ObjectMapperProvider;
import com.facebook.presto.jdbc.internal.guava.reflect.TypeParameter;
import com.facebook.presto.jdbc.internal.guava.reflect.TypeToken;
import com.facebook.presto.jdbc.internal.inject.Inject;
import com.facebook.presto.jdbc.internal.inject.Provider;
import com.facebook.presto.jdbc.internal.jackson.databind.ObjectMapper;
import com.facebook.presto.jdbc.internal.jackson.databind.SerializationFeature;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JsonCodecFactory {
    private final Provider<ObjectMapper> objectMapperProvider;
    private final boolean prettyPrint;

    public JsonCodecFactory() {
        this(new ObjectMapperProvider());
    }

    @Inject
    public JsonCodecFactory(Provider<ObjectMapper> objectMapperProvider) {
        this(objectMapperProvider, false);
    }

    public JsonCodecFactory(Provider<ObjectMapper> objectMapperProvider, boolean prettyPrint) {
        this.objectMapperProvider = objectMapperProvider;
        this.prettyPrint = prettyPrint;
    }

    public JsonCodecFactory prettyPrint() {
        return new JsonCodecFactory(this.objectMapperProvider, true);
    }

    public <T> JsonCodec<T> jsonCodec(Class<T> type) {
        Objects.requireNonNull(type, "type is null");
        return new JsonCodec(this.createObjectMapper(), type);
    }

    public <T> JsonCodec<T> jsonCodec(Type type) {
        Objects.requireNonNull(type, "type is null");
        return new JsonCodec(this.createObjectMapper(), type);
    }

    public <T> JsonCodec<T> jsonCodec(TypeToken<T> type) {
        Objects.requireNonNull(type, "type is null");
        return new JsonCodec(this.createObjectMapper(), type.getType());
    }

    public <T> JsonCodec<List<T>> listJsonCodec(Class<T> type) {
        Objects.requireNonNull(type, "type is null");
        Type listType = new TypeToken<List<T>>(){}.where(new TypeParameter<T>(){}, type).getType();
        return new JsonCodec<List<T>>(this.createObjectMapper(), listType);
    }

    public <T> JsonCodec<List<T>> listJsonCodec(JsonCodec<T> type) {
        Objects.requireNonNull(type, "type is null");
        Type listType = new TypeToken<List<T>>(){}.where(new TypeParameter<T>(){}, type.getTypeToken()).getType();
        return new JsonCodec<List<T>>(this.createObjectMapper(), listType);
    }

    public <K, V> JsonCodec<Map<K, V>> mapJsonCodec(Class<K> keyType, Class<V> valueType) {
        Objects.requireNonNull(keyType, "keyType is null");
        Objects.requireNonNull(valueType, "valueType is null");
        Type mapType = new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType).getType();
        return new JsonCodec<Map<K, V>>(this.createObjectMapper(), mapType);
    }

    public <K, V> JsonCodec<Map<K, V>> mapJsonCodec(Class<K> keyType, JsonCodec<V> valueType) {
        Objects.requireNonNull(keyType, "keyType is null");
        Objects.requireNonNull(valueType, "valueType is null");
        Type mapType = new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType.getTypeToken()).getType();
        return new JsonCodec<Map<K, V>>(this.createObjectMapper(), mapType);
    }

    private ObjectMapper createObjectMapper() {
        return this.objectMapperProvider.get().configure(SerializationFeature.INDENT_OUTPUT, this.prettyPrint);
    }
}

