/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.block;

import com.facebook.presto.jdbc.internal.common.block.BlockBuilderStatus;

public class PageBuilderStatus {
    public static final int DEFAULT_MAX_PAGE_SIZE_IN_BYTES = 0x100000;
    private final int maxPageSizeInBytes;
    private long currentSize;

    public PageBuilderStatus() {
        this(0x100000);
    }

    public PageBuilderStatus(int maxPageSizeInBytes) {
        this.maxPageSizeInBytes = maxPageSizeInBytes;
    }

    public BlockBuilderStatus createBlockBuilderStatus() {
        return new BlockBuilderStatus(this);
    }

    public int getMaxPageSizeInBytes() {
        return this.maxPageSizeInBytes;
    }

    public boolean isEmpty() {
        return this.currentSize == 0L;
    }

    public boolean isFull() {
        return this.currentSize >= (long)this.maxPageSizeInBytes;
    }

    void addBytes(int bytes) {
        if (bytes < 0) {
            throw new IllegalArgumentException("bytes cannot be negative");
        }
        this.currentSize += (long)bytes;
    }

    public long getSizeInBytes() {
        return this.currentSize;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("BlockBuilderStatus{");
        buffer.append("maxSizeInBytes=").append(this.maxPageSizeInBytes);
        buffer.append(", currentSize=").append(this.currentSize);
        buffer.append('}');
        return buffer.toString();
    }
}

