/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.type;

import com.facebook.presto.jdbc.internal.common.type.LongEnumType;
import com.facebook.presto.jdbc.internal.common.type.NamedTypeSignature;
import com.facebook.presto.jdbc.internal.common.type.ParameterKind;
import com.facebook.presto.jdbc.internal.common.type.RowFieldName;
import com.facebook.presto.jdbc.internal.common.type.TypeSignatureParameter;
import com.facebook.presto.jdbc.internal.common.type.VarcharEnumType;
import com.facebook.presto.jdbc.internal.common.type.VarcharType;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class TypeSignature {
    private final String base;
    private final List<TypeSignatureParameter> parameters;
    private final boolean calculated;
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("[a-zA-Z_]([a-zA-Z0-9_:@])*");
    private static final Map<String, String> BASE_NAME_ALIAS_TO_CANONICAL = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private static final Set<String> SIMPLE_TYPE_WITH_SPACES = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private static final String LONG_ENUM_PREFIX = "enum:bigint";
    private static final String VARCHAR_ENUM_PREFIX = "enum:varchar";
    private static final Pattern ENUM_PREFIX = Pattern.compile("enum:(bigint|varchar)\\{");

    public TypeSignature(String base, TypeSignatureParameter ... parameters) {
        this(base, Arrays.asList(parameters));
    }

    public TypeSignature(String base, List<TypeSignatureParameter> parameters) {
        TypeSignature.checkArgument(base != null, "base is null", new Object[0]);
        this.base = base;
        TypeSignature.checkArgument(!base.isEmpty(), "base is empty", new Object[0]);
        TypeSignature.checkArgument(TypeSignature.validateName(base), "Bad characters in base type: %s", base);
        TypeSignature.checkArgument(parameters != null, "parameters is null", new Object[0]);
        this.parameters = Collections.unmodifiableList(new ArrayList<TypeSignatureParameter>(parameters));
        this.calculated = parameters.stream().anyMatch(TypeSignatureParameter::isCalculated);
    }

    public String getBase() {
        return this.base;
    }

    public List<TypeSignatureParameter> getParameters() {
        return this.parameters;
    }

    public List<TypeSignature> getTypeParametersAsTypeSignatures() {
        ArrayList<TypeSignature> result = new ArrayList<TypeSignature>();
        for (TypeSignatureParameter parameter : this.parameters) {
            if (parameter.getKind() != ParameterKind.TYPE) {
                throw new IllegalStateException(String.format("Expected all parameters to be TypeSignatures but [%s] was found", parameter.toString()));
            }
            result.add(parameter.getTypeSignature());
        }
        return result;
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public boolean isEnum() {
        return this.isLongEnum() || this.isVarcharEnum();
    }

    public boolean isLongEnum() {
        return this.parameters.size() == 1 && this.parameters.get(0).isLongEnum();
    }

    public boolean isVarcharEnum() {
        return this.parameters.size() == 1 && this.parameters.get(0).isVarcharEnum();
    }

    @JsonCreator
    public static TypeSignature parseTypeSignature(String signature) {
        return TypeSignature.parseTypeSignature(signature, new HashSet<String>());
    }

    public static TypeSignature parseTypeSignature(String signature, Set<String> literalCalculationParameters) {
        if (!signature.contains("<") && !signature.contains("(")) {
            if (signature.equalsIgnoreCase("varchar")) {
                return VarcharType.createUnboundedVarcharType().getTypeSignature();
            }
            TypeSignature.checkArgument(!literalCalculationParameters.contains(signature), "Bad type signature: '%s'", signature);
            return new TypeSignature(TypeSignature.canonicalizeBaseName(signature), new ArrayList<TypeSignatureParameter>());
        }
        String lowerCaseSignature = signature.toLowerCase(Locale.ENGLISH);
        if (lowerCaseSignature.startsWith("row(")) {
            return TypeSignature.parseRowTypeSignature(signature, literalCalculationParameters);
        }
        Set<Integer> enumMapStartIndices = TypeSignature.findEnumMapStartIndices(lowerCaseSignature);
        String baseName = null;
        ArrayList<TypeSignatureParameter> parameters = new ArrayList<TypeSignatureParameter>();
        int parameterStart = -1;
        int bracketCount = 0;
        int parameterEnd = -1;
        for (int i = 0; i < signature.length(); ++i) {
            if (i < parameterEnd) continue;
            char c = signature.charAt(i);
            if (c == '(' || c == '<') {
                if (bracketCount == 0) {
                    TypeSignature.verify(baseName == null, "Expected baseName to be null");
                    TypeSignature.verify(parameterStart == -1, "Expected parameter start to be -1");
                    baseName = TypeSignature.canonicalizeBaseName(signature.substring(0, i));
                    TypeSignature.checkArgument(!literalCalculationParameters.contains(baseName), "Bad type signature: '%s'", signature);
                    parameterStart = i + 1;
                }
                ++bracketCount;
                continue;
            }
            if (c == ')' || c == '>') {
                TypeSignature.checkArgument(--bracketCount >= 0, "Bad type signature: '%s'", signature);
                if (bracketCount != 0) continue;
                TypeSignature.checkArgument(parameterStart >= 0, "Bad type signature: '%s'", signature);
                parameters.add(TypeSignature.parseTypeSignatureParameter(signature, parameterStart, i, literalCalculationParameters, enumMapStartIndices));
                parameterStart = i + 1;
                if (i != signature.length() - 1) continue;
                return new TypeSignature(baseName, parameters);
            }
            if (enumMapStartIndices.contains(i)) {
                parameterEnd = TypeSignature.parseEnumMap((String)signature, (int)i).mapEndIndex;
                continue;
            }
            if (c != ',' || bracketCount != 1) continue;
            TypeSignature.checkArgument(parameterStart >= 0, "Bad type signature: '%s'", signature);
            parameters.add(TypeSignature.parseTypeSignatureParameter(signature, parameterStart, i, literalCalculationParameters, enumMapStartIndices));
            parameterStart = i + 1;
        }
        throw new IllegalArgumentException(String.format("Bad type signature: '%s'", signature));
    }

    private static Set<Integer> findEnumMapStartIndices(String signature) {
        HashSet<Integer> indices = new HashSet<Integer>();
        Matcher enumMatcher = ENUM_PREFIX.matcher(signature);
        while (enumMatcher.find()) {
            indices.add(enumMatcher.start());
        }
        return indices;
    }

    private static EnumMapParsingData parseEnumMap(String signature, int startIndex) {
        EnumMapParsingState state = EnumMapParsingState.EXPECT_KEY;
        boolean isLongEnum = signature.substring(startIndex).trim().toLowerCase(Locale.ENGLISH).startsWith(LONG_ENUM_PREFIX);
        int openBracketIndex = startIndex + (isLongEnum ? LONG_ENUM_PREFIX.length() : VARCHAR_ENUM_PREFIX.length()) + 1;
        String key = null;
        StringBuilder keyOrValue = new StringBuilder();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = openBracketIndex; i < signature.length(); ++i) {
            char c = signature.charAt(i);
            if (state == EnumMapParsingState.IN_KEY_ESCAPE) {
                state = EnumMapParsingState.IN_KEY;
                keyOrValue.append(c);
            }
            if (state == EnumMapParsingState.IN_STR_VALUE_ESCAPE) {
                state = EnumMapParsingState.IN_STR_VALUE;
                keyOrValue.append(c);
                continue;
            }
            if (c == '\"') {
                if (state == EnumMapParsingState.EXPECT_KEY) {
                    state = EnumMapParsingState.IN_KEY;
                    continue;
                }
                if (state == EnumMapParsingState.EXPECT_VALUE) {
                    if (isLongEnum) {
                        throw new IllegalStateException("Unexpected varchar value in numeric enum signature");
                    }
                    state = EnumMapParsingState.IN_STR_VALUE;
                    continue;
                }
                if ((state == EnumMapParsingState.IN_KEY || state == EnumMapParsingState.IN_STR_VALUE) && i + 1 < signature.length() && signature.charAt(i + 1) == '\"') {
                    state = state == EnumMapParsingState.IN_KEY ? EnumMapParsingState.IN_KEY_ESCAPE : EnumMapParsingState.IN_STR_VALUE_ESCAPE;
                    continue;
                }
                if (state == EnumMapParsingState.IN_KEY) {
                    state = EnumMapParsingState.EXPECT_COLON;
                    continue;
                }
                if (state == EnumMapParsingState.IN_STR_VALUE) {
                    state = EnumMapParsingState.EXPECT_COMMA_OR_CLOSING_BRACKET;
                    continue;
                }
                throw new IllegalStateException("Cannot parse enum signature");
            }
            if (state == EnumMapParsingState.IN_KEY || state == EnumMapParsingState.IN_STR_VALUE) {
                keyOrValue.append(c);
                continue;
            }
            if (c == ':' && state == EnumMapParsingState.EXPECT_COLON) {
                key = keyOrValue.toString();
                keyOrValue = new StringBuilder();
                state = EnumMapParsingState.EXPECT_VALUE;
                continue;
            }
            if ((Character.isDigit(c) || c == '-') && state == EnumMapParsingState.EXPECT_VALUE) {
                if (!isLongEnum) {
                    throw new IllegalStateException("Unexpected numeric value in varchar enum signature");
                }
                state = EnumMapParsingState.IN_NUM_VALUE;
                keyOrValue.append(c);
                continue;
            }
            if (Character.isDigit(c) && state == EnumMapParsingState.IN_NUM_VALUE) {
                keyOrValue.append(c);
                continue;
            }
            if (!(c != ',' && c != '}' || state != EnumMapParsingState.EXPECT_COMMA_OR_CLOSING_BRACKET && state != EnumMapParsingState.IN_NUM_VALUE)) {
                if (key == null) {
                    throw new IllegalStateException("Cannot parse enum signature");
                }
                map.put(key, keyOrValue.toString());
                if (c == '}') {
                    return new EnumMapParsingData(i, map, isLongEnum);
                }
                key = null;
                keyOrValue = new StringBuilder();
                state = EnumMapParsingState.EXPECT_KEY;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            throw new IllegalStateException("Cannot parse enum signature");
        }
        throw new IllegalStateException("Cannot parse enum signature");
    }

    private static TypeSignature parseRowTypeSignature(String signature, Set<String> literalParameters) {
        TypeSignature.checkArgument(signature.toLowerCase(Locale.ENGLISH).startsWith("row("), "Not a row type signature: '%s'", signature);
        RowTypeSignatureParsingState state = RowTypeSignatureParsingState.START_OF_FIELD;
        int bracketLevel = 1;
        int tokenStart = -1;
        String delimitedColumnName = null;
        ArrayList<TypeSignatureParameter> fields = new ArrayList<TypeSignatureParameter>();
        block8: for (int i = "row".length() + 1; i < signature.length(); ++i) {
            char c = signature.charAt(i);
            switch (state) {
                case START_OF_FIELD: {
                    if (c == '\"') {
                        state = RowTypeSignatureParsingState.DELIMITED_NAME;
                        tokenStart = i;
                        continue block8;
                    }
                    if (TypeSignature.isValidStartOfIdentifier(c)) {
                        state = RowTypeSignatureParsingState.TYPE_OR_NAMED_TYPE;
                        tokenStart = i;
                        continue block8;
                    }
                    TypeSignature.checkArgument(c == ' ', "Bad type signature: '%s'", signature);
                    continue block8;
                }
                case DELIMITED_NAME: {
                    if (c != '\"') continue block8;
                    if (i + 1 < signature.length() && signature.charAt(i + 1) == '\"') {
                        state = RowTypeSignatureParsingState.DELIMITED_NAME_ESCAPED;
                        continue block8;
                    }
                    TypeSignature.verify(tokenStart >= 0, "Expect tokenStart to be non-negative");
                    delimitedColumnName = signature.substring(tokenStart + 1, i);
                    tokenStart = i + 1;
                    state = RowTypeSignatureParsingState.TYPE;
                    continue block8;
                }
                case DELIMITED_NAME_ESCAPED: {
                    TypeSignature.verify(c == '\"', "Expect quote after escape");
                    state = RowTypeSignatureParsingState.DELIMITED_NAME;
                    continue block8;
                }
                case TYPE_OR_NAMED_TYPE: {
                    if (c == '(') {
                        ++bracketLevel;
                        continue block8;
                    }
                    if (c == ')' && bracketLevel > 1) {
                        --bracketLevel;
                        continue block8;
                    }
                    if (c == ')') {
                        TypeSignature.verify(tokenStart >= 0, "Expect tokenStart to be non-negative");
                        fields.add(TypeSignature.parseTypeOrNamedType(signature.substring(tokenStart, i).trim(), literalParameters));
                        tokenStart = -1;
                        state = RowTypeSignatureParsingState.FINISHED;
                        continue block8;
                    }
                    if (c != ',' || bracketLevel != 1) continue block8;
                    TypeSignature.verify(tokenStart >= 0, "Expect tokenStart to be non-negative");
                    fields.add(TypeSignature.parseTypeOrNamedType(signature.substring(tokenStart, i).trim(), literalParameters));
                    tokenStart = -1;
                    state = RowTypeSignatureParsingState.START_OF_FIELD;
                    continue block8;
                }
                case TYPE: {
                    if (c == '(') {
                        ++bracketLevel;
                        continue block8;
                    }
                    if (c == ')' && bracketLevel > 1) {
                        --bracketLevel;
                        continue block8;
                    }
                    if (c == ')') {
                        TypeSignature.verify(tokenStart >= 0, "Expect tokenStart to be non-negative");
                        TypeSignature.verify(delimitedColumnName != null, "Expect delimitedColumnName to be non-null");
                        fields.add(TypeSignatureParameter.of(new NamedTypeSignature(Optional.of(new RowFieldName(delimitedColumnName, true)), TypeSignature.parseTypeSignature(signature.substring(tokenStart, i).trim(), literalParameters))));
                        delimitedColumnName = null;
                        tokenStart = -1;
                        state = RowTypeSignatureParsingState.FINISHED;
                        continue block8;
                    }
                    if (c != ',' || bracketLevel != 1) continue block8;
                    TypeSignature.verify(tokenStart >= 0, "Expect tokenStart to be non-negative");
                    TypeSignature.verify(delimitedColumnName != null, "Expect delimitedColumnName to be non-null");
                    fields.add(TypeSignatureParameter.of(new NamedTypeSignature(Optional.of(new RowFieldName(delimitedColumnName, true)), TypeSignature.parseTypeSignature(signature.substring(tokenStart, i).trim(), literalParameters))));
                    delimitedColumnName = null;
                    tokenStart = -1;
                    state = RowTypeSignatureParsingState.START_OF_FIELD;
                    continue block8;
                }
                case FINISHED: {
                    throw new IllegalStateException(String.format("Bad type signature: '%s'", signature));
                }
                default: {
                    throw new AssertionError((Object)String.format("Unexpected RowTypeSignatureParsingState: %s", new Object[]{state}));
                }
            }
        }
        TypeSignature.checkArgument(state == RowTypeSignatureParsingState.FINISHED, "Bad type signature: '%s'", signature);
        return new TypeSignature(signature.substring(0, "row".length()), fields);
    }

    private static TypeSignatureParameter parseTypeOrNamedType(String typeOrNamedType, Set<String> literalParameters) {
        int split = typeOrNamedType.indexOf(32);
        if (split == -1 || SIMPLE_TYPE_WITH_SPACES.contains(typeOrNamedType)) {
            return TypeSignatureParameter.of(new NamedTypeSignature(Optional.empty(), TypeSignature.parseTypeSignature(typeOrNamedType, literalParameters)));
        }
        String firstPart = typeOrNamedType.substring(0, split);
        if (IDENTIFIER_PATTERN.matcher(firstPart).matches()) {
            return TypeSignatureParameter.of(new NamedTypeSignature(Optional.of(new RowFieldName(firstPart, false)), TypeSignature.parseTypeSignature(typeOrNamedType.substring(split + 1).trim(), literalParameters)));
        }
        return TypeSignatureParameter.of(new NamedTypeSignature(Optional.empty(), TypeSignature.parseTypeSignature(typeOrNamedType, literalParameters)));
    }

    private static TypeSignatureParameter parseTypeSignatureParameter(String signature, int begin, int end, Set<String> literalCalculationParameters, Set<Integer> enumStartIndices) {
        String parameterName = signature.substring(begin, end).trim();
        if (Character.isDigit(signature.charAt(begin))) {
            return TypeSignatureParameter.of(Long.parseLong(parameterName));
        }
        if (literalCalculationParameters.contains(parameterName)) {
            return TypeSignatureParameter.of(parameterName);
        }
        if (enumStartIndices.contains(begin)) {
            if (!parameterName.endsWith("}")) {
                throw new IllegalStateException("Cannot parse enum signature");
            }
            EnumMapParsingData enumMapData = TypeSignature.parseEnumMap(signature, begin);
            if (enumMapData.isLongEnum) {
                return TypeSignatureParameter.of(enumMapData.getLongEnumMap());
            }
            return TypeSignatureParameter.of(enumMapData.getVarcharEnumMap());
        }
        return TypeSignatureParameter.of(TypeSignature.parseTypeSignature(parameterName, literalCalculationParameters));
    }

    private static boolean isValidStartOfIdentifier(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    @JsonValue
    public String toString() {
        if (this.parameters.isEmpty()) {
            return this.base;
        }
        if (this.base.equalsIgnoreCase("varchar") && this.parameters.size() == 1 && this.parameters.get(0).isLongLiteral() && this.parameters.get(0).getLongLiteral() == Integer.MAX_VALUE) {
            return this.base;
        }
        StringBuilder typeName = new StringBuilder(this.base);
        typeName.append("(").append(this.parameters.get(0));
        for (int i = 1; i < this.parameters.size(); ++i) {
            typeName.append(",").append(this.parameters.get(i));
        }
        typeName.append(")");
        return typeName.toString();
    }

    private static void checkArgument(boolean argument, String format, Object ... args) {
        if (!argument) {
            throw new IllegalArgumentException(String.format(format, args));
        }
    }

    private static void verify(boolean argument, String message) {
        if (!argument) {
            throw new AssertionError((Object)message);
        }
    }

    private static boolean validateName(String name) {
        return name.chars().noneMatch(c -> c == 60 || c == 62 || c == 44);
    }

    private static String canonicalizeBaseName(String baseName) {
        String canonicalBaseName = BASE_NAME_ALIAS_TO_CANONICAL.get(baseName);
        if (canonicalBaseName == null) {
            return baseName;
        }
        return canonicalBaseName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeSignature other = (TypeSignature)o;
        return Objects.equals(this.base.toLowerCase(Locale.ENGLISH), other.base.toLowerCase(Locale.ENGLISH)) && Objects.equals(this.parameters, other.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.base.toLowerCase(Locale.ENGLISH), this.parameters);
    }

    static {
        BASE_NAME_ALIAS_TO_CANONICAL.put("int", "integer");
        SIMPLE_TYPE_WITH_SPACES.add("time with time zone");
        SIMPLE_TYPE_WITH_SPACES.add("timestamp with time zone");
        SIMPLE_TYPE_WITH_SPACES.add("interval day to second");
        SIMPLE_TYPE_WITH_SPACES.add("interval year to month");
        SIMPLE_TYPE_WITH_SPACES.add("double precision");
    }

    private static enum RowTypeSignatureParsingState {
        START_OF_FIELD,
        DELIMITED_NAME,
        DELIMITED_NAME_ESCAPED,
        TYPE_OR_NAMED_TYPE,
        TYPE,
        FINISHED;

    }

    private static enum EnumMapParsingState {
        EXPECT_KEY,
        IN_KEY,
        IN_KEY_ESCAPE,
        EXPECT_COLON,
        EXPECT_VALUE,
        IN_NUM_VALUE,
        IN_STR_VALUE,
        IN_STR_VALUE_ESCAPE,
        EXPECT_COMMA_OR_CLOSING_BRACKET;

    }

    private static class EnumMapParsingData {
        final int mapEndIndex;
        private final Map<String, String> map;
        final boolean isLongEnum;

        EnumMapParsingData(int mapEndIndex, Map<String, String> map, boolean isLongEnum) {
            this.mapEndIndex = mapEndIndex;
            this.map = map;
            this.isLongEnum = isLongEnum;
        }

        LongEnumType.LongEnumMap getLongEnumMap() {
            TypeSignature.checkArgument(this.isLongEnum, "Invalid enum map format", new Object[0]);
            return new LongEnumType.LongEnumMap(this.map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Long.parseLong((String)e.getValue()))));
        }

        VarcharEnumType.VarcharEnumMap getVarcharEnumMap() {
            TypeSignature.checkArgument(!this.isLongEnum, "Invalid enum map format", new Object[0]);
            return new VarcharEnumType.VarcharEnumMap(this.map);
        }
    }
}

