/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.type;

import com.facebook.presto.jdbc.internal.common.type.ParameterKind;
import com.facebook.presto.jdbc.internal.common.type.ParametricType;
import com.facebook.presto.jdbc.internal.common.type.Type;
import com.facebook.presto.jdbc.internal.common.type.TypeParameter;
import com.facebook.presto.jdbc.internal.common.type.VarcharEnumType;
import java.util.List;

public final class VarcharEnumParametricType
implements ParametricType {
    private final String name;
    private final VarcharEnumType.VarcharEnumMap enumMap;

    public VarcharEnumParametricType(String name, VarcharEnumType.VarcharEnumMap enumMap) {
        this.name = name;
        this.enumMap = enumMap;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Type createType(List<TypeParameter> parameters) {
        if (parameters.isEmpty()) {
            return new VarcharEnumType(this.name, this.enumMap);
        }
        VarcharEnumParametricType.checkArgument(parameters.size() == 1, "Enum type expects exactly one parameter, got %s", parameters);
        VarcharEnumParametricType.checkArgument(parameters.get(0).getKind() == ParameterKind.VARCHAR_ENUM, "Enum definition expected, got %s", parameters);
        return new VarcharEnumType(this.name, parameters.get(0).getVarcharEnumMap());
    }

    private static void checkArgument(boolean argument, String format, Object ... args) {
        if (!argument) {
            throw new IllegalArgumentException(String.format(format, args));
        }
    }
}

