/*
 * Decompiled with CFR 0.152.
 */
package com.github.abel533.provider;

import com.github.abel533.mapperhelper.EntityHelper;
import com.github.abel533.mapperhelper.MapperHelper;
import com.github.abel533.mapperhelper.MapperTemplate;
import java.util.LinkedList;
import java.util.Set;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.scripting.xmltags.IfSqlNode;
import org.apache.ibatis.scripting.xmltags.MixedSqlNode;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.scripting.xmltags.StaticTextSqlNode;
import org.apache.ibatis.scripting.xmltags.TrimSqlNode;

public class SqlServerProvider
extends MapperTemplate {
    public SqlServerProvider(Class<?> mapperClass, MapperHelper mapperHelper) {
        super(mapperClass, mapperHelper);
    }

    public String insert(MappedStatement ms) {
        Class<?> entityClass = this.getSelectReturnType(ms);
        EntityHelper.EntityTable table = EntityHelper.getEntityTable(entityClass);
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ");
        sql.append(table.getName());
        sql.append("(");
        boolean first = true;
        for (EntityHelper.EntityColumn column : table.getEntityClassColumns()) {
            if (column.isId()) continue;
            if (!first) {
                sql.append(",");
            }
            sql.append(column.getColumn());
            first = false;
        }
        sql.append(") values(");
        first = true;
        for (EntityHelper.EntityColumn column : table.getEntityClassColumns()) {
            if (column.isId()) continue;
            if (!first) {
                sql.append(",");
            }
            sql.append("#{").append(column.getProperty()).append("}");
            first = false;
        }
        sql.append(")");
        return sql.toString();
    }

    public SqlNode insertSelective(MappedStatement ms) {
        Class<?> entityClass = this.getSelectReturnType(ms);
        LinkedList<Object> sqlNodes = new LinkedList<Object>();
        sqlNodes.add(new StaticTextSqlNode("INSERT INTO " + this.tableName(entityClass)));
        Set<EntityHelper.EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        LinkedList<Object> ifNodes = new LinkedList<Object>();
        Boolean hasIdentityKey = false;
        for (EntityHelper.EntityColumn column : columnList) {
            if (column.isId()) continue;
            ifNodes.add(this.getIfNotNull(column, (SqlNode)new StaticTextSqlNode(column.getColumn() + ",")));
        }
        sqlNodes.add(new TrimSqlNode(ms.getConfiguration(), (SqlNode)new MixedSqlNode(ifNodes), "(", null, ")", ","));
        ifNodes = new LinkedList();
        for (EntityHelper.EntityColumn column : columnList) {
            if (column.isId()) continue;
            ifNodes.add(new IfSqlNode((SqlNode)new StaticTextSqlNode("#{" + column.getProperty() + "},"), column.getProperty() + " != null "));
        }
        sqlNodes.add(new TrimSqlNode(ms.getConfiguration(), (SqlNode)new MixedSqlNode(ifNodes), "VALUES (", null, ")", ","));
        return new MixedSqlNode(sqlNodes);
    }
}

