/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaPluginService;
import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaPluginListResult;
import cn.binarywang.wx.miniapp.util.json.WxMaGsonBuilder;
import java.util.HashMap;
import me.chanjar.weixin.common.error.WxErrorException;

public class WxMaPluginServiceImpl
implements WxMaPluginService {
    private WxMaService wxMaService;

    public WxMaPluginServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }

    @Override
    public void applyPlugin(String pluginAppId, String reason) throws WxErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "apply");
        params.put("plugin_appid", pluginAppId);
        params.put("reason", reason);
        this.wxMaService.post("https://api.weixin.qq.com/wxa/plugin", WxMaGsonBuilder.create().toJson(params));
    }

    @Override
    public WxMaPluginListResult getPluginList() throws WxErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "list");
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxa/plugin", WxMaGsonBuilder.create().toJson(params));
        return WxMaPluginListResult.fromJson(responseContent);
    }

    @Override
    public void unbindPlugin(String pluginAppId) throws WxErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "unbind");
        params.put("plugin_appid", pluginAppId);
        this.wxMaService.post("https://api.weixin.qq.com/wxa/plugin", WxMaGsonBuilder.create().toJson(params));
    }

    @Override
    public void updatePlugin(String pluginAppId, String userVersion) throws WxErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "update");
        params.put("plugin_appid", pluginAppId);
        params.put("user_version", userVersion);
        this.wxMaService.post("https://api.weixin.qq.com/wxa/plugin", WxMaGsonBuilder.create().toJson(params));
    }
}

