/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded.core;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import redis.embedded.RedisSentinel;
import redis.embedded.core.ExecutableProvider;

public final class RedisSentinelBuilder {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String CONF_FILENAME = "embedded-redis-sentinel";
    private static final String LINE_MASTER_MONITOR = "sentinel monitor %s 127.0.0.1 %d %d";
    private static final String LINE_DOWN_AFTER = "sentinel down-after-milliseconds %s %d";
    private static final String LINE_FAIL_OVER = "sentinel failover-timeout %s %d";
    private static final String LINE_PARALLEL_SYNCS = "sentinel parallel-syncs %s %d";
    private static final String LINE_PORT = "port %d";
    private File executable;
    private ExecutableProvider executableProvider = ExecutableProvider.newEmbeddedRedis2_8_19Provider();
    private String bind = "127.0.0.1";
    private Integer port = 26379;
    private int masterPort = 6379;
    private String masterName = "mymaster";
    private long downAfterMilliseconds = 60000L;
    private long failOverTimeout = 180000L;
    private int parallelSyncs = 1;
    private int quorumSize = 1;
    private String sentinelConf;
    private StringBuilder redisConfigBuilder;

    public RedisSentinelBuilder executableProvider(ExecutableProvider executableProvider) {
        this.executableProvider = executableProvider;
        return this;
    }

    public RedisSentinelBuilder bind(String bind) {
        this.bind = bind;
        return this;
    }

    public RedisSentinelBuilder port(Integer port) {
        this.port = port;
        return this;
    }

    public RedisSentinelBuilder masterPort(Integer masterPort) {
        this.masterPort = masterPort;
        return this;
    }

    public RedisSentinelBuilder masterName(String masterName) {
        this.masterName = masterName;
        return this;
    }

    public RedisSentinelBuilder quorumSize(int quorumSize) {
        this.quorumSize = quorumSize;
        return this;
    }

    public RedisSentinelBuilder downAfterMilliseconds(long downAfterMilliseconds) {
        this.downAfterMilliseconds = downAfterMilliseconds;
        return this;
    }

    public RedisSentinelBuilder failOverTimeout(long failoverTimeout) {
        this.failOverTimeout = failoverTimeout;
        return this;
    }

    public RedisSentinelBuilder parallelSyncs(int parallelSyncs) {
        this.parallelSyncs = parallelSyncs;
        return this;
    }

    public RedisSentinelBuilder configFile(String redisConf) {
        if (this.redisConfigBuilder != null) {
            throw new IllegalArgumentException("Redis configuration is already partially built using setting(String) method");
        }
        this.sentinelConf = redisConf;
        return this;
    }

    public RedisSentinelBuilder settingIf(boolean shouldSet, String configLine) {
        if (shouldSet) {
            this.setting(configLine);
        }
        return this;
    }

    public RedisSentinelBuilder setting(String configLine) {
        if (this.sentinelConf != null) {
            throw new IllegalArgumentException("Redis configuration is already set using redis conf file");
        }
        if (this.redisConfigBuilder == null) {
            this.redisConfigBuilder = new StringBuilder();
        }
        this.redisConfigBuilder.append(configLine).append(LINE_SEPARATOR);
        return this;
    }

    public RedisSentinel build() {
        this.tryResolveConfAndExec();
        return new RedisSentinel(this.port, this.buildCommandArgs());
    }

    private void tryResolveConfAndExec() {
        try {
            if (this.sentinelConf == null) {
                this.resolveSentinelConf();
            }
            this.executable = this.executableProvider.get();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not build sentinel instance", e);
        }
    }

    public void reset() {
        this.redisConfigBuilder = null;
        this.sentinelConf = null;
    }

    public void addDefaultReplicationGroup() {
        this.setting(String.format(LINE_MASTER_MONITOR, this.masterName, this.masterPort, this.quorumSize));
        this.setting(String.format(LINE_DOWN_AFTER, this.masterName, this.downAfterMilliseconds));
        this.setting(String.format(LINE_FAIL_OVER, this.masterName, this.failOverTimeout));
        this.setting(String.format(LINE_PARALLEL_SYNCS, this.masterName, this.parallelSyncs));
    }

    private void resolveSentinelConf() throws IOException {
        if (this.redisConfigBuilder == null) {
            this.addDefaultReplicationGroup();
        }
        this.setting("bind " + this.bind);
        this.setting(String.format(LINE_PORT, this.port));
        String configString = this.redisConfigBuilder.toString();
        File redisConfigFile = File.createTempFile(this.resolveConfigName(), ".conf");
        redisConfigFile.deleteOnExit();
        Files.write(redisConfigFile.toPath(), configString.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        this.sentinelConf = redisConfigFile.getAbsolutePath();
    }

    private String resolveConfigName() {
        return "embedded-redis-sentinel_" + this.port;
    }

    private List<String> buildCommandArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.executable.getAbsolutePath());
        args.add(this.sentinelConf);
        args.add("--sentinel");
        if (this.port != null) {
            args.add("--port");
            args.add(Integer.toString(this.port));
        }
        return args;
    }
}

