/*
 * Decompiled with CFR 0.152.
 */
package javapns.notification;

import java.util.List;
import java.util.Vector;
import javapns.devices.Device;
import javapns.notification.Payload;
import javapns.notification.ResponsePacket;
import javapns.notification.exceptions.ErrorResponsePacketReceivedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushedNotification {
    private Payload payload;
    private Device device;
    private ResponsePacket response;
    private int identifier;
    private long expiry;
    private int transmissionAttempts;
    private boolean transmissionCompleted;
    private Exception exception;

    protected PushedNotification(Device device, Payload payload) {
        this.device = device;
        this.payload = payload;
    }

    protected PushedNotification(Device device, Payload payload, int identifier) {
        this.device = device;
        this.payload = payload;
        this.identifier = identifier;
    }

    public PushedNotification(Device device, Payload payload, Exception exception) {
        this.device = device;
        this.payload = payload;
        this.exception = exception;
    }

    public Payload getPayload() {
        return this.payload;
    }

    protected void setPayload(Payload payload) {
        this.payload = payload;
    }

    public Device getDevice() {
        return this.device;
    }

    protected void setDevice(Device device) {
        this.device = device;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    protected void setIdentifier(int identifier) {
        this.identifier = identifier;
    }

    public long getExpiry() {
        return this.expiry;
    }

    protected void setExpiry(long expiry) {
        this.expiry = expiry;
    }

    protected void setTransmissionAttempts(int transmissionAttempts) {
        this.transmissionAttempts = transmissionAttempts;
    }

    protected void addTransmissionAttempt() {
        ++this.transmissionAttempts;
    }

    public int getTransmissionAttempts() {
        return this.transmissionAttempts;
    }

    public String getLatestTransmissionAttempt() {
        if (this.transmissionAttempts == 0) {
            return "no attempt yet";
        }
        switch (this.transmissionAttempts) {
            case 0: {
                return "no attempt yet";
            }
            case 1: {
                return "first attempt";
            }
            case 2: {
                return "second attempt";
            }
            case 3: {
                return "third attempt";
            }
            case 4: {
                return "fourth attempt";
            }
        }
        return "attempt #" + this.transmissionAttempts;
    }

    protected void setTransmissionCompleted(boolean completed) {
        this.transmissionCompleted = completed;
    }

    public boolean isTransmissionCompleted() {
        return this.transmissionCompleted;
    }

    protected void setResponse(ResponsePacket response) {
        this.response = response;
        if (response != null && this.exception == null) {
            this.exception = new ErrorResponsePacketReceivedException(response);
        }
    }

    public ResponsePacket getResponse() {
        return this.response;
    }

    public boolean isSuccessful() {
        if (!this.transmissionCompleted) {
            return false;
        }
        if (this.response == null) {
            return true;
        }
        return !this.response.isValidErrorMessage();
    }

    public static List<PushedNotification> findSuccessfulNotifications(List<PushedNotification> notifications) {
        Vector<PushedNotification> filteredList = new Vector<PushedNotification>();
        for (PushedNotification notification : notifications) {
            if (!notification.isSuccessful()) continue;
            filteredList.add(notification);
        }
        return filteredList;
    }

    public static List<PushedNotification> findFailedNotifications(List<PushedNotification> notifications) {
        Vector<PushedNotification> filteredList = new Vector<PushedNotification>();
        for (PushedNotification notification : notifications) {
            if (notification.isSuccessful()) continue;
            filteredList.add(notification);
        }
        return filteredList;
    }

    public String toString() {
        StringBuilder msg = new StringBuilder();
        msg.append("[" + this.identifier + "]");
        msg.append(this.transmissionCompleted ? " transmitted " + this.payload + " on " + this.getLatestTransmissionAttempt() : " not transmitted");
        msg.append(" to token " + this.device.getToken().substring(0, 5) + ".." + this.device.getToken().substring(59, 64));
        if (this.response != null) {
            msg.append("  " + this.response.getMessage());
        }
        if (this.exception != null) {
            msg.append("  " + this.exception);
        }
        return msg.toString();
    }

    void setException(Exception exception) {
        this.exception = exception;
    }

    public Exception getException() {
        return this.exception;
    }
}

