/*
 * Copyright (c)  2019. houbinbin Inc.
 * heaven All rights reserved.
 */

package com.github.houbb.heaven.constant;

/**
 * 路径常量
 *
 * @author houbinbin
 * @version 0.0.1
 */
public final class PathConst {

    private PathConst(){}

    /**
     * 根路径
     */
    public static final String ROOT_PATH = "/";

    /**
     * 文件路径前缀
     */
    public static final String FILE_PATH_PREFIX = "filelist:";

    /**
     * 目标class文件路径后缀
     */
    public static final String TARGET_CLASSES_PATH_SUFFIX = "target/classes/";

    /**
     * java源文件默认存放路径
     */
    public static final String SRC_MAIN_JAVA_PATH = "src/main/java/";

    /**
     * 资源文件存放路径
     */
    public static final String SRC_MAIN_RESOURCES_PATH = "/src/main/resources";


}
