/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.paradise.common.support.validator.core.impl;

import com.github.houbb.paradise.common.support.validator.annotation.Valid;
import com.github.houbb.paradise.common.support.validator.core.ValidService;
import com.github.houbb.paradise.common.support.validator.exception.ValidException;
import com.github.houbb.paradise.common.util.ArgUtil;
import com.github.houbb.paradise.common.util.ArrayUtil;
import com.github.houbb.paradise.common.util.ClassUtil;
import com.github.houbb.paradise.common.util.CollectionUtil;
import com.github.houbb.paradise.common.util.ObjectUtil;
import com.github.houbb.paradise.common.util.StringUtil;
import com.github.houbb.paradise.common.util.reflection.ReflectionUtil;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.List;

public class ValidServiceImpl
implements ValidService {
    private static final ValidServiceImpl INSTANCE = new ValidServiceImpl();

    public static ValidServiceImpl getInstance() {
        return INSTANCE;
    }

    @Override
    public void valid(Object object) throws ValidException, IllegalArgumentException {
        ArgUtil.notNull(object, "object");
        List<Field> fieldList = ReflectionUtil.getAllFieldsList(object.getClass());
        if (CollectionUtil.isEmpty(fieldList)) {
            return;
        }
        for (Field field : fieldList) {
            if (ClassUtil.isNotAnnotationPresent(field, Valid.class)) continue;
            field.setAccessible(true);
            String fieldName = field.getName();
            Valid valid = field.getAnnotation(Valid.class);
            try {
                this.notNullCheck(valid, object, field);
                this.notEmptyCheck(valid, object, field);
                this.isNumberCheck(valid, object, field);
                this.matchesRegexCheck(valid, object, field);
                this.inRangeCheck(valid, object, field);
                this.restrictionCheck(valid, object, field);
                this.atLeastOneCheck(valid, object, field);
            }
            catch (IllegalAccessException e) {
                throw new ValidException(fieldName + "\u975e\u6cd5\u8bbf\u95ee", e);
            }
            catch (NoSuchFieldException e) {
                throw new ValidException(fieldName + "\u6ca1\u6709\u5bf9\u5e94\u5b57\u6bb5", e);
            }
        }
    }

    private String errMsgCheck(Valid valid, Field field) {
        String format = "<%s>: %s";
        String filedName = field.getName();
        String errMsg = valid.errMsg();
        return String.format("<%s>: %s", filedName, errMsg);
    }

    private void notNullCheck(Valid valid, Object object, Field field) throws IllegalAccessException {
        Object fieldValue;
        boolean notNull = valid.notNull();
        if (notNull && ObjectUtil.isNull(fieldValue = field.get(object)).booleanValue()) {
            throw new IllegalArgumentException(this.errMsgCheck(valid, field));
        }
    }

    private void notEmptyCheck(Valid valid, Object object, Field field) throws IllegalAccessException {
        Object fieldValue;
        boolean notEmpty = valid.notEmpty();
        if (notEmpty && ObjectUtil.isEmpty(fieldValue = field.get(object)).booleanValue()) {
            throw new IllegalArgumentException(this.errMsgCheck(valid, field));
        }
    }

    private void isNumberCheck(Valid valid, Object object, Field field) throws ValidException, IllegalAccessException {
        boolean isNumber = valid.isNumber();
        if (isNumber) {
            if (ClassUtil.isNotString(field).booleanValue()) {
                throw new ValidException(this.buildValidExMsg(field, "\u5f53\u524d\u5b57\u6bb5\u4e0d\u662f\u5b57\u7b26\u4e32\u7c7b\u578b"));
            }
            String fieldValue = (String)field.get(object);
            if (ArgUtil.isNotNumber(fieldValue).booleanValue()) {
                throw new IllegalArgumentException(this.errMsgCheck(valid, field));
            }
        }
    }

    private void matchesRegexCheck(Valid valid, Object object, Field field) throws ValidException, IllegalAccessException {
        String regex = valid.matchRegex();
        if (StringUtil.isNotEmpty(regex)) {
            if (ClassUtil.isNotString(field).booleanValue()) {
                throw new ValidException(this.buildValidExMsg(field, "\u5f53\u524d\u5b57\u6bb5\u4e0d\u662f\u5b57\u7b26\u4e32\u7c7b\u578b"));
            }
            String fieldValue = (String)field.get(object);
            if (ArgUtil.isNotMatchesRegex(fieldValue, regex).booleanValue()) {
                throw new IllegalArgumentException(this.errMsgCheck(valid, field));
            }
        }
    }

    private void inRangeCheck(Valid valid, Object object, Field field) throws ValidException, IllegalAccessException {
        String inRange = valid.inRange();
        Object fieldValue = field.get(object);
        if (StringUtil.isNotEmpty(inRange) && null != fieldValue) {
            this.inRangeFieldTypeVerify(field);
            if (ArgUtil.isNotMatchesRegex(inRange, "^[\\[\\(]{1}[-\\.0-9~]{1,},[-\\.0-9~]{1,}[\\]\\)]{1}$").booleanValue()) {
                throw new ValidException(this.buildValidExMsg(field, "\u8303\u56f4\u503c\u6307\u5b9a\u9519\u8bef"));
            }
            String[] strings = inRange.split(",");
            String leftStr = strings[0].substring(0, 1);
            String rightStr = strings[1].substring(strings[1].length() - 1, strings[1].length());
            String oneNumStr = strings[0].substring(1, strings[0].length());
            String twoNumStr = strings[1].substring(0, strings[1].length() - 1);
            double doubleVal = Double.valueOf(fieldValue.toString());
            if (!"~".equals(leftStr)) {
                double oneNum = Double.valueOf(oneNumStr);
                if ("(".equals(leftStr) ? doubleVal <= oneNum : "[".equals(leftStr) && doubleVal < oneNum) {
                    throw new IllegalArgumentException(this.errMsgCheck(valid, field));
                }
            }
            if (!"~".equals(rightStr)) {
                double twoNum = Double.valueOf(twoNumStr);
                if (")".equals(rightStr) ? doubleVal >= twoNum : "]".equals(rightStr) && doubleVal > twoNum) {
                    throw new IllegalArgumentException(this.errMsgCheck(valid, field));
                }
            }
        }
    }

    private void inRangeFieldTypeVerify(Field field) throws ValidException {
        if (field.getType() == Integer.class || field.getType() == Long.class || field.getType() == Short.class || field.getType() == Double.class || field.getType() == Float.class || field.getType() == BigDecimal.class || field.getType() == String.class) {
            return;
        }
        throw new ValidException(this.buildValidExMsg(field, "\u5f53\u524d\u5b57\u6bb5\u4e0d\u662f\u6570\u5b57\u7c7b\u578b"));
    }

    private void restrictionCheck(Valid valid, Object object, Field field) throws IllegalAccessException {
        String fieldValueStr;
        Object[] restrictionArray = valid.restriction();
        if (ArrayUtil.isNotEmpty(restrictionArray) && ArrayUtil.notContains(restrictionArray, fieldValueStr = String.valueOf(field.get(object)))) {
            throw new ValidException(this.errMsgCheck(valid, field));
        }
    }

    private void atLeastOneCheck(Valid valid, Object object, Field field) throws IllegalAccessException, NoSuchFieldException {
        boolean isAtLeastOneNotEmpty;
        Object[] fieldNameArray = valid.restriction();
        if (ArrayUtil.isNotEmpty(fieldNameArray) && !(isAtLeastOneNotEmpty = this.isAtLeastOneNotEmpty((String[])fieldNameArray, object, field))) {
            throw new ValidException(this.errMsgCheck(valid, field));
        }
    }

    private boolean isAtLeastOneNotEmpty(String[] fieldNameArray, Object object, Field currentField) throws IllegalAccessException, NoSuchFieldException {
        String currentFieldValueStr = String.valueOf(currentField.get(object));
        if (StringUtil.isNotEmpty(currentFieldValueStr)) {
            return true;
        }
        Class<?> clazz = object.getClass();
        for (String fieldName : fieldNameArray) {
            Field field = clazz.getField(fieldName);
            String fieldValueStr = String.valueOf(field.get(object));
            if (!StringUtil.isNotEmpty(fieldValueStr)) continue;
            return true;
        }
        return false;
    }

    private String buildValidExMsg(Field field, String errorMsg) {
        String fieldName = field.getName();
        String format = "<%s>: %s";
        return String.format(format, fieldName, errorMsg);
    }
}

