/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.paradise.common.util;

import com.github.houbb.paradise.common.util.ObjectUtil;
import com.github.houbb.paradise.common.util.StringUtil;

public final class ArgUtil {
    private ArgUtil() {
    }

    public static void notNull(Object object, String name) {
        if (null == object) {
            throw new IllegalArgumentException(name + " can not be null!");
        }
    }

    public static void notNull(Object object, String name, String errMsg) {
        if (null == object) {
            String errorInfo = String.format("%s %s", name, errMsg);
            throw new IllegalArgumentException(errorInfo);
        }
    }

    public static void notEmpty(String string, String name) throws IllegalArgumentException {
        if (StringUtil.isEmpty(string)) {
            throw new IllegalArgumentException(name + " can not be null!");
        }
    }

    public static Boolean isNull(Object object) {
        return null == object;
    }

    public static Boolean isNotNull(Object object) {
        return ArgUtil.isNull(object) == false;
    }

    public static void equals(String except, String real, String msg) throws IllegalArgumentException {
        if (!real.equals(except)) {
            String errorMsg = ArgUtil.buildErrorMsg(except, real, msg);
            throw new IllegalArgumentException(errorMsg);
        }
    }

    public static void equals(Object except, Object real, String msg) throws IllegalArgumentException {
        if (ObjectUtil.isNotEquals(except, real).booleanValue()) {
            String errorMsg = ArgUtil.buildErrorMsg(except, real, msg);
            throw new IllegalArgumentException(errorMsg);
        }
    }

    public static boolean isEqualsLen(String string, int len) {
        if (null != string) {
            return string.length() == len;
        }
        return true;
    }

    public static boolean isNotEqualsLen(String string, int len) {
        return !ArgUtil.isEqualsLen(string, len);
    }

    public static boolean isFitMaxLen(String string, int maxLen) {
        if (null != string) {
            return string.length() <= maxLen;
        }
        return true;
    }

    public static boolean isNotFitMaxLen(String string, int maxLen) {
        return !ArgUtil.isFitMaxLen(string, maxLen);
    }

    public static boolean isFitMinLen(String string, int minLen) {
        if (null != string) {
            return string.length() >= minLen;
        }
        return true;
    }

    public static boolean isNotFitMinLen(String string, int minLen) {
        return !ArgUtil.isFitMinLen(string, minLen);
    }

    public static Boolean isNumber(String number) {
        if (null != number) {
            for (int i = 0; i < number.length(); ++i) {
                if (Character.isDigit(number.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static Boolean isNotNumber(String number) {
        return ArgUtil.isNumber(number) == false;
    }

    public static Boolean isMatchesRegex(String string, String regex) {
        if (null != string) {
            return string.matches(regex);
        }
        return true;
    }

    public static Boolean isNotMatchesRegex(String string, String regex) {
        return ArgUtil.isMatchesRegex(string, regex) == false;
    }

    private static String buildErrorMsg(Object except, Object real, String msg) {
        String resultMsg = msg;
        if (StringUtil.isEmpty(resultMsg)) {
            resultMsg = "\u4e0e\u671f\u671b\u503c\u4e0d\u7b26\u5408!";
        }
        String result = String.format("Except:<%s>, Real:<%s>, Msg:<%s>", except, real, resultMsg);
        return result;
    }
}

