/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.paradise.common.util;

import com.github.houbb.paradise.common.util.ArrayUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public final class FileUtil {
    private FileUtil() {
    }

    public static String getFileContent(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            try {
                FileInputStream inputStream = new FileInputStream(file);
                return FileUtil.getFileContent(inputStream);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                System.err.println("\u6587\u4ef6\u4e0d\u5b58\u5728" + filePath);
                return "";
            }
        }
        return "";
    }

    public static String getFileContent(InputStream inputStream) {
        return FileUtil.getFileContent(inputStream, "UTF-8");
    }

    public static String getFileContent(InputStream inputStream, String charset) {
        try {
            int size = inputStream.available();
            byte[] bytes = new byte[size];
            int readSize = inputStream.read(bytes);
            inputStream.close();
            String jsonText = new String(bytes, charset);
            return jsonText;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getSuffix(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    public static List<String> getFileContentEachLine(String filePath, int initLine) {
        File file = new File(filePath);
        return FileUtil.getFileContentEachLine(file, initLine);
    }

    public static List<String> getFileContentEachLine(String filePath) {
        File file = new File(filePath);
        return FileUtil.getFileContentEachLine(file, 0);
    }

    public static List<String> getFileContentEachLineTrim(String filePath, int initLine) {
        List<String> stringList = FileUtil.getFileContentEachLine(filePath, initLine);
        LinkedList<String> resultList = new LinkedList<String>();
        for (String string : stringList) {
            resultList.add(string.trim());
        }
        return resultList;
    }

    public static List<String> getFileContentEachLine(File file) {
        return FileUtil.getFileContentEachLine(file, 0);
    }

    public static List<String> getFileContentEachLine(File file, int initLine) {
        LinkedList<String> contentList = new LinkedList<String>();
        if (!file.exists()) {
            System.err.println("\u6587\u4ef6\u4e0d\u5b58\u5728");
            return contentList;
        }
        String charset = "UTF-8";
        try (FileInputStream fileInputStream = new FileInputStream(file);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, charset);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String dataEachLine;
            int lineNo;
            for (lineNo = 0; lineNo < initLine; ++lineNo) {
                bufferedReader.readLine();
            }
            while ((dataEachLine = bufferedReader.readLine()) != null) {
                ++lineNo;
                if (Objects.equals("", dataEachLine)) continue;
                contentList.add(dataEachLine);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return new LinkedList<String>();
        }
        return contentList;
    }

    public static List<String> getFileContentEachLine(File file, int initLine, int endLine, String charset) {
        LinkedList<String> contentList = new LinkedList<String>();
        if (!file.exists()) {
            System.err.println("\u6587\u4ef6\u4e0d\u5b58\u5728");
            return contentList;
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, charset);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String dataEachLine;
            int lineNo;
            for (lineNo = 0; lineNo < initLine; ++lineNo) {
                bufferedReader.readLine();
            }
            while ((dataEachLine = bufferedReader.readLine()) != null && lineNo < endLine) {
                ++lineNo;
                contentList.add(dataEachLine);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return new LinkedList<String>();
        }
        return contentList;
    }

    public static void copyDir(String sourceDir, String targetDir) throws IOException {
        File file = new File(sourceDir);
        Object[] filePath = file.list();
        if (!new File(targetDir).exists()) {
            new File(targetDir).mkdir();
        }
        if (ArrayUtil.isNotEmpty(filePath)) {
            for (int i = 0; i < filePath.length; ++i) {
                if (new File(sourceDir + File.separator + (String)filePath[i]).isDirectory()) {
                    FileUtil.copyDir(sourceDir + File.separator + (String)filePath[i], targetDir + File.separator + (String)filePath[i]);
                }
                if (!new File(sourceDir + File.separator + (String)filePath[i]).isFile()) continue;
                FileUtil.copyFile(sourceDir + File.separator + (String)filePath[i], targetDir + File.separator + (String)filePath[i]);
            }
        }
    }

    public static void copyFile(String sourceFile, String targetPath) throws IOException {
        File oldFile = new File(sourceFile);
        File file = new File(targetPath);
        try (FileInputStream in = new FileInputStream(oldFile);
             FileOutputStream out = new FileOutputStream(file);){
            byte[] buffer = new byte[0x200000];
            while (in.read(buffer) != -1) {
                out.write(buffer);
            }
        }
    }
}

