/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import shadow.org.apache.tools.ant.BuildException;
import shadow.org.apache.tools.ant.taskdefs.LogOutputStream;
import shadow.org.apache.tools.ant.types.EnumeratedAttribute;
import shadow.org.apache.tools.ant.util.DOMElementWriter;
import shadow.org.apache.tools.ant.util.FileUtils;
import shadow.org.apache.tools.ant.util.XMLFragment;

public class EchoXML
extends XMLFragment {
    private File file;
    private boolean append;
    private NamespacePolicy namespacePolicy = NamespacePolicy.DEFAULT;
    private static final String ERROR_NO_XML = "No nested XML specified";

    public void setFile(File f) {
        this.file = f;
    }

    public void setNamespacePolicy(NamespacePolicy n) {
        this.namespacePolicy = n;
    }

    public void setAppend(boolean b) {
        this.append = b;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        DOMElementWriter writer = new DOMElementWriter(!this.append, this.namespacePolicy.getPolicy());
        OutputStream os = null;
        try {
            os = this.file != null ? new FileOutputStream(this.file.getAbsolutePath(), this.append) : new LogOutputStream(this, 2);
            Node n = this.getFragment().getFirstChild();
            if (n == null) {
                throw new BuildException(ERROR_NO_XML);
            }
            writer.write((Element)n, os);
        }
        catch (BuildException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new BuildException(e2);
                }
            }
            catch (Throwable throwable) {
                FileUtils.close(os);
                throw throwable;
            }
        }
        FileUtils.close(os);
    }

    public static class NamespacePolicy
    extends EnumeratedAttribute {
        private static final String IGNORE = "ignore";
        private static final String ELEMENTS = "elementsOnly";
        private static final String ALL = "all";
        public static final NamespacePolicy DEFAULT = new NamespacePolicy("ignore");

        public NamespacePolicy() {
        }

        public NamespacePolicy(String s) {
            this.setValue(s);
        }

        public String[] getValues() {
            return new String[]{IGNORE, ELEMENTS, ALL};
        }

        public DOMElementWriter.XmlNamespacePolicy getPolicy() {
            String s = this.getValue();
            if (IGNORE.equalsIgnoreCase(s)) {
                return DOMElementWriter.XmlNamespacePolicy.IGNORE;
            }
            if (ELEMENTS.equalsIgnoreCase(s)) {
                return DOMElementWriter.XmlNamespacePolicy.ONLY_QUALIFY_ELEMENTS;
            }
            if (ALL.equalsIgnoreCase(s)) {
                return DOMElementWriter.XmlNamespacePolicy.QUALIFY_ALL;
            }
            throw new BuildException("Invalid namespace policy: " + s);
        }
    }
}

