/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.apache.tools.ant.types.optional.depend;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import shadow.org.apache.tools.ant.BuildException;
import shadow.org.apache.tools.ant.DirectoryScanner;
import shadow.org.apache.tools.ant.types.Path;
import shadow.org.apache.tools.ant.util.depend.DependencyAnalyzer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependScanner
extends DirectoryScanner {
    public static final String DEFAULT_ANALYZER_CLASS = "shadow.org.apache.tools.ant.util.depend.bcel.FullAnalyzer";
    private Vector<String> rootClasses;
    private Vector<String> included;
    private Vector<File> additionalBaseDirs = new Vector();
    private DirectoryScanner parentScanner;

    public DependScanner(DirectoryScanner parentScanner) {
        this.parentScanner = parentScanner;
    }

    public synchronized void setRootClasses(Vector<String> rootClasses) {
        this.rootClasses = rootClasses;
    }

    @Override
    public String[] getIncludedFiles() {
        String[] files = new String[this.getIncludedFilesCount()];
        for (int i = 0; i < files.length; ++i) {
            files[i] = this.included.elementAt(i);
        }
        return files;
    }

    @Override
    public synchronized int getIncludedFilesCount() {
        if (this.included == null) {
            throw new IllegalStateException();
        }
        return this.included.size();
    }

    @Override
    public synchronized void scan() throws IllegalStateException {
        this.included = new Vector();
        String analyzerClassName = DEFAULT_ANALYZER_CLASS;
        DependencyAnalyzer analyzer = null;
        try {
            Class<DependencyAnalyzer> analyzerClass = Class.forName(analyzerClassName).asSubclass(DependencyAnalyzer.class);
            analyzer = analyzerClass.newInstance();
        }
        catch (Exception e) {
            throw new BuildException("Unable to load dependency analyzer: " + analyzerClassName, e);
        }
        analyzer.addClassPath(new Path(null, this.basedir.getPath()));
        Enumeration<Object> e = this.additionalBaseDirs.elements();
        while (e.hasMoreElements()) {
            File additionalBaseDir = e.nextElement();
            analyzer.addClassPath(new Path(null, additionalBaseDir.getPath()));
        }
        e = this.rootClasses.elements();
        while (e.hasMoreElements()) {
            String rootClass = (String)e.nextElement();
            analyzer.addRootClass(rootClass);
        }
        e = analyzer.getClassDependencies();
        String[] parentFiles = this.parentScanner.getIncludedFiles();
        Hashtable<String, String> parentSet = new Hashtable<String, String>();
        for (int i = 0; i < parentFiles.length; ++i) {
            parentSet.put(parentFiles[i], parentFiles[i]);
        }
        while (e.hasMoreElements()) {
            String classname = (String)e.nextElement();
            String filename = classname.replace('.', File.separatorChar);
            File depFile = new File(this.basedir, filename = filename + ".class");
            if (!depFile.exists() || !parentSet.containsKey(filename)) continue;
            this.included.addElement(filename);
        }
    }

    @Override
    public void addDefaultExcludes() {
    }

    @Override
    public String[] getExcludedDirectories() {
        return null;
    }

    @Override
    public String[] getExcludedFiles() {
        return null;
    }

    @Override
    public String[] getIncludedDirectories() {
        return new String[0];
    }

    @Override
    public int getIncludedDirsCount() {
        return 0;
    }

    @Override
    public String[] getNotIncludedDirectories() {
        return null;
    }

    @Override
    public String[] getNotIncludedFiles() {
        return null;
    }

    @Override
    public void setExcludes(String[] excludes) {
    }

    @Override
    public void setIncludes(String[] includes) {
    }

    @Override
    public void setCaseSensitive(boolean isCaseSensitive) {
    }

    public void addBasedir(File baseDir) {
        this.additionalBaseDirs.addElement(baseDir);
    }
}

