/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.http.client.protocol;

import java.io.IOException;
import wiremock.org.apache.http.HttpException;
import wiremock.org.apache.http.HttpRequest;
import wiremock.org.apache.http.annotation.Immutable;
import wiremock.org.apache.http.auth.AuthState;
import wiremock.org.apache.http.client.protocol.RequestAuthenticationBase;
import wiremock.org.apache.http.protocol.HttpContext;

@Immutable
public class RequestTargetAuthentication
extends RequestAuthenticationBase {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (request.containsHeader("Authorization")) {
            return;
        }
        AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
        if (authState == null) {
            this.log.debug("Target auth state not set in the context");
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Target auth state: " + (Object)((Object)authState.getState()));
        }
        this.process(authState, request, context);
    }
}

