/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.aop;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyFilter;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyResolver;
import com.ulisesbocchio.jasyptspringboot.caching.CachingDelegateEncryptablePropertySource;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.env.PropertySource;

public class EncryptablePropertySourceMethodInterceptor<T>
extends CachingDelegateEncryptablePropertySource<T>
implements MethodInterceptor {
    public EncryptablePropertySourceMethodInterceptor(PropertySource<T> delegate, EncryptablePropertyResolver resolver, EncryptablePropertyFilter filter) {
        super(delegate, resolver, filter);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.isRefreshCall(invocation)) {
            this.refresh();
            return null;
        }
        if (this.isGetDelegateCall(invocation)) {
            return this.getDelegate();
        }
        if (this.isGetPropertyCall(invocation)) {
            return this.getProperty(this.getNameArgument(invocation));
        }
        return invocation.proceed();
    }

    private String getNameArgument(MethodInvocation invocation) {
        return (String)invocation.getArguments()[0];
    }

    private boolean isGetDelegateCall(MethodInvocation invocation) {
        return invocation.getMethod().getName().equals("getDelegate");
    }

    private boolean isRefreshCall(MethodInvocation invocation) {
        return invocation.getMethod().getName().equals("refresh");
    }

    private boolean isGetPropertyCall(MethodInvocation invocation) {
        return invocation.getMethod().getName().equals("getProperty") && invocation.getMethod().getParameters().length == 1 && invocation.getMethod().getParameters()[0].getType() == String.class;
    }
}

