/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.util;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public final class Singleton<R>
implements Supplier<R> {
    private boolean initialized = false;
    private volatile Supplier<R> instanceSupplier = () -> {
        Supplier supplier = original;
        synchronized (supplier) {
            if (!this.initialized) {
                Object singletonInstance = original.get();
                this.instanceSupplier = () -> singletonInstance;
                this.initialized = true;
            }
            return this.instanceSupplier.get();
        }
    };

    public static <R> Singleton<R> from(Supplier<R> original) {
        return new Singleton<R>(original);
    }

    public static <T, R> Singleton<R> from(Function<T, R> original, T arg0) {
        return Singleton.fromLazy(original, () -> arg0);
    }

    public static <T, U, R> Singleton<R> from(BiFunction<T, U, R> original, T arg0, U arg1) {
        return Singleton.fromLazy(original, () -> arg0, () -> arg1);
    }

    public static <T, R> Singleton<R> fromLazy(Function<T, R> original, Supplier<T> arg0Supplier) {
        return Singleton.from(() -> original.apply(arg0Supplier.get()));
    }

    public static <T, U, R> Singleton<R> fromLazy(BiFunction<T, U, R> original, Supplier<T> arg0Supplier, Supplier<U> arg1Supplier) {
        return Singleton.from(() -> original.apply(arg0Supplier.get(), arg1Supplier.get()));
    }

    public Singleton(Supplier<R> original) {
    }

    @Override
    public R get() {
        return this.instanceSupplier.get();
    }
}

