/*
 * Decompiled with CFR 0.152.
 */
package com.github.wujun234.uid;

import com.github.wujun234.uid.impl.CachedUidGenerator;
import com.github.wujun234.uid.impl.DefaultUidGenerator;
import com.github.wujun234.uid.impl.UidProperties;
import com.github.wujun234.uid.worker.DisposableWorkerIdAssigner;
import com.github.wujun234.uid.worker.WorkerIdAssigner;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@ConditionalOnClass(value={DefaultUidGenerator.class, CachedUidGenerator.class})
@MapperScan(value={"com.github.wujun234.uid.worker.dao"})
@EnableConfigurationProperties(value={UidProperties.class})
public class UidAutoConfigure {
    @Autowired
    private UidProperties uidProperties;

    @Bean
    @ConditionalOnMissingBean
    @Lazy
    DefaultUidGenerator defaultUidGenerator() {
        return new DefaultUidGenerator(this.uidProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy
    CachedUidGenerator cachedUidGenerator() {
        return new CachedUidGenerator(this.uidProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    WorkerIdAssigner workerIdAssigner() {
        return new DisposableWorkerIdAssigner();
    }
}

