/*
 * Decompiled with CFR 0.152.
 */
package com.github.wujun234.uid.impl;

import com.github.wujun234.uid.BitsAllocator;
import com.github.wujun234.uid.UidGenerator;
import com.github.wujun234.uid.exception.UidGenerateException;
import com.github.wujun234.uid.impl.UidProperties;
import com.github.wujun234.uid.utils.DateUtils;
import com.github.wujun234.uid.worker.WorkerIdAssigner;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultUidGenerator
implements UidGenerator,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultUidGenerator.class);
    protected UidProperties uidProperties;
    protected BitsAllocator bitsAllocator;
    protected long workerId;
    protected long sequence = 0L;
    protected long lastSecond = -1L;
    @Autowired
    protected WorkerIdAssigner workerIdAssigner;

    public DefaultUidGenerator(UidProperties uidProperties) {
        this.uidProperties = uidProperties;
    }

    public void afterPropertiesSet() throws Exception {
        this.bitsAllocator = new BitsAllocator(this.uidProperties.getTimeBits(), this.uidProperties.getWorkerBits(), this.uidProperties.getSeqBits());
        this.workerId = this.workerIdAssigner.assignWorkerId();
        if (this.workerId > this.bitsAllocator.getMaxWorkerId()) {
            LOGGER.error("Worker id " + this.workerId + " exceeds the max " + this.bitsAllocator.getMaxWorkerId());
            this.workerId %= this.bitsAllocator.getMaxWorkerId();
            LOGGER.info("new Worker id = " + this.workerId);
        }
        LOGGER.info("Initialized bits(1, {}, {}, {}) for workerID:{}", new Object[]{this.uidProperties.getTimeBits(), this.uidProperties.getWorkerBits(), this.uidProperties.getSeqBits(), this.workerId});
    }

    @Override
    public long getUID() throws UidGenerateException {
        try {
            return this.nextId();
        }
        catch (Exception e) {
            LOGGER.error("Generate unique id exception. ", (Throwable)e);
            throw new UidGenerateException(e);
        }
    }

    @Override
    public String parseUID(long uid) {
        long totalBits = 64L;
        long workerIdBits = this.bitsAllocator.getWorkerIdBits();
        long sequenceBits = this.bitsAllocator.getSequenceBits();
        long sequence = uid << (int)(totalBits - sequenceBits) >>> (int)(totalBits - sequenceBits);
        long workerId = uid << (int)(totalBits - workerIdBits - sequenceBits) >>> (int)(totalBits - workerIdBits);
        long deltaSeconds = uid >>> (int)(workerIdBits + sequenceBits);
        Date thatTime = new Date(TimeUnit.SECONDS.toMillis(this.uidProperties.getEpochSeconds() + deltaSeconds));
        String thatTimeStr = DateUtils.formatByDateTimePattern(thatTime);
        return String.format("{\"UID\":\"%d\",\"timestamp\":\"%s\",\"workerId\":\"%d\",\"sequence\":\"%d\"}", uid, thatTimeStr, workerId, sequence);
    }

    protected synchronized long nextId() {
        long currentSecond = this.getCurrentSecond();
        if (currentSecond < this.lastSecond) {
            long refusedSeconds = this.lastSecond - currentSecond;
            if (this.uidProperties.isEnableBackward()) {
                if (refusedSeconds <= this.uidProperties.getMaxBackwardSeconds()) {
                    LOGGER.error("Clock moved backwards. wait for %d seconds", (Object)refusedSeconds);
                    while (currentSecond < this.lastSecond) {
                        currentSecond = this.getCurrentSecond();
                    }
                } else {
                    this.workerId = this.workerIdAssigner.assignFakeWorkerId();
                    LOGGER.error("Clock moved backwards. Assigned New WorkerId %d", (Object)this.workerId);
                    if (this.workerId > this.bitsAllocator.getMaxWorkerId()) {
                        LOGGER.error("Worker id " + this.workerId + " exceeds the max " + this.bitsAllocator.getMaxWorkerId());
                        this.workerId %= this.bitsAllocator.getMaxWorkerId();
                        LOGGER.info("new Worker id = " + this.workerId);
                    }
                }
            } else {
                throw new UidGenerateException("Clock moved backwards. Refusing for %d seconds", refusedSeconds);
            }
        }
        if (currentSecond == this.lastSecond) {
            this.sequence = this.sequence + 1L & this.bitsAllocator.getMaxSequence();
            if (this.sequence == 0L) {
                currentSecond = this.getNextSecond(this.lastSecond);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastSecond = currentSecond;
        return this.bitsAllocator.allocate(currentSecond - this.uidProperties.getEpochSeconds(), this.workerId, this.sequence);
    }

    private long getNextSecond(long lastTimestamp) {
        long timestamp = this.getCurrentSecond();
        while (timestamp <= lastTimestamp) {
            timestamp = this.getCurrentSecond();
        }
        return timestamp;
    }

    private long getCurrentSecond() {
        long currentSecond = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        if (currentSecond - this.uidProperties.getEpochSeconds() > this.bitsAllocator.getMaxDeltaSeconds()) {
            throw new UidGenerateException("Timestamp bits is exhausted. Refusing UID generate. Now: " + currentSecond);
        }
        return currentSecond;
    }

    public void setWorkerIdAssigner(WorkerIdAssigner workerIdAssigner) {
        this.workerIdAssigner = workerIdAssigner;
    }
}

