/*
 * Decompiled with CFR 0.152.
 */
package com.github.wujun234.uid.impl;

import com.github.wujun234.uid.utils.DateUtils;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="uid")
public class UidProperties {
    private int timeBits = 30;
    private int workerBits = 16;
    private int seqBits = 7;
    private String epochStr = "2019-02-20";
    private long epochSeconds = TimeUnit.MILLISECONDS.toSeconds(1550592000000L);
    private boolean enableBackward = true;
    private long maxBackwardSeconds = 1L;

    public int getTimeBits() {
        return this.timeBits;
    }

    public void setTimeBits(int timeBits) {
        if (timeBits > 0) {
            this.timeBits = timeBits;
        }
    }

    public int getWorkerBits() {
        return this.workerBits;
    }

    public void setWorkerBits(int workerBits) {
        if (workerBits > 0) {
            this.workerBits = workerBits;
        }
    }

    public int getSeqBits() {
        return this.seqBits;
    }

    public void setSeqBits(int seqBits) {
        if (seqBits > 0) {
            this.seqBits = seqBits;
        }
    }

    public String getEpochStr() {
        return this.epochStr;
    }

    public void setEpochStr(String epochStr) {
        if (StringUtils.isNotBlank((String)epochStr)) {
            this.epochStr = epochStr;
            this.epochSeconds = TimeUnit.MILLISECONDS.toSeconds(DateUtils.parseByDayPattern(epochStr).getTime());
        }
    }

    public long getEpochSeconds() {
        return this.epochSeconds;
    }

    public boolean isEnableBackward() {
        return this.enableBackward;
    }

    public void setEnableBackward(boolean enableBackward) {
        this.enableBackward = enableBackward;
    }

    public long getMaxBackwardSeconds() {
        return this.maxBackwardSeconds;
    }

    public void setMaxBackwardSeconds(long maxBackwardSeconds) {
        this.maxBackwardSeconds = maxBackwardSeconds;
    }
}

