/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.swaggerbootstrapui.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VFS {
    private static Logger logger = LoggerFactory.getLogger(VFS.class);
    private static final byte[] JAR_MAGIC = new byte[]{80, 75, 3, 4};

    private VFS() {
    }

    public static VFS getInstance() {
        return VFSHolder.instance;
    }

    public static List<URL> getResources(String path) throws IOException {
        return Collections.list(Thread.currentThread().getContextClassLoader().getResources(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> list(URL url, String path) throws IOException {
        ArrayList<String> resources = new ArrayList();
        InputStream ins = null;
        try {
            URL jarUrl = this.findJarForResource(url);
            if (jarUrl != null) {
                ins = jarUrl.openStream();
                resources = this.listResources(new JarInputStream(ins), path);
            } else {
                List<Object> children;
                block37: {
                    children = new ArrayList<String>();
                    try {
                        String string;
                        if (this.isJar(url)) {
                            ins = url.openStream();
                            JarInputStream jarInputStream = new JarInputStream(ins);
                            Object object = null;
                            try {
                                JarEntry jarEntry;
                                while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                                    if (logger.isDebugEnabled()) {
                                        logger.debug("Jar entry: " + jarEntry.getName());
                                    }
                                    children.add(jarEntry.getName());
                                }
                                break block37;
                            }
                            catch (Throwable throwable) {
                                object = throwable;
                                throw throwable;
                            }
                            finally {
                                if (jarInputStream != null) {
                                    if (object != null) {
                                        try {
                                            jarInputStream.close();
                                        }
                                        catch (Throwable throwable) {
                                            ((Throwable)object).addSuppressed(throwable);
                                        }
                                    } else {
                                        jarInputStream.close();
                                    }
                                }
                            }
                        }
                        ins = url.openStream();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(ins));
                        ArrayList<String> lines = new ArrayList<String>();
                        while ((string = reader.readLine()) != null) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Reader entry: " + string);
                            }
                            lines.add(string);
                            if (!VFS.getResources(path + "/" + string).isEmpty()) continue;
                            lines.clear();
                            break;
                        }
                        if (!lines.isEmpty()) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Listing " + url);
                            }
                            children.addAll(lines);
                        }
                    }
                    catch (FileNotFoundException ex) {
                        if ("file".equals(url.getProtocol())) {
                            File file = new File(url.getFile());
                            if (logger.isDebugEnabled()) {
                                logger.debug("Listing directory " + file.getAbsolutePath());
                            }
                            if (file.isDirectory()) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("Listing " + url);
                                }
                                children = Arrays.asList(file.list());
                            }
                        }
                        throw ex;
                    }
                }
                String prefix = url.toExternalForm();
                if (!prefix.endsWith("/")) {
                    prefix = prefix + "/";
                }
                for (String string : children) {
                    String resourcePath = path + "/" + string;
                    resources.add(resourcePath);
                    URL childUrl = new URL(prefix + string);
                    resources.addAll(this.list(childUrl, resourcePath));
                }
            }
            ArrayList<String> arrayList = resources;
            return arrayList;
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected List<String> listResources(JarInputStream jarInputStream, String path) throws IOException {
        JarEntry entry;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        ArrayList<String> resources = new ArrayList<String>();
        while ((entry = jarInputStream.getNextJarEntry()) != null) {
            if (entry.isDirectory()) continue;
            StringBuilder name = new StringBuilder(entry.getName());
            if (name.charAt(0) != '/') {
                name.insert(0, '/');
            }
            if (name.indexOf(path) != 0) continue;
            resources.add(name.substring(1));
        }
        return resources;
    }

    public URL findJarForResource(URL url) {
        if (logger.isDebugEnabled()) {
            logger.debug("Find JAR URL:{}", (Object)url);
        }
        try {
            while (true) {
                url = new URL(url.getFile());
            }
        }
        catch (MalformedURLException malformedURLException) {
            StringBuffer jar = new StringBuffer(url.toExternalForm());
            int index = jar.lastIndexOf(".jar");
            if (index >= 0) {
                jar.setLength(index + 4);
                if (logger.isDebugEnabled()) {
                    logger.debug("Extracted JAR URL: " + jar);
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Not a Jar:" + jar);
                }
                return null;
            }
            try {
                URL targetUrl = new URL(jar.toString());
                if (this.isJar(targetUrl)) {
                    return targetUrl;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Not a Jar:" + jar);
                }
                jar.replace(0, jar.length(), targetUrl.getFile());
                File file = new File(jar.toString());
                if (!file.exists()) {
                    try {
                        file = new File(URLEncoder.encode(jar.toString(), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException("Unsupported encoding?  UTF-8?  That's unpossible.");
                    }
                }
                if (file.exists()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("real File:" + file.getAbsolutePath());
                    }
                    if (this.isJar(targetUrl = file.toURI().toURL())) {
                        return targetUrl;
                    }
                }
            }
            catch (MalformedURLException e) {
                logger.warn("Invalid JAR URL: " + jar);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Not a JAR: " + jar);
            }
            return null;
        }
    }

    public boolean isJar(URL url) {
        return this.isJar(url, new byte[JAR_MAGIC.length]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isJar(URL url, byte[] buffer) {
        InputStream ins = null;
        try {
            ins = url.openStream();
            ins.read(buffer, 0, JAR_MAGIC.length);
            if (Arrays.equals(buffer, JAR_MAGIC)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Found Jar:" + url);
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public List<String> list(String path) throws IOException {
        ArrayList<String> names = new ArrayList<String>();
        for (URL url : VFS.getResources(path)) {
            names.addAll(this.list(url, path));
        }
        return names;
    }

    private static class VFSHolder {
        static final VFS instance = new VFS();

        private VFSHolder() {
        }
    }
}

