/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.injector;

import com.baomidou.mybatisplus.core.injector.AbstractMethod;
import com.baomidou.mybatisplus.core.injector.DefaultSqlInjector;
import com.baomidou.mybatisplus.core.mapper.Mapper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.github.yulichang.method.SelectJoinCount;
import com.github.yulichang.method.SelectJoinList;
import com.github.yulichang.method.SelectJoinMap;
import com.github.yulichang.method.SelectJoinMaps;
import com.github.yulichang.method.SelectJoinMapsPage;
import com.github.yulichang.method.SelectJoinOne;
import com.github.yulichang.method.SelectJoinPage;
import com.github.yulichang.toolkit.ReflectionKit;
import java.util.List;
import java.util.Set;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.Configuration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;

@ConditionalOnMissingBean(value={DefaultSqlInjector.class})
public class MPJSqlInjector
extends DefaultSqlInjector {
    private static final Log logger = LogFactory.getLog(MPJSqlInjector.class);

    public List<AbstractMethod> getMethodList(Class<?> mapperClass) {
        List list = super.getMethodList(mapperClass);
        list.add(new SelectJoinCount());
        list.add(new SelectJoinOne());
        list.add(new SelectJoinList());
        list.add(new SelectJoinPage());
        list.add(new SelectJoinMap());
        list.add(new SelectJoinMaps());
        list.add(new SelectJoinMapsPage());
        return list;
    }

    public void inspectInject(MapperBuilderAssistant builderAssistant, Class<?> mapperClass) {
        Class<?> modelClass = ReflectionKit.getSuperClassGenericType(mapperClass, Mapper.class, 0);
        if (modelClass != null) {
            String className = mapperClass.toString();
            Set mapperRegistryCache = GlobalConfigUtils.getMapperRegistryCache((Configuration)builderAssistant.getConfiguration());
            if (!mapperRegistryCache.contains(className)) {
                List<AbstractMethod> methodList = this.getMethodList(mapperClass);
                if (CollectionUtils.isNotEmpty(methodList)) {
                    TableInfo tableInfo = TableInfoHelper.initTableInfo((MapperBuilderAssistant)builderAssistant, modelClass);
                    methodList.forEach(m -> m.inject(builderAssistant, mapperClass, modelClass, tableInfo));
                } else {
                    logger.debug(mapperClass + ", No effective injection method was found.");
                }
                mapperRegistryCache.add(className);
            }
        }
    }
}

