/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.predicate.primitive.CharBytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.block.procedure.primitive.CharByteProcedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.map.primitive.CharByteMap;
import com.gs.collections.api.map.primitive.ImmutableCharByteMap;
import com.gs.collections.api.map.primitive.MutableCharByteMap;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.tuple.primitive.CharBytePair;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedCharByteProcedure;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import com.gs.collections.impl.map.mutable.primitive.CharByteHashMap;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableCharSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableCharByteHashMap
implements ImmutableCharByteMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableCharByteMap delegate;

    ImmutableCharByteHashMap(CharByteMap delegate) {
        this.delegate = new CharByteHashMap(delegate);
    }

    public byte get(char key) {
        return this.delegate.get(key);
    }

    public byte getIfAbsent(char key, byte ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public byte getOrThrow(char key) {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(char key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(byte value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(ByteProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(CharProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(CharByteProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyCharIterable keysView() {
        return this.delegate.keysView();
    }

    public RichIterable<CharBytePair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    public ImmutableCharByteMap select(CharBytePredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableCharByteMap reject(CharBytePredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return ((CharByteHashMap)this.delegate).injectInto(injectedValue, function);
    }

    public ImmutableCharByteMap toImmutable() {
        return this;
    }

    public ByteIterator byteIterator() {
        return this.delegate.byteIterator();
    }

    public void forEach(ByteProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(BytePredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(BytePredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(BytePredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableByteCollection select(BytePredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableByteCollection reject(BytePredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(ByteToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    public long sum() {
        return this.delegate.sum();
    }

    public byte max() {
        return this.delegate.max();
    }

    public byte maxIfEmpty(byte defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public byte min() {
        return this.delegate.min();
    }

    public byte minIfEmpty(byte defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public byte[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableByteList toSortedList() {
        return this.delegate.toSortedList();
    }

    public byte[] toArray() {
        return this.delegate.toArray();
    }

    public boolean contains(byte value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(byte ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(ByteIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableByteList toList() {
        return this.delegate.toList();
    }

    public MutableByteSet toSet() {
        return this.delegate.toSet();
    }

    public MutableByteBag toBag() {
        return this.delegate.toBag();
    }

    public LazyByteIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableCharByteMap newWithKeyValue(char key, byte value) {
        CharByteHashMap map = new CharByteHashMap(this.size() + 1);
        map.putAll((CharByteMap)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableCharByteMap newWithoutKey(char key) {
        CharByteHashMap map = new CharByteHashMap(this.size());
        map.putAll((CharByteMap)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableCharByteMap newWithoutAllKeys(CharIterable keys) {
        CharByteHashMap map = new CharByteHashMap(this.size());
        map.putAll((CharByteMap)this);
        CharIterator iterator = keys.charIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableCharSet keySet() {
        return UnmodifiableCharSet.of(this.delegate.keySet());
    }

    public MutableByteCollection values() {
        return UnmodifiableByteCollection.of(this.delegate.values());
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableCharByteMapSerializationProxy((CharByteMap)this);
    }

    protected static class ImmutableCharByteMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private CharByteMap map;

        public ImmutableCharByteMapSerializationProxy() {
        }

        protected ImmutableCharByteMapSerializationProxy(CharByteMap map) {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((CharByteProcedure)new CheckedCharByteProcedure(){

                    public void safeValue(char key, byte value) throws IOException {
                        out.writeChar(key);
                        out.writeByte(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            CharByteHashMap deserializedMap = new CharByteHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readChar(), in.readByte());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

