/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction0;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortToShortFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.predicate.primitive.ShortShortPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortShortProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableShortCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.map.primitive.ImmutableShortShortMap;
import com.gs.collections.api.map.primitive.MutableShortShortMap;
import com.gs.collections.api.map.primitive.ShortShortMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ImmutableShortSet;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.set.primitive.ShortSet;
import com.gs.collections.api.tuple.primitive.ShortShortPair;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedShortCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableShortCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.ShortLists;
import com.gs.collections.impl.factory.primitive.ShortSets;
import com.gs.collections.impl.factory.primitive.ShortShortMaps;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.primitive.AbstractLazyShortIterable;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedShortShortMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableShortShortMap;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedShortSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableShortSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortShortHashMap
implements MutableShortShortMap,
Externalizable {
    static final short EMPTY_VALUE = 0;
    private static final long serialVersionUID = 1L;
    private static final short EMPTY_KEY = 0;
    private static final short REMOVED_KEY = 1;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private short[] keys;
    private short[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues sentinelValues;

    public ShortShortHashMap() {
        this.allocateTable(16);
    }

    public ShortShortHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public ShortShortHashMap(ShortShortMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static ShortShortHashMap newWithKeysValues(short key1, short value1) {
        return new ShortShortHashMap(1).withKeyValue(key1, value1);
    }

    public static ShortShortHashMap newWithKeysValues(short key1, short value1, short key2, short value2) {
        return new ShortShortHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static ShortShortHashMap newWithKeysValues(short key1, short value1, short key2, short value2, short key3, short value3) {
        return new ShortShortHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static ShortShortHashMap newWithKeysValues(short key1, short value1, short key2, short value2, short key3, short value3, short key4, short value4) {
        return new ShortShortHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShortShortMap)) {
            return false;
        }
        ShortShortMap other = (ShortShortMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey((short)0) || other.containsKey((short)1)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey((short)0) || this.sentinelValues.zeroValue != other.getOrThrow((short)0))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey((short)1) || this.sentinelValues.oneValue != other.getOrThrow((short)1))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            short key = this.keys[i];
            if (!ShortShortHashMap.isNonSentinel(key) || other.containsKey(key) && this.values[i] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortShortHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ this.values[i];
        }
        return result;
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(String.valueOf(0)).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(String.valueOf(1)).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            short key = this.keys[i];
            if (!ShortShortHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values[i]));
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                short key = this.keys[i];
                if (!ShortShortHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ShortIterator shortIterator() {
        return new InternalShortIterator();
    }

    public short[] toArray() {
        short[] array = new short[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortShortHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values[i];
            ++index;
        }
        return array;
    }

    public boolean contains(short value) {
        return this.containsValue(value);
    }

    public boolean containsAll(short ... source) {
        for (short each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ShortIterable source) {
        return source.allSatisfy(new ShortPredicate(){

            public boolean accept(short value) {
                return ShortShortHashMap.this.contains(value);
            }
        });
    }

    public void forEach(ShortProcedure procedure) {
        this.forEachValue(procedure);
    }

    public MutableShortCollection select(ShortPredicate predicate) {
        ShortArrayList result = new ShortArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortShortHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableShortCollection reject(ShortPredicate predicate) {
        ShortArrayList result = new ShortArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortShortHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <V> MutableCollection<V> collect(ShortToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortShortHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values[i]));
        }
        return target;
    }

    public short detectIfNone(ShortPredicate predicate, short value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortShortHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return value;
    }

    public int count(ShortPredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortShortHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(ShortPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortShortHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(ShortPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortShortHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(ShortPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortShortHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectShortToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortShortHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public MutableShortList toList() {
        return ShortArrayList.newList((ShortIterable)this);
    }

    public MutableShortSet toSet() {
        return ShortHashSet.newSet((ShortIterable)this);
    }

    public MutableShortBag toBag() {
        return ShortHashBag.newBag((ShortIterable)this);
    }

    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter((ShortIterable)this);
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, (short)0);
        Arrays.fill(this.values, (short)0);
    }

    public void put(short key, short value) {
        if (ShortShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.addEmptyKeyValue(value);
            return;
        }
        if (ShortShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.addRemovedKeyValue(value);
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = value;
            return;
        }
        this.addKeyValueAtIndex(key, value, index);
    }

    public void putAll(ShortShortMap map) {
        map.forEachKeyValue(new ShortShortProcedure(){

            public void value(short key, short value) {
                ShortShortHashMap.this.put(key, value);
            }
        });
    }

    public void removeKey(short key) {
        if (ShortShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (ShortShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1;
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(short key) {
        this.removeKey(key);
    }

    public short removeKeyIfAbsent(short key, short value) {
        if (ShortShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            short oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (ShortShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            short oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1;
            short oldValue = this.values[index];
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public short getIfAbsentPut(short key, short value) {
        if (ShortShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ShortShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public short getIfAbsentPut(short key, ShortFunction0 function) {
        if (ShortShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.value();
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            short value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ShortShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.value();
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            short value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        short value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> short getIfAbsentPutWith(short key, ShortFunction<? super P> function, P parameter) {
        if (ShortShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.shortValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            short value = function.shortValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ShortShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.shortValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            short value = function.shortValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        short value = function.shortValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public short getIfAbsentPutWithKey(short key, ShortToShortFunction function) {
        if (ShortShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            short value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ShortShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            short value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        short value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public short addToValue(short key, short toBeAdded) {
        if (ShortShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = (short)(this.sentinelValues.zeroValue + toBeAdded);
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (ShortShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = (short)(this.sentinelValues.oneValue + toBeAdded);
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            int n = index;
            this.values[n] = (short)(this.values[n] + toBeAdded);
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return this.values[index];
    }

    private void addKeyValueAtIndex(short key, short value, int index) {
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void addEmptyKeyValue(short value) {
        this.sentinelValues.containsZeroKey = true;
        this.sentinelValues.zeroValue = value;
    }

    private void removeEmptyKey() {
        if (this.sentinelValues.containsOneKey) {
            this.sentinelValues.containsZeroKey = false;
            this.sentinelValues.zeroValue = (short)0;
        } else {
            this.sentinelValues = null;
        }
    }

    private void addRemovedKeyValue(short value) {
        this.sentinelValues.containsOneKey = true;
        this.sentinelValues.oneValue = value;
    }

    private void removeRemovedKey() {
        if (this.sentinelValues.containsZeroKey) {
            this.sentinelValues.containsOneKey = false;
            this.sentinelValues.oneValue = (short)0;
        } else {
            this.sentinelValues = null;
        }
    }

    public short updateValue(short key, short initialValueIfAbsent, ShortToShortFunction function) {
        if (ShortShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (ShortShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        short value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public ShortShortHashMap withKeyValue(short key1, short value1) {
        this.put(key1, value1);
        return this;
    }

    public ShortShortHashMap withKeysValues(short key1, short value1, short key2, short value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ShortShortHashMap withKeysValues(short key1, short value1, short key2, short value2, short key3, short value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ShortShortHashMap withKeysValues(short key1, short value1, short key2, short value2, short key3, short value3, short key4, short value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public ShortShortHashMap withoutKey(short key) {
        this.removeKey(key);
        return this;
    }

    public ShortShortHashMap withoutAllKeys(ShortIterable keys) {
        keys.forEach(new ShortProcedure(){

            public void value(short key) {
                ShortShortHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableShortShortMap asUnmodifiable() {
        return new UnmodifiableShortShortMap(this);
    }

    public MutableShortShortMap asSynchronized() {
        return new SynchronizedShortShortMap(this);
    }

    public ImmutableShortShortMap toImmutable() {
        return ShortShortMaps.immutable.ofAll((ShortShortMap)this);
    }

    public short get(short key) {
        return this.getIfAbsent(key, (short)0);
    }

    public short getIfAbsent(short key, short ifAbsent) {
        if (ShortShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (ShortShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public short getOrThrow(short key) {
        if (ShortShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (ShortShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (ShortShortHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(short key) {
        if (ShortShortHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (ShortShortHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    public boolean containsValue(short value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!ShortShortHashMap.isNonSentinel(this.keys[i]) || this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    public void forEachValue(ShortProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortShortHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(ShortProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value((short)0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value((short)1);
            }
        }
        for (short key : this.keys) {
            if (!ShortShortHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(ShortShortProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value((short)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value((short)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortShortHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyShortIterable keysView() {
        return new KeysView();
    }

    public RichIterable<ShortShortPair> keyValuesView() {
        return new KeyValuesView();
    }

    public ShortShortHashMap select(ShortShortPredicate predicate) {
        ShortShortHashMap result = new ShortShortHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept((short)0, this.sentinelValues.zeroValue)) {
                result.put((short)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept((short)1, this.sentinelValues.oneValue)) {
                result.put((short)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortShortHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public ShortShortHashMap reject(ShortShortPredicate predicate) {
        ShortShortHashMap result = new ShortShortHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept((short)0, this.sentinelValues.zeroValue)) {
                result.put((short)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept((short)1, this.sentinelValues.oneValue)) {
                result.put((short)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortShortHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public long sum() {
        long result = 0L;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += (long)this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += (long)this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortShortHashMap.isNonSentinel(this.keys[i])) continue;
            result += (long)this.values[i];
        }
        return result;
    }

    public short max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        ShortIterator iterator = this.shortIterator();
        short max = iterator.next();
        while (iterator.hasNext()) {
            short value = iterator.next();
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public short maxIfEmpty(short defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public short min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        ShortIterator iterator = this.shortIterator();
        short min = iterator.next();
        while (iterator.hasNext()) {
            short value = iterator.next();
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public short minIfEmpty(short defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        short[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            short first = sortedArray[middleIndex];
            short second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public short[] toSortedArray() {
        short[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableShortList toSortedList() {
        return ShortArrayList.newList((ShortIterable)this).sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeShort(0);
                out.writeShort(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeShort(1);
                out.writeShort(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortShortHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeShort(this.keys[i]);
            out.writeShort(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readShort(), in.readShort());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        short[] old = this.keys;
        short[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ShortShortHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(short element) {
        int index = this.spread(element);
        short keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == 1) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(short element) {
        int code = element;
        code ^= 0x3D ^ code >> 16;
        code += code << 3;
        code ^= code >> 4;
        code *= 668265261;
        code ^= code >> 15;
        return code & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new short[sizeToAllocate];
        this.values = new short[sizeToAllocate];
    }

    private static boolean isEmptyKey(short key) {
        return key == 0;
    }

    private static boolean isRemovedKey(short key) {
        return key == 1;
    }

    private static boolean isNonSentinel(short key) {
        return !ShortShortHashMap.isEmptyKey(key) && !ShortShortHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableShortSet keySet() {
        return new KeySet();
    }

    public MutableShortCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ short[] access$802(ShortShortHashMap x0, short[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ short[] access$1002(ShortShortHashMap x0, short[] x1) {
        x0.values = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyValuesView
    extends AbstractLazyIterable<ShortShortPair> {
        private KeyValuesView() {
        }

        public void forEach(Procedure<? super ShortShortPair> procedure) {
            if (ShortShortHashMap.this.sentinelValues != null) {
                if (ShortShortHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair((short)0, ShortShortHashMap.this.sentinelValues.zeroValue));
                }
                if (ShortShortHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair((short)1, ShortShortHashMap.this.sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < ShortShortHashMap.this.keys.length; ++i) {
                if (!ShortShortHashMap.isNonSentinel(ShortShortHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(ShortShortHashMap.this.keys[i], ShortShortHashMap.this.values[i]));
            }
        }

        public void forEachWithIndex(ObjectIntProcedure<? super ShortShortPair> objectIntProcedure) {
            int index = 0;
            if (ShortShortHashMap.this.sentinelValues != null) {
                if (ShortShortHashMap.this.sentinelValues.containsZeroKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair((short)0, ShortShortHashMap.this.sentinelValues.zeroValue), index);
                    ++index;
                }
                if (ShortShortHashMap.this.sentinelValues.containsOneKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair((short)1, ShortShortHashMap.this.sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < ShortShortHashMap.this.keys.length; ++i) {
                if (!ShortShortHashMap.isNonSentinel(ShortShortHashMap.this.keys[i])) continue;
                objectIntProcedure.value((Object)PrimitiveTuples.pair(ShortShortHashMap.this.keys[i], ShortShortHashMap.this.values[i]), index);
                ++index;
            }
        }

        public <P> void forEachWith(Procedure2<? super ShortShortPair, ? super P> procedure, P parameter) {
            if (ShortShortHashMap.this.sentinelValues != null) {
                if (ShortShortHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair((short)0, ShortShortHashMap.this.sentinelValues.zeroValue), parameter);
                }
                if (ShortShortHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair((short)1, ShortShortHashMap.this.sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < ShortShortHashMap.this.keys.length; ++i) {
                if (!ShortShortHashMap.isNonSentinel(ShortShortHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(ShortShortHashMap.this.keys[i], ShortShortHashMap.this.values[i]), parameter);
            }
        }

        public Iterator<ShortShortPair> iterator() {
            return new InternalKeyValuesIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeyValuesIterator
        implements Iterator<ShortShortPair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public ShortShortPair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (ShortShortHashMap.this.containsKey((short)0)) {
                        return PrimitiveTuples.pair((short)0, ShortShortHashMap.this.sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (ShortShortHashMap.this.containsKey((short)1)) {
                        return PrimitiveTuples.pair((short)1, ShortShortHashMap.this.sentinelValues.oneValue);
                    }
                }
                short[] keys = ShortShortHashMap.this.keys;
                while (!ShortShortHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                ShortShortPair result = PrimitiveTuples.pair(keys[this.position], ShortShortHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ShortShortHashMap.this.size();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableShortCollection {
        private ValuesCollection() {
        }

        public void clear() {
            ShortShortHashMap.this.clear();
        }

        public MutableShortCollection select(ShortPredicate predicate) {
            return ShortShortHashMap.this.select(predicate);
        }

        public MutableShortCollection reject(ShortPredicate predicate) {
            return ShortShortHashMap.this.reject(predicate);
        }

        public short detectIfNone(ShortPredicate predicate, short ifNone) {
            return ShortShortHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(ShortToObjectFunction<? extends V> function) {
            return ShortShortHashMap.this.collect(function);
        }

        public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
            return ShortShortHashMap.this.injectInto(injectedValue, function);
        }

        public long sum() {
            return ShortShortHashMap.this.sum();
        }

        public short max() {
            return ShortShortHashMap.this.max();
        }

        public short maxIfEmpty(short defaultValue) {
            return ShortShortHashMap.this.maxIfEmpty(defaultValue);
        }

        public short min() {
            return ShortShortHashMap.this.min();
        }

        public short minIfEmpty(short defaultValue) {
            return ShortShortHashMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return ShortShortHashMap.this.average();
        }

        public double median() {
            return ShortShortHashMap.this.median();
        }

        public short[] toSortedArray() {
            return ShortShortHashMap.this.toSortedArray();
        }

        public MutableShortList toSortedList() {
            return ShortShortHashMap.this.toSortedList();
        }

        public MutableShortCollection with(short element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableShortCollection without(short element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableShortCollection withAll(ShortIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableShortCollection withoutAll(ShortIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public MutableShortCollection asUnmodifiable() {
            return UnmodifiableShortCollection.of(this);
        }

        public MutableShortCollection asSynchronized() {
            return SynchronizedShortCollection.of(this);
        }

        public ImmutableShortCollection toImmutable() {
            return ShortLists.immutable.withAll((ShortIterable)this);
        }

        public boolean contains(short value) {
            return ShortShortHashMap.this.containsValue(value);
        }

        public boolean containsAll(short ... source) {
            return ShortShortHashMap.this.containsAll(source);
        }

        public boolean containsAll(ShortIterable source) {
            return ShortShortHashMap.this.containsAll(source);
        }

        public MutableShortList toList() {
            return ShortShortHashMap.this.toList();
        }

        public MutableShortSet toSet() {
            return ShortShortHashMap.this.toSet();
        }

        public MutableShortBag toBag() {
            return ShortShortHashMap.this.toBag();
        }

        public LazyShortIterable asLazy() {
            return new LazyShortIterableAdapter((ShortIterable)this);
        }

        public boolean isEmpty() {
            return ShortShortHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return ShortShortHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (ShortShortHashMap.this.sentinelValues != null) {
                    if (ShortShortHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(ShortShortHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (ShortShortHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(ShortShortHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < ShortShortHashMap.this.keys.length; ++i) {
                    short key = ShortShortHashMap.this.keys[i];
                    if (!ShortShortHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(ShortShortHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public ShortIterator shortIterator() {
            return ShortShortHashMap.this.shortIterator();
        }

        public void forEach(ShortProcedure procedure) {
            ShortShortHashMap.this.forEach(procedure);
        }

        public int count(ShortPredicate predicate) {
            return ShortShortHashMap.this.count(predicate);
        }

        public boolean anySatisfy(ShortPredicate predicate) {
            return ShortShortHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(ShortPredicate predicate) {
            return ShortShortHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(ShortPredicate predicate) {
            return ShortShortHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(short element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(short ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(ShortIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(short item) {
            int oldSize = ShortShortHashMap.this.size();
            if (ShortShortHashMap.this.sentinelValues != null) {
                if (ShortShortHashMap.this.sentinelValues.containsZeroKey && item == ShortShortHashMap.this.sentinelValues.zeroValue) {
                    ShortShortHashMap.this.removeKey((short)0);
                }
                if (ShortShortHashMap.this.sentinelValues.containsOneKey && item == ShortShortHashMap.this.sentinelValues.oneValue) {
                    ShortShortHashMap.this.removeKey((short)1);
                }
            }
            for (int i = 0; i < ShortShortHashMap.this.keys.length; ++i) {
                if (!ShortShortHashMap.isNonSentinel(ShortShortHashMap.this.keys[i]) || item != ShortShortHashMap.this.values[i]) continue;
                ShortShortHashMap.this.removeKey(ShortShortHashMap.this.keys[i]);
            }
            return oldSize != ShortShortHashMap.this.size();
        }

        public boolean removeAll(ShortIterable source) {
            int oldSize = ShortShortHashMap.this.size();
            ShortIterator iterator = source.shortIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != ShortShortHashMap.this.size();
        }

        public boolean removeAll(short ... source) {
            int oldSize = ShortShortHashMap.this.size();
            for (short item : source) {
                this.remove(item);
            }
            return oldSize != ShortShortHashMap.this.size();
        }

        public boolean retainAll(ShortIterable source) {
            int oldSize = this.size();
            Object sourceSet = source instanceof ShortSet ? (ShortSet)source : source.toSet();
            ShortShortHashMap retained = ShortShortHashMap.this.select(new ShortShortPredicate((ShortSet)sourceSet){
                final /* synthetic */ ShortSet val$sourceSet;
                {
                    this.val$sourceSet = shortSet;
                }

                public boolean accept(short key, short value) {
                    return this.val$sourceSet.contains(value);
                }
            });
            if (retained.size() != oldSize) {
                ShortShortHashMap.access$802(ShortShortHashMap.this, retained.keys);
                ShortShortHashMap.access$1002(ShortShortHashMap.this, retained.values);
                ShortShortHashMap.this.sentinelValues = retained.sentinelValues;
                ShortShortHashMap.this.occupiedWithData = retained.occupiedWithData;
                ShortShortHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(short ... source) {
            return this.retainAll((ShortIterable)ShortHashSet.newSetWith(source));
        }

        public int size() {
            return ShortShortHashMap.this.size();
        }

        public short[] toArray() {
            return ShortShortHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableShortSet {
        private KeySet() {
        }

        public ShortIterator shortIterator() {
            return new KeySetIterator();
        }

        public void forEach(ShortProcedure procedure) {
            ShortShortHashMap.this.forEachKey(procedure);
        }

        public int count(ShortPredicate predicate) {
            int count = 0;
            if (ShortShortHashMap.this.sentinelValues != null) {
                if (ShortShortHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    ++count;
                }
                if (ShortShortHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    ++count;
                }
            }
            for (short key : ShortShortHashMap.this.keys) {
                if (!ShortShortHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(ShortPredicate predicate) {
            if (ShortShortHashMap.this.sentinelValues != null) {
                if (ShortShortHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    return true;
                }
                if (ShortShortHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    return true;
                }
            }
            for (short key : ShortShortHashMap.this.keys) {
                if (!ShortShortHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(ShortPredicate predicate) {
            if (ShortShortHashMap.this.sentinelValues != null) {
                if (ShortShortHashMap.this.sentinelValues.containsZeroKey && !predicate.accept((short)0)) {
                    return false;
                }
                if (ShortShortHashMap.this.sentinelValues.containsOneKey && !predicate.accept((short)1)) {
                    return false;
                }
            }
            for (short key : ShortShortHashMap.this.keys) {
                if (!ShortShortHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(ShortPredicate predicate) {
            if (ShortShortHashMap.this.sentinelValues != null) {
                if (ShortShortHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    return false;
                }
                if (ShortShortHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    return false;
                }
            }
            for (short key : ShortShortHashMap.this.keys) {
                if (!ShortShortHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(short element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(short ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(ShortIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(short key) {
            int oldSize = ShortShortHashMap.this.size();
            ShortShortHashMap.this.removeKey(key);
            return oldSize != ShortShortHashMap.this.size();
        }

        public boolean removeAll(ShortIterable source) {
            int oldSize = ShortShortHashMap.this.size();
            ShortIterator iterator = source.shortIterator();
            while (iterator.hasNext()) {
                ShortShortHashMap.this.removeKey(iterator.next());
            }
            return oldSize != ShortShortHashMap.this.size();
        }

        public boolean removeAll(short ... source) {
            int oldSize = ShortShortHashMap.this.size();
            for (short item : source) {
                ShortShortHashMap.this.removeKey(item);
            }
            return oldSize != ShortShortHashMap.this.size();
        }

        public boolean retainAll(ShortIterable source) {
            int oldSize = this.size();
            Object sourceSet = source instanceof ShortSet ? (ShortSet)source : source.toSet();
            ShortShortHashMap retained = ShortShortHashMap.this.select(new ShortShortPredicate((ShortSet)sourceSet){
                final /* synthetic */ ShortSet val$sourceSet;
                {
                    this.val$sourceSet = shortSet;
                }

                public boolean accept(short key, short value) {
                    return this.val$sourceSet.contains(key);
                }
            });
            if (retained.size() != oldSize) {
                ShortShortHashMap.access$802(ShortShortHashMap.this, retained.keys);
                ShortShortHashMap.access$1002(ShortShortHashMap.this, retained.values);
                ShortShortHashMap.this.sentinelValues = retained.sentinelValues;
                ShortShortHashMap.this.occupiedWithData = retained.occupiedWithData;
                ShortShortHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(short ... source) {
            return this.retainAll((ShortIterable)ShortHashSet.newSetWith(source));
        }

        public void clear() {
            ShortShortHashMap.this.clear();
        }

        public MutableShortSet select(ShortPredicate predicate) {
            ShortHashSet result = new ShortHashSet();
            if (ShortShortHashMap.this.sentinelValues != null) {
                if (ShortShortHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    result.add((short)0);
                }
                if (ShortShortHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    result.add((short)1);
                }
            }
            for (short key : ShortShortHashMap.this.keys) {
                if (!ShortShortHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableShortSet reject(ShortPredicate predicate) {
            ShortHashSet result = new ShortHashSet();
            if (ShortShortHashMap.this.sentinelValues != null) {
                if (ShortShortHashMap.this.sentinelValues.containsZeroKey && !predicate.accept((short)0)) {
                    result.add((short)0);
                }
                if (ShortShortHashMap.this.sentinelValues.containsOneKey && !predicate.accept((short)1)) {
                    result.add((short)1);
                }
            }
            for (short key : ShortShortHashMap.this.keys) {
                if (!ShortShortHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableShortSet with(short element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableShortSet without(short element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableShortSet withAll(ShortIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableShortSet withoutAll(ShortIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public short detectIfNone(ShortPredicate predicate, short ifNone) {
            if (ShortShortHashMap.this.sentinelValues != null) {
                if (ShortShortHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    return 0;
                }
                if (ShortShortHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    return 1;
                }
            }
            for (short key : ShortShortHashMap.this.keys) {
                if (!ShortShortHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(ShortToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (ShortShortHashMap.this.sentinelValues != null) {
                if (ShortShortHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf((short)0));
                }
                if (ShortShortHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf((short)1));
                }
            }
            for (short key : ShortShortHashMap.this.keys) {
                if (!ShortShortHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableShortSet asUnmodifiable() {
            return UnmodifiableShortSet.of(this);
        }

        public MutableShortSet asSynchronized() {
            return SynchronizedShortSet.of(this);
        }

        public long sum() {
            long sum = 0L;
            if (ShortShortHashMap.this.sentinelValues != null) {
                if (ShortShortHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0L;
                }
                if (ShortShortHashMap.this.sentinelValues.containsOneKey) {
                    ++sum;
                }
            }
            for (short key : ShortShortHashMap.this.keys) {
                if (!ShortShortHashMap.isNonSentinel(key)) continue;
                sum += (long)key;
            }
            return sum;
        }

        public short max() {
            if (ShortShortHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            short max = 0;
            boolean isMaxSet = false;
            if (ShortShortHashMap.this.sentinelValues != null) {
                if (ShortShortHashMap.this.sentinelValues.containsZeroKey) {
                    max = 0;
                    isMaxSet = true;
                }
                if (ShortShortHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || max < 1)) {
                    max = 1;
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < ShortShortHashMap.this.keys.length; ++i) {
                if (!ShortShortHashMap.isNonSentinel(ShortShortHashMap.this.keys[i]) || isMaxSet && max >= ShortShortHashMap.this.keys[i]) continue;
                max = ShortShortHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public short maxIfEmpty(short defaultValue) {
            if (ShortShortHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public short min() {
            if (ShortShortHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            short min = 0;
            boolean isMinSet = false;
            if (ShortShortHashMap.this.sentinelValues != null) {
                if (ShortShortHashMap.this.sentinelValues.containsZeroKey) {
                    min = 0;
                    isMinSet = true;
                }
                if (ShortShortHashMap.this.sentinelValues.containsOneKey && (!isMinSet || 1 < min)) {
                    min = 1;
                    isMinSet = true;
                }
            }
            for (int i = 0; i < ShortShortHashMap.this.keys.length; ++i) {
                if (!ShortShortHashMap.isNonSentinel(ShortShortHashMap.this.keys[i]) || isMinSet && ShortShortHashMap.this.keys[i] >= min) continue;
                min = ShortShortHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public short minIfEmpty(short defaultValue) {
            if (ShortShortHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            short[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                short first = sortedArray[middleIndex];
                short second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public short[] toSortedArray() {
            short[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableShortList toSortedList() {
            return ShortArrayList.newList((ShortIterable)this).sortThis();
        }

        public short[] toArray() {
            int size = ShortShortHashMap.this.size();
            final short[] result = new short[size];
            ShortShortHashMap.this.forEachKey(new ShortProcedure(){
                private int index;

                public void value(short each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(short value) {
            return ShortShortHashMap.this.containsKey(value);
        }

        public boolean containsAll(short ... source) {
            for (short item : source) {
                if (ShortShortHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(ShortIterable source) {
            ShortIterator iterator = source.shortIterator();
            while (iterator.hasNext()) {
                if (ShortShortHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableShortList toList() {
            return ShortArrayList.newList((ShortIterable)this);
        }

        public MutableShortSet toSet() {
            return ShortHashSet.newSet((ShortIterable)this);
        }

        public MutableShortBag toBag() {
            return ShortHashBag.newBag((ShortIterable)this);
        }

        public LazyShortIterable asLazy() {
            return new LazyShortIterableAdapter((ShortIterable)this);
        }

        public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (ShortShortHashMap.this.sentinelValues != null) {
                if (ShortShortHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, (short)0);
                }
                if (ShortShortHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, (short)1);
                }
            }
            for (int i = 0; i < ShortShortHashMap.this.keys.length; ++i) {
                if (!ShortShortHashMap.isNonSentinel(ShortShortHashMap.this.keys[i])) continue;
                result = function.valueOf(result, ShortShortHashMap.this.keys[i]);
            }
            return result;
        }

        public ShortSet freeze() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".freeze() not implemented yet");
        }

        public ImmutableShortSet toImmutable() {
            return ShortSets.immutable.withAll((ShortIterable)this);
        }

        public int size() {
            return ShortShortHashMap.this.size();
        }

        public boolean isEmpty() {
            return ShortShortHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return ShortShortHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ShortSet)) {
                return false;
            }
            ShortSet other = (ShortSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (ShortShortHashMap.this.sentinelValues != null) {
                if (ShortShortHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0;
                }
                if (ShortShortHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (int i = 0; i < ShortShortHashMap.this.keys.length; ++i) {
                if (!ShortShortHashMap.isNonSentinel(ShortShortHashMap.this.keys[i])) continue;
                result += ShortShortHashMap.this.keys[i];
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (ShortShortHashMap.this.sentinelValues != null) {
                    if (ShortShortHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0));
                        first = false;
                    }
                    if (ShortShortHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1));
                        first = false;
                    }
                }
                for (short key : ShortShortHashMap.this.keys) {
                    if (!ShortShortHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class KeySetIterator
    implements ShortIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < ShortShortHashMap.this.size();
        }

        public short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ShortShortHashMap.this.containsKey((short)0)) {
                    return 0;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ShortShortHashMap.this.containsKey((short)1)) {
                    return 1;
                }
            }
            short[] keys = ShortShortHashMap.this.keys;
            while (!ShortShortHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            short result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    private class KeysView
    extends AbstractLazyShortIterable {
        private KeysView() {
        }

        public ShortIterator shortIterator() {
            return new KeySetIterator();
        }

        public void forEach(ShortProcedure procedure) {
            ShortShortHashMap.this.forEachKey(procedure);
        }
    }

    private class InternalShortIterator
    implements ShortIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalShortIterator() {
        }

        public boolean hasNext() {
            return this.count < ShortShortHashMap.this.size();
        }

        public short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ShortShortHashMap.this.containsKey((short)0)) {
                    return ShortShortHashMap.this.get((short)0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ShortShortHashMap.this.containsKey((short)1)) {
                    return ShortShortHashMap.this.get((short)1);
                }
            }
            short[] keys = ShortShortHashMap.this.keys;
            while (!ShortShortHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            short result = ShortShortHashMap.this.values[this.position];
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private short zeroValue;
        private short oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(short value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && this.zeroValue == value;
            boolean valueEqualsOneValue = this.containsOneKey && this.oneValue == value;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

