/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.api.RegistryException;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.RegistryCredentialRetriever;
import com.google.cloud.tools.jib.configuration.BuildContext;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.credentials.CredentialRetrievalException;
import java.io.IOException;
import java.util.concurrent.Callable;

class AuthenticatePushStep
implements Callable<RegistryClient> {
    private static final String DESCRIPTION = "Authenticating push to %s";
    private final BuildContext buildContext;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;

    AuthenticatePushStep(BuildContext buildContext, ProgressEventDispatcher.Factory progressEventDispatcherFactory) {
        this.buildContext = buildContext;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
    }

    @Override
    public RegistryClient call() throws CredentialRetrievalException, IOException, RegistryException {
        String registry = this.buildContext.getTargetImageConfiguration().getImageRegistry();
        Throwable throwable = null;
        try (ProgressEventDispatcher progressDispatcher = this.progressEventDispatcherFactory.create("authenticating push to " + registry, 2L);){
            RegistryClient registryClient;
            TimerEventDispatcher ignored2 = new TimerEventDispatcher(this.buildContext.getEventHandlers(), String.format(DESCRIPTION, registry));
            Throwable throwable2 = null;
            try {
                Credential credential = RegistryCredentialRetriever.getTargetImageCredential(this.buildContext).orElse(null);
                progressDispatcher.dispatchProgress(1L);
                RegistryClient registryClient2 = this.buildContext.newTargetImageRegistryClientFactory().setCredential(credential).newRegistryClient();
                if (!registryClient2.doPushBearerAuth() && credential != null && !credential.isOAuth2RefreshToken()) {
                    registryClient2.configureBasicAuth();
                }
                registryClient = registryClient2;
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AuthenticatePushStep.$closeResource(throwable2, ignored2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            AuthenticatePushStep.$closeResource(throwable2, ignored2);
            return registryClient;
        }
    }
}

