/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.image.json.HistoryEntry;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ContainerConfigurationTemplate
implements JsonTemplate {
    @Nullable
    private String created;
    private String architecture = "amd64";
    private String os = "linux";
    private final ConfigurationObjectTemplate config = new ConfigurationObjectTemplate();
    private final List<HistoryEntry> history = new ArrayList<HistoryEntry>();
    private final RootFilesystemObjectTemplate rootfs = new RootFilesystemObjectTemplate();

    public void setCreated(@Nullable String created) {
        this.created = created;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public void setContainerEnvironment(@Nullable List<String> environment) {
        this.config.Env = environment;
    }

    public void setContainerEntrypoint(@Nullable List<String> command) {
        this.config.Entrypoint = command;
    }

    public void setContainerCmd(@Nullable List<String> cmd) {
        this.config.Cmd = cmd;
    }

    public void setContainerHealthCheckTest(List<String> test) {
        if (this.config.Healthcheck == null) {
            this.config.Healthcheck = new HealthCheckObjectTemplate();
        }
        ((HealthCheckObjectTemplate)Preconditions.checkNotNull((Object)this.config.Healthcheck)).Test = test;
    }

    public void setContainerHealthCheckInterval(@Nullable Long interval) {
        if (this.config.Healthcheck == null) {
            this.config.Healthcheck = new HealthCheckObjectTemplate();
        }
        ((HealthCheckObjectTemplate)Preconditions.checkNotNull((Object)this.config.Healthcheck)).Interval = interval;
    }

    public void setContainerHealthCheckTimeout(@Nullable Long timeout) {
        if (this.config.Healthcheck == null) {
            this.config.Healthcheck = new HealthCheckObjectTemplate();
        }
        ((HealthCheckObjectTemplate)Preconditions.checkNotNull((Object)this.config.Healthcheck)).Timeout = timeout;
    }

    public void setContainerHealthCheckStartPeriod(@Nullable Long startPeriod) {
        if (this.config.Healthcheck == null) {
            this.config.Healthcheck = new HealthCheckObjectTemplate();
        }
        ((HealthCheckObjectTemplate)Preconditions.checkNotNull((Object)this.config.Healthcheck)).StartPeriod = startPeriod;
    }

    public void setContainerHealthCheckRetries(@Nullable Integer retries) {
        if (this.config.Healthcheck == null) {
            this.config.Healthcheck = new HealthCheckObjectTemplate();
        }
        ((HealthCheckObjectTemplate)Preconditions.checkNotNull((Object)this.config.Healthcheck)).Retries = retries;
    }

    public void setContainerExposedPorts(@Nullable Map<String, Map<String, String>> exposedPorts) {
        this.config.ExposedPorts = exposedPorts;
    }

    public void setContainerLabels(@Nullable Map<String, String> labels) {
        this.config.Labels = labels;
    }

    public void setContainerWorkingDir(@Nullable String workingDirectory) {
        this.config.WorkingDir = workingDirectory;
    }

    public void setContainerUser(@Nullable String user) {
        this.config.User = user;
    }

    public void setContainerVolumes(@Nullable Map<String, Map<String, String>> volumes) {
        this.config.Volumes = volumes;
    }

    public void addLayerDiffId(DescriptorDigest diffId) {
        this.rootfs.diff_ids.add(diffId);
    }

    public void addHistoryEntry(HistoryEntry historyEntry) {
        this.history.add(historyEntry);
    }

    List<DescriptorDigest> getDiffIds() {
        return this.rootfs.diff_ids;
    }

    List<HistoryEntry> getHistory() {
        return this.history;
    }

    @Nullable
    String getCreated() {
        return this.created;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getOs() {
        return this.os;
    }

    @Nullable
    List<String> getContainerEnvironment() {
        return this.config.Env;
    }

    @Nullable
    List<String> getContainerEntrypoint() {
        return this.config.Entrypoint;
    }

    @Nullable
    List<String> getContainerCmd() {
        return this.config.Cmd;
    }

    @Nullable
    List<String> getContainerHealthTest() {
        return this.config.Healthcheck == null ? null : this.config.Healthcheck.Test;
    }

    @Nullable
    Long getContainerHealthInterval() {
        return this.config.Healthcheck == null ? null : this.config.Healthcheck.Interval;
    }

    @Nullable
    Long getContainerHealthTimeout() {
        return this.config.Healthcheck == null ? null : this.config.Healthcheck.Timeout;
    }

    @Nullable
    Long getContainerHealthStartPeriod() {
        return this.config.Healthcheck == null ? null : this.config.Healthcheck.StartPeriod;
    }

    @Nullable
    Integer getContainerHealthRetries() {
        return this.config.Healthcheck == null ? null : this.config.Healthcheck.Retries;
    }

    @Nullable
    Map<String, Map<String, String>> getContainerExposedPorts() {
        return this.config.ExposedPorts;
    }

    @Nullable
    Map<String, String> getContainerLabels() {
        return this.config.Labels;
    }

    @Nullable
    String getContainerWorkingDir() {
        return this.config.WorkingDir;
    }

    @Nullable
    String getContainerUser() {
        return this.config.User;
    }

    @Nullable
    Map<String, Map<String, String>> getContainerVolumes() {
        return this.config.Volumes;
    }

    public DescriptorDigest getLayerDiffId(int index) {
        return (DescriptorDigest)this.rootfs.diff_ids.get(index);
    }

    public int getLayerCount() {
        return this.rootfs.diff_ids.size();
    }

    private static class RootFilesystemObjectTemplate
    implements JsonTemplate {
        private final String type = "layers";
        private final List<DescriptorDigest> diff_ids = new ArrayList<DescriptorDigest>();

        private RootFilesystemObjectTemplate() {
        }
    }

    private static class HealthCheckObjectTemplate
    implements JsonTemplate {
        @Nullable
        private List<String> Test;
        @Nullable
        private Long Interval;
        @Nullable
        private Long Timeout;
        @Nullable
        private Long StartPeriod;
        @Nullable
        private Integer Retries;

        private HealthCheckObjectTemplate() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class ConfigurationObjectTemplate
    implements JsonTemplate {
        @Nullable
        private List<String> Env;
        @Nullable
        private List<String> Entrypoint;
        @Nullable
        private List<String> Cmd;
        @Nullable
        private HealthCheckObjectTemplate Healthcheck;
        @Nullable
        private Map<String, Map<String, String>> ExposedPorts;
        @Nullable
        private Map<String, String> Labels;
        @Nullable
        private String WorkingDir;
        @Nullable
        private String User;
        @Nullable
        private Map<String, Map<String, String>> Volumes;

        private ConfigurationObjectTemplate() {
        }
    }
}

