/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class V22ManifestListTemplate
implements ManifestTemplate {
    public static final String MANIFEST_MEDIA_TYPE = "application/vnd.docker.distribution.manifest.list.v2+json";
    private static final int SCHEMA_VERSION = 2;
    private final int schemaVersion = 2;
    private final String mediaType = "application/vnd.docker.distribution.manifest.list.v2+json";
    @Nullable
    private List<ManifestDescriptorTemplate> manifests;

    @Override
    public int getSchemaVersion() {
        return 2;
    }

    @Override
    public String getManifestMediaType() {
        return MANIFEST_MEDIA_TYPE;
    }

    public void addManifest(ManifestDescriptorTemplate manifest) {
        if (this.manifests == null) {
            this.manifests = new ArrayList<ManifestDescriptorTemplate>();
        }
        this.manifests.add(manifest);
    }

    @VisibleForTesting
    public List<ManifestDescriptorTemplate> getManifests() {
        return (List)Preconditions.checkNotNull(this.manifests);
    }

    public List<String> getDigestsForPlatform(String architecture, String os) {
        return this.getManifests().stream().filter(manifest -> ((ManifestDescriptorTemplate)manifest).platform != null && os.equals(((ManifestDescriptorTemplate)manifest).platform.os) && architecture.equals(((ManifestDescriptorTemplate)manifest).platform.architecture)).map(ManifestDescriptorTemplate::getDigest).collect(Collectors.toList());
    }

    public static class ManifestDescriptorTemplate
    implements JsonTemplate {
        @Nullable
        private String mediaType;
        @Nullable
        private String digest;
        private long size;
        @Nullable
        private Platform platform;

        public void setSize(long size) {
            this.size = size;
        }

        public void setDigest(String digest) {
            this.digest = digest;
        }

        @Nullable
        public String getDigest() {
            return this.digest;
        }

        public void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        @Nullable
        public String getMediaType() {
            return this.mediaType;
        }

        public void setPlatform(String architecture, String os) {
            this.platform = new Platform();
            this.platform.architecture = architecture;
            this.platform.os = os;
        }

        @Nullable
        public Platform getPlatform() {
            return this.platform;
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class Platform
        implements JsonTemplate {
            @Nullable
            private String architecture;
            @Nullable
            private String os;

            @Nullable
            public String getArchitecture() {
                return this.architecture;
            }

            @Nullable
            public String getOs() {
                return this.os;
            }
        }
    }
}

