/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=21.0
//  number=$Revision: 6546 Google $
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $
//  type=root


/**
 * Localized names for the "fa" locale.
 */
public class LocalizedNamesImpl_fa extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "IR",
        "AF",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "BQ",
        "CW",
        "SS",
        "SX",
        "AW",
        "AR",
        "AL",
        "DE",
        "AN",
        "AG",
        "AD",
        "AO",
        "AI",
        "EU",
        "AT",
        "ET",
        "JO",
        "AM",
        "UY",
        "ER",
        "UZ",
        "AU",
        "EE",
        "IL",
        "SK",
        "SI",
        "SJ",
        "ES",
        "ZA",
        "AF",
        "DZ",
        "SV",
        "AE",
        "ID",
        "UA",
        "UG",
        "EC",
        "US",
        "IT",
        "IR",
        "IE",
        "IS",
        "BB",
        "BS",
        "BH",
        "QO",
        "BR",
        "BM",
        "BN",
        "GB",
        "BG",
        "BE",
        "BZ",
        "BD",
        "BJ",
        "BT",
        "BW",
        "BI",
        "BF",
        "BA",
        "BO",
        "BY",
        "TJ",
        "TZ",
        "TH",
        "TW",
        "TM",
        "TR",
        "TA",
        "TT",
        "TN",
        "TO",
        "TV",
        "TK",
        "TG",
        "TL",
        "JM",
        "GI",
        "JE",
        "AC",
        "AX",
        "TC",
        "SB",
        "FO",
        "FK",
        "IC",
        "MH",
        "MP",
        "VI",
        "VG",
        "PN",
        "CP",
        "UM",
        "CK",
        "CC",
        "KY",
        "BV",
        "IM",
        "NF",
        "HM",
        "CX",
        "AZ",
        "CF",
        "DO",
        "CZ",
        "AQ",
        "GS",
        "DJ",
        "DK",
        "DM",
        "DG",
        "RW",
        "RU",
        "RO",
        "RE",
        "ZM",
        "NZ",
        "ZW",
        "ST",
        "CI",
        "WS",
        "AS",
        "SM",
        "EA",
        "PS",
        "LK",
        "BL",
        "LC",
        "MF",
        "SH",
        "VC",
        "PM",
        "KN",
        "SN",
        "SG",
        "SE",
        "CH",
        "SZ",
        "SD",
        "SR",
        "SY",
        "SO",
        "SL",
        "SC",
        "CL",
        "EH",
        "RS",
        "CS",
        "IQ",
        "SA",
        "OM",
        "GH",
        "FR",
        "FI",
        "FJ",
        "PH",
        "CY",
        "KG",
        "KZ",
        "QA",
        "LA",
        "LB",
        "LV",
        "LS",
        "PL",
        "LU",
        "LR",
        "LY",
        "LT",
        "LI",
        "MG",
        "MQ",
        "MW",
        "MT",
        "MV",
        "MY",
        "ML",
        "MO",
        "YT",
        "HU",
        "MA",
        "IO",
        "TF",
        "EG",
        "MN",
        "MK",
        "MR",
        "MU",
        "MZ",
        "MD",
        "MC",
        "MS",
        "ME",
        "MX",
        "MM",
        "FM",
        "NR",
        "NA",
        "NO",
        "NP",
        "NE",
        "NG",
        "NU",
        "NI",
        "HT",
        "NL",
        "IN",
        "HN",
        "HK",
        "VA",
        "WF",
        "VU",
        "VE",
        "VN",
        "PY",
        "PW",
        "PA",
        "PG",
        "PK",
        "PT",
        "PE",
        "PF",
        "PR",
        "TD",
        "CN",
        "JP",
        "CR",
        "NC",
        "KH",
        "CM",
        "CA",
        "KR",
        "KP",
        "HR",
        "KI",
        "CO",
        "CG",
        "CD",
        "KE",
        "CU",
        "KM",
        "KW",
        "CV",
        "GA",
        "GM",
        "GD",
        "GE",
        "GG",
        "GL",
        "GT",
        "GP",
        "GU",
        "GY",
        "GF",
        "GN",
        "GQ",
        "GW",
        "YE",
        "GR",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "جهان");
    namesMap.put("002", "افریقا");
    namesMap.put("003", "امریکای شمالی");
    namesMap.put("005", "امریکای جنوبی");
    namesMap.put("009", "اقیانوسیه");
    namesMap.put("011", "غرب افریقا");
    namesMap.put("013", "امریکای مرکزی");
    namesMap.put("014", "شرق افریقا");
    namesMap.put("015", "شمال افریقا");
    namesMap.put("017", "مرکز افریقا");
    namesMap.put("018", "جنوب افریقا");
    namesMap.put("019", "امریکا");
    namesMap.put("021", "شمال امریکا");
    namesMap.put("029", "کارائیب");
    namesMap.put("030", "شرق آسیا");
    namesMap.put("034", "جنوب آسیا");
    namesMap.put("035", "جنوب شرقی آسیا");
    namesMap.put("039", "جنوب اروپا");
    namesMap.put("053", "استرالیا و زلاند نو");
    namesMap.put("054", "ملانزی");
    namesMap.put("057", "ناحیهٔ میکرونزی");
    namesMap.put("061", "پلی‌نزی");
    namesMap.put("142", "آسیا");
    namesMap.put("143", "آسیای مرکزی");
    namesMap.put("145", "غرب آسیا");
    namesMap.put("150", "اروپا");
    namesMap.put("151", "شرق اروپا");
    namesMap.put("154", "شمال اروپا");
    namesMap.put("155", "غرب اروپا");
    namesMap.put("419", "امریکای لاتین");
    namesMap.put("AC", "جزایر آسنسیون");
    namesMap.put("AD", "آندورا");
    namesMap.put("AE", "امارات متحدهٔ عربی");
    namesMap.put("AF", "افغانستان");
    namesMap.put("AG", "آنتیگوا و باربودا");
    namesMap.put("AI", "آنگیل");
    namesMap.put("AL", "آلبانی");
    namesMap.put("AM", "ارمنستان");
    namesMap.put("AN", "آنتیل هلند");
    namesMap.put("AO", "آنگولا");
    namesMap.put("AQ", "جنوبگان");
    namesMap.put("AR", "آرژانتین");
    namesMap.put("AS", "ساموای امریکا");
    namesMap.put("AT", "اتریش");
    namesMap.put("AU", "استرالیا");
    namesMap.put("AW", "آروبا");
    namesMap.put("AX", "جزایر آلاند");
    namesMap.put("AZ", "جمهوری آذربایجان");
    namesMap.put("BA", "بوسنی و هرزگوین");
    namesMap.put("BB", "باربادوس");
    namesMap.put("BD", "بنگلادش");
    namesMap.put("BE", "بلژیک");
    namesMap.put("BF", "بورکینافاسو");
    namesMap.put("BG", "بلغارستان");
    namesMap.put("BH", "بحرین");
    namesMap.put("BI", "بوروندی");
    namesMap.put("BJ", "بنین");
    namesMap.put("BL", "سنت بارتیلمی");
    namesMap.put("BM", "برمودا");
    namesMap.put("BN", "برونئی");
    namesMap.put("BO", "بولیوی");
    namesMap.put("BR", "برزیل");
    namesMap.put("BS", "باهاما");
    namesMap.put("BT", "بوتان");
    namesMap.put("BV", "جزیره بووت");
    namesMap.put("BW", "بوتسوانا");
    namesMap.put("BY", "بیلوروسی");
    namesMap.put("BZ", "بلیز");
    namesMap.put("CA", "کانادا");
    namesMap.put("CC", "جزایر کوکوس [کیلینگ]");
    namesMap.put("CD", "کنگو - کینشاسا");
    namesMap.put("CF", "جمهوری افریقای مرکزی");
    namesMap.put("CG", "کنگو - برازویل");
    namesMap.put("CH", "سوئیس");
    namesMap.put("CI", "ساحل عاج");
    namesMap.put("CK", "جزایر کوک");
    namesMap.put("CL", "شیلی");
    namesMap.put("CM", "کامرون");
    namesMap.put("CN", "چین");
    namesMap.put("CO", "کلمبیا");
    namesMap.put("CP", "جزایر کلیپرتون");
    namesMap.put("CR", "کاستاریکا");
    namesMap.put("CS", "صربستان و مونته‌نگرو");
    namesMap.put("CU", "کوبا");
    namesMap.put("CV", "کیپ‌ورد");
    namesMap.put("CX", "جزیرهٔ کریسمس");
    namesMap.put("CY", "قبرس");
    namesMap.put("CZ", "جمهوری چک");
    namesMap.put("DE", "آلمان");
    namesMap.put("DG", "دیه‌گو گارسیا");
    namesMap.put("DJ", "جیبوتی");
    namesMap.put("DK", "دانمارک");
    namesMap.put("DM", "دومینیک");
    namesMap.put("DO", "جمهوری دومینیکن");
    namesMap.put("DZ", "الجزایر");
    namesMap.put("EA", "سبته و ملیله");
    namesMap.put("EC", "اکوادور");
    namesMap.put("EE", "استونی");
    namesMap.put("EG", "مصر");
    namesMap.put("EH", "صحرای غربی");
    namesMap.put("ER", "اریتره");
    namesMap.put("ES", "اسپانیا");
    namesMap.put("ET", "اتیوپی");
    namesMap.put("EU", "اتحادیهٔ اروپا");
    namesMap.put("FI", "فنلاند");
    namesMap.put("FJ", "فیجی");
    namesMap.put("FK", "جزایر فالکلند");
    namesMap.put("FM", "میکرونزی");
    namesMap.put("FO", "جزایر فارو");
    namesMap.put("FR", "فرانسه");
    namesMap.put("GA", "گابون");
    namesMap.put("GB", "بریتانیا");
    namesMap.put("GD", "گرانادا");
    namesMap.put("GE", "گرجستان");
    namesMap.put("GF", "گویان فرانسه");
    namesMap.put("GG", "گرنزی");
    namesMap.put("GH", "غنا");
    namesMap.put("GI", "جبل‌الطارق");
    namesMap.put("GL", "گرینلند");
    namesMap.put("GM", "گامبیا");
    namesMap.put("GN", "گینه");
    namesMap.put("GP", "گوادلوپ");
    namesMap.put("GQ", "گینهٔ استوایی");
    namesMap.put("GR", "یونان");
    namesMap.put("GS", "جورجیای جنوبی و جزایر ساندویچ جنوبی");
    namesMap.put("GT", "گواتمالا");
    namesMap.put("GU", "گوام");
    namesMap.put("GW", "گینهٔ بیسائو");
    namesMap.put("GY", "گویان");
    namesMap.put("HK", "هنگ‌کنگ");
    namesMap.put("HM", "جزیرهٔ هرد و جزایر مک‌دونالد");
    namesMap.put("HN", "هندوراس");
    namesMap.put("HR", "کرواسی");
    namesMap.put("HT", "هائیتی");
    namesMap.put("HU", "مجارستان");
    namesMap.put("IC", "جزایر قناری");
    namesMap.put("ID", "اندونزی");
    namesMap.put("IE", "ایرلند");
    namesMap.put("IL", "اسرائیل");
    namesMap.put("IM", "جزیرهٔ من");
    namesMap.put("IN", "هند");
    namesMap.put("IO", "مستعمره‌های بریتانیا در اقیانوس هند");
    namesMap.put("IQ", "عراق");
    namesMap.put("IR", "ایران");
    namesMap.put("IS", "ایسلند");
    namesMap.put("IT", "ایتالیا");
    namesMap.put("JE", "جرزی");
    namesMap.put("JM", "جامائیکا");
    namesMap.put("JO", "اردن");
    namesMap.put("JP", "ژاپن");
    namesMap.put("KE", "کنیا");
    namesMap.put("KG", "قرقیزستان");
    namesMap.put("KH", "کامبوج");
    namesMap.put("KI", "کریباتی");
    namesMap.put("KM", "کومورو");
    namesMap.put("KN", "سنت کیتس و نویس");
    namesMap.put("KP", "کرهٔ شمالی");
    namesMap.put("KR", "کرهٔ جنوبی");
    namesMap.put("KW", "کویت");
    namesMap.put("KY", "جزایر کِیمن");
    namesMap.put("KZ", "قزاقستان");
    namesMap.put("LA", "لائوس");
    namesMap.put("LB", "لبنان");
    namesMap.put("LC", "سنت لوسیا");
    namesMap.put("LI", "لیختن‌اشتاین");
    namesMap.put("LK", "سری‌لانکا");
    namesMap.put("LR", "لیبریا");
    namesMap.put("LS", "لسوتو");
    namesMap.put("LT", "لیتوانی");
    namesMap.put("LU", "لوکزامبورگ");
    namesMap.put("LV", "لتونی");
    namesMap.put("LY", "لیبی");
    namesMap.put("MA", "مراکش");
    namesMap.put("MC", "موناکو");
    namesMap.put("MD", "مولداوی");
    namesMap.put("ME", "مونته‌نگرو");
    namesMap.put("MF", "سنت مارتین");
    namesMap.put("MG", "ماداگاسکار");
    namesMap.put("MH", "جزایر مارشال");
    namesMap.put("MK", "مقدونیه");
    namesMap.put("ML", "مالی");
    namesMap.put("MM", "میانمار [برمه]");
    namesMap.put("MN", "مغولستان");
    namesMap.put("MO", "ماکائو");
    namesMap.put("MP", "جزایر ماریانای شمالی");
    namesMap.put("MQ", "مارتینیک");
    namesMap.put("MR", "موریتانی");
    namesMap.put("MS", "مونت‌سرات");
    namesMap.put("MT", "مالت");
    namesMap.put("MU", "موریس");
    namesMap.put("MV", "مالدیو");
    namesMap.put("MW", "مالاوی");
    namesMap.put("MX", "مکزیک");
    namesMap.put("MY", "مالزی");
    namesMap.put("MZ", "موزامبیک");
    namesMap.put("NA", "نامیبیا");
    namesMap.put("NC", "کالدونیای جدید");
    namesMap.put("NE", "نیجر");
    namesMap.put("NF", "جزیرهٔ نورفولک");
    namesMap.put("NG", "نیجریه");
    namesMap.put("NI", "نیکاراگوئه");
    namesMap.put("NL", "هلند");
    namesMap.put("NO", "نروژ");
    namesMap.put("NP", "نپال");
    namesMap.put("NR", "نائورو");
    namesMap.put("NU", "نیوئه");
    namesMap.put("NZ", "زلاند نو");
    namesMap.put("OM", "عمان");
    namesMap.put("PA", "پاناما");
    namesMap.put("PE", "پرو");
    namesMap.put("PF", "پلی‌نزی فرانسه");
    namesMap.put("PG", "پاپوا گینهٔ نو");
    namesMap.put("PH", "فیلیپین");
    namesMap.put("PK", "پاکستان");
    namesMap.put("PL", "لهستان");
    namesMap.put("PM", "سنت پیر و میکلون");
    namesMap.put("PN", "جزایر پیت‌کرن");
    namesMap.put("PR", "پورتوریکو");
    namesMap.put("PS", "سرزمین‌های فلسطینی");
    namesMap.put("PT", "پرتغال");
    namesMap.put("PW", "پالائو");
    namesMap.put("PY", "پاراگوئه");
    namesMap.put("QA", "قطر");
    namesMap.put("QO", "بخش‌های دورافتادهٔ اقیانوسیه");
    namesMap.put("RE", "ریونیون");
    namesMap.put("RO", "رومانی");
    namesMap.put("RS", "صربستان");
    namesMap.put("RU", "روسیه");
    namesMap.put("RW", "رواندا");
    namesMap.put("SA", "عربستان سعودی");
    namesMap.put("SB", "جزایر سلیمان");
    namesMap.put("SC", "سیشل");
    namesMap.put("SD", "سودان");
    namesMap.put("SE", "سوئد");
    namesMap.put("SG", "سنگاپور");
    namesMap.put("SH", "سنت هلن");
    namesMap.put("SI", "اسلوونی");
    namesMap.put("SJ", "اسوالبارد و جان‌ماین");
    namesMap.put("SK", "اسلواکی");
    namesMap.put("SL", "سیرالئون");
    namesMap.put("SM", "سان‌مارینو");
    namesMap.put("SN", "سنگال");
    namesMap.put("SO", "سومالی");
    namesMap.put("SR", "سورینام");
    namesMap.put("ST", "سائوتومه و پرینسیپه");
    namesMap.put("SV", "السالوادور");
    namesMap.put("SY", "سوریه");
    namesMap.put("SZ", "سوازیلند");
    namesMap.put("TA", "تریستان دا کونا");
    namesMap.put("TC", "جزایر ترک و کایکوس");
    namesMap.put("TD", "چاد");
    namesMap.put("TF", "مستعمره‌های جنوبی فرانسه");
    namesMap.put("TG", "توگو");
    namesMap.put("TH", "تایلند");
    namesMap.put("TJ", "تاجیکستان");
    namesMap.put("TK", "توکلائو");
    namesMap.put("TL", "تیمور لسته");
    namesMap.put("TM", "ترکمنستان");
    namesMap.put("TN", "تونس");
    namesMap.put("TO", "تونگا");
    namesMap.put("TR", "ترکیه");
    namesMap.put("TT", "ترینیداد و توباگو");
    namesMap.put("TV", "تووالو");
    namesMap.put("TW", "تایوان");
    namesMap.put("TZ", "تانزانیا");
    namesMap.put("UA", "اوکراین");
    namesMap.put("UG", "اوگاندا");
    namesMap.put("UM", "جزایر کوچک دورافتادهٔ ایالات متحده");
    namesMap.put("US", "ایالات متحدهٔ امریکا");
    namesMap.put("UY", "اروگوئه");
    namesMap.put("UZ", "ازبکستان");
    namesMap.put("VA", "واتیکان");
    namesMap.put("VC", "سنت وینسنت و گرنادین");
    namesMap.put("VE", "ونزوئلا");
    namesMap.put("VG", "جزایر ویرجین بریتانیا");
    namesMap.put("VI", "جزایر ویرجین ایالات متحده");
    namesMap.put("VN", "ویتنام");
    namesMap.put("VU", "وانواتو");
    namesMap.put("WF", "والیس و فیوتونا");
    namesMap.put("WS", "ساموا");
    namesMap.put("YE", "یمن");
    namesMap.put("YT", "مایوت");
    namesMap.put("ZA", "افریقای جنوبی");
    namesMap.put("ZM", "زامبیا");
    namesMap.put("ZW", "زیمبابوه");
    namesMap.put("ZZ", "ناحیهٔ نامشخص");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "جهان",
        "002": "افریقا",
        "003": "امریکای شمالی",
        "005": "امریکای جنوبی",
        "009": "اقیانوسیه",
        "011": "غرب افریقا",
        "013": "امریکای مرکزی",
        "014": "شرق افریقا",
        "015": "شمال افریقا",
        "017": "مرکز افریقا",
        "018": "جنوب افریقا",
        "019": "امریکا",
        "021": "شمال امریکا",
        "029": "کارائیب",
        "030": "شرق آسیا",
        "034": "جنوب آسیا",
        "035": "جنوب شرقی آسیا",
        "039": "جنوب اروپا",
        "053": "استرالیا و زلاند نو",
        "054": "ملانزی",
        "057": "ناحیهٔ میکرونزی",
        "061": "پلی‌نزی",
        "142": "آسیا",
        "143": "آسیای مرکزی",
        "145": "غرب آسیا",
        "150": "اروپا",
        "151": "شرق اروپا",
        "154": "شمال اروپا",
        "155": "غرب اروپا",
        "419": "امریکای لاتین",
        "AC": "جزایر آسنسیون",
        "AD": "آندورا",
        "AE": "امارات متحدهٔ عربی",
        "AF": "افغانستان",
        "AG": "آنتیگوا و باربودا",
        "AI": "آنگیل",
        "AL": "آلبانی",
        "AM": "ارمنستان",
        "AN": "آنتیل هلند",
        "AO": "آنگولا",
        "AQ": "جنوبگان",
        "AR": "آرژانتین",
        "AS": "ساموای امریکا",
        "AT": "اتریش",
        "AU": "استرالیا",
        "AW": "آروبا",
        "AX": "جزایر آلاند",
        "AZ": "جمهوری آذربایجان",
        "BA": "بوسنی و هرزگوین",
        "BB": "باربادوس",
        "BD": "بنگلادش",
        "BE": "بلژیک",
        "BF": "بورکینافاسو",
        "BG": "بلغارستان",
        "BH": "بحرین",
        "BI": "بوروندی",
        "BJ": "بنین",
        "BL": "سنت بارتیلمی",
        "BM": "برمودا",
        "BN": "برونئی",
        "BO": "بولیوی",
        "BR": "برزیل",
        "BS": "باهاما",
        "BT": "بوتان",
        "BV": "جزیره بووت",
        "BW": "بوتسوانا",
        "BY": "بیلوروسی",
        "BZ": "بلیز",
        "CA": "کانادا",
        "CC": "جزایر کوکوس [کیلینگ]",
        "CD": "کنگو - کینشاسا",
        "CF": "جمهوری افریقای مرکزی",
        "CG": "کنگو - برازویل",
        "CH": "سوئیس",
        "CI": "ساحل عاج",
        "CK": "جزایر کوک",
        "CL": "شیلی",
        "CM": "کامرون",
        "CN": "چین",
        "CO": "کلمبیا",
        "CP": "جزایر کلیپرتون",
        "CR": "کاستاریکا",
        "CS": "صربستان و مونته‌نگرو",
        "CU": "کوبا",
        "CV": "کیپ‌ورد",
        "CX": "جزیرهٔ کریسمس",
        "CY": "قبرس",
        "CZ": "جمهوری چک",
        "DE": "آلمان",
        "DG": "دیه‌گو گارسیا",
        "DJ": "جیبوتی",
        "DK": "دانمارک",
        "DM": "دومینیک",
        "DO": "جمهوری دومینیکن",
        "DZ": "الجزایر",
        "EA": "سبته و ملیله",
        "EC": "اکوادور",
        "EE": "استونی",
        "EG": "مصر",
        "EH": "صحرای غربی",
        "ER": "اریتره",
        "ES": "اسپانیا",
        "ET": "اتیوپی",
        "EU": "اتحادیهٔ اروپا",
        "FI": "فنلاند",
        "FJ": "فیجی",
        "FK": "جزایر فالکلند",
        "FM": "میکرونزی",
        "FO": "جزایر فارو",
        "FR": "فرانسه",
        "GA": "گابون",
        "GB": "بریتانیا",
        "GD": "گرانادا",
        "GE": "گرجستان",
        "GF": "گویان فرانسه",
        "GG": "گرنزی",
        "GH": "غنا",
        "GI": "جبل‌الطارق",
        "GL": "گرینلند",
        "GM": "گامبیا",
        "GN": "گینه",
        "GP": "گوادلوپ",
        "GQ": "گینهٔ استوایی",
        "GR": "یونان",
        "GS": "جورجیای جنوبی و جزایر ساندویچ جنوبی",
        "GT": "گواتمالا",
        "GU": "گوام",
        "GW": "گینهٔ بیسائو",
        "GY": "گویان",
        "HK": "هنگ‌کنگ",
        "HM": "جزیرهٔ هرد و جزایر مک‌دونالد",
        "HN": "هندوراس",
        "HR": "کرواسی",
        "HT": "هائیتی",
        "HU": "مجارستان",
        "IC": "جزایر قناری",
        "ID": "اندونزی",
        "IE": "ایرلند",
        "IL": "اسرائیل",
        "IM": "جزیرهٔ من",
        "IN": "هند",
        "IO": "مستعمره‌های بریتانیا در اقیانوس هند",
        "IQ": "عراق",
        "IR": "ایران",
        "IS": "ایسلند",
        "IT": "ایتالیا",
        "JE": "جرزی",
        "JM": "جامائیکا",
        "JO": "اردن",
        "JP": "ژاپن",
        "KE": "کنیا",
        "KG": "قرقیزستان",
        "KH": "کامبوج",
        "KI": "کریباتی",
        "KM": "کومورو",
        "KN": "سنت کیتس و نویس",
        "KP": "کرهٔ شمالی",
        "KR": "کرهٔ جنوبی",
        "KW": "کویت",
        "KY": "جزایر کِیمن",
        "KZ": "قزاقستان",
        "LA": "لائوس",
        "LB": "لبنان",
        "LC": "سنت لوسیا",
        "LI": "لیختن‌اشتاین",
        "LK": "سری‌لانکا",
        "LR": "لیبریا",
        "LS": "لسوتو",
        "LT": "لیتوانی",
        "LU": "لوکزامبورگ",
        "LV": "لتونی",
        "LY": "لیبی",
        "MA": "مراکش",
        "MC": "موناکو",
        "MD": "مولداوی",
        "ME": "مونته‌نگرو",
        "MF": "سنت مارتین",
        "MG": "ماداگاسکار",
        "MH": "جزایر مارشال",
        "MK": "مقدونیه",
        "ML": "مالی",
        "MM": "میانمار [برمه]",
        "MN": "مغولستان",
        "MO": "ماکائو",
        "MP": "جزایر ماریانای شمالی",
        "MQ": "مارتینیک",
        "MR": "موریتانی",
        "MS": "مونت‌سرات",
        "MT": "مالت",
        "MU": "موریس",
        "MV": "مالدیو",
        "MW": "مالاوی",
        "MX": "مکزیک",
        "MY": "مالزی",
        "MZ": "موزامبیک",
        "NA": "نامیبیا",
        "NC": "کالدونیای جدید",
        "NE": "نیجر",
        "NF": "جزیرهٔ نورفولک",
        "NG": "نیجریه",
        "NI": "نیکاراگوئه",
        "NL": "هلند",
        "NO": "نروژ",
        "NP": "نپال",
        "NR": "نائورو",
        "NU": "نیوئه",
        "NZ": "زلاند نو",
        "OM": "عمان",
        "PA": "پاناما",
        "PE": "پرو",
        "PF": "پلی‌نزی فرانسه",
        "PG": "پاپوا گینهٔ نو",
        "PH": "فیلیپین",
        "PK": "پاکستان",
        "PL": "لهستان",
        "PM": "سنت پیر و میکلون",
        "PN": "جزایر پیت‌کرن",
        "PR": "پورتوریکو",
        "PS": "سرزمین‌های فلسطینی",
        "PT": "پرتغال",
        "PW": "پالائو",
        "PY": "پاراگوئه",
        "QA": "قطر",
        "QO": "بخش‌های دورافتادهٔ اقیانوسیه",
        "RE": "ریونیون",
        "RO": "رومانی",
        "RS": "صربستان",
        "RU": "روسیه",
        "RW": "رواندا",
        "SA": "عربستان سعودی",
        "SB": "جزایر سلیمان",
        "SC": "سیشل",
        "SD": "سودان",
        "SE": "سوئد",
        "SG": "سنگاپور",
        "SH": "سنت هلن",
        "SI": "اسلوونی",
        "SJ": "اسوالبارد و جان‌ماین",
        "SK": "اسلواکی",
        "SL": "سیرالئون",
        "SM": "سان‌مارینو",
        "SN": "سنگال",
        "SO": "سومالی",
        "SR": "سورینام",
        "ST": "سائوتومه و پرینسیپه",
        "SV": "السالوادور",
        "SY": "سوریه",
        "SZ": "سوازیلند",
        "TA": "تریستان دا کونا",
        "TC": "جزایر ترک و کایکوس",
        "TD": "چاد",
        "TF": "مستعمره‌های جنوبی فرانسه",
        "TG": "توگو",
        "TH": "تایلند",
        "TJ": "تاجیکستان",
        "TK": "توکلائو",
        "TL": "تیمور لسته",
        "TM": "ترکمنستان",
        "TN": "تونس",
        "TO": "تونگا",
        "TR": "ترکیه",
        "TT": "ترینیداد و توباگو",
        "TV": "تووالو",
        "TW": "تایوان",
        "TZ": "تانزانیا",
        "UA": "اوکراین",
        "UG": "اوگاندا",
        "UM": "جزایر کوچک دورافتادهٔ ایالات متحده",
        "US": "ایالات متحدهٔ امریکا",
        "UY": "اروگوئه",
        "UZ": "ازبکستان",
        "VA": "واتیکان",
        "VC": "سنت وینسنت و گرنادین",
        "VE": "ونزوئلا",
        "VG": "جزایر ویرجین بریتانیا",
        "VI": "جزایر ویرجین ایالات متحده",
        "VN": "ویتنام",
        "VU": "وانواتو",
        "WF": "والیس و فیوتونا",
        "WS": "ساموا",
        "YE": "یمن",
        "YT": "مایوت",
        "ZA": "افریقای جنوبی",
        "ZM": "زامبیا",
        "ZW": "زیمبابوه",
        "ZZ": "ناحیهٔ نامشخص"
    };
  }-*/;
}
