/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=21.0
//  number=$Revision: 6546 Google $
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $
//  type=root


/**
 * Localized names for the "ga" locale.
 */
public class LocalizedNamesImpl_ga extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AG",
        "ET",
        "AF",
        "ZA",
        "QO",
        "DZ",
        "AR",
        "AM",
        "AL",
        "AQ",
        "SA",
        "AZ",
        "AU",
        "BD",
        "BY",
        "BE",
        "BZ",
        "BA",
        "BO",
        "BW",
        "BR",
        "BG",
        "BI",
        "BT",
        "KH",
        "KZ",
        "KE",
        "CY",
        "KG",
        "KR",
        "KP",
        "CO",
        "HR",
        "CG",
        "CI",
        "DK",
        "AD",
        "EE",
        "EG",
        "CH",
        "ER",
        "FI",
        "FR",
        "GA",
        "GM",
        "DE",
        "GL",
        "GR",
        "GY",
        "GF",
        "GN",
        "GW",
        "GQ",
        "AO",
        "AI",
        "IQ",
        "IR",
        "IN",
        "ID",
        "IT",
        "JO",
        "NO",
        "IS",
        "NL",
        "LV",
        "LR",
        "LY",
        "LB",
        "LT",
        "MK",
        "MY",
        "MW",
        "MR",
        "FM",
        "MD",
        "MN",
        "NA",
        "NG",
        "NE",
        "NC",
        "NZ",
        "AT",
        "PK",
        "DO",
        "PF",
        "PL",
        "PT",
        "CV",
        "GB",
        "RO",
        "EH",
        "ES",
        "TJ",
        "TZ",
        "EU",
        "TH",
        "TW",
        "AN",
        "ZM",
        "SV",
        "JP",
        "SN",
        "RS",
        "CS",
        "GE",
        "GS",
        "CL",
        "CN",
        "ZW",
        "SY",
        "SK",
        "SI",
        "SO",
        "SE",
        "SZ",
        "SD",
        "TN",
        "TR",
        "TM",
        "UA",
        "HU",
        "VA",
        "AE",
        "AW",
        "BH",
        "BB",
        "BJ",
        "BM",
        "BL",
        "BQ",
        "BN",
        "BF",
        "CM",
        "QA",
        "CA",
        "KI",
        "RU",
        "CR",
        "CP",
        "IO",
        "TF",
        "KW",
        "CU",
        "CW",
        "DG",
        "DJ",
        "DM",
        "EA",
        "EC",
        "YE",
        "IE",
        "FJ",
        "GH",
        "GG",
        "JE",
        "GI",
        "GD",
        "GP",
        "GU",
        "GT",
        "HT",
        "HN",
        "HK",
        "JM",
        "IC",
        "IL",
        "LA",
        "LS",
        "LI",
        "LU",
        "MO",
        "MG",
        "MM",
        "ML",
        "MT",
        "MA",
        "MQ",
        "YT",
        "MX",
        "MF",
        "UM",
        "MC",
        "ME",
        "MS",
        "MZ",
        "BS",
        "PS",
        "PH",
        "MV",
        "NR",
        "SC",
        "NP",
        "NI",
        "NU",
        "PG",
        "AX",
        "VG",
        "KM",
        "CK",
        "FK",
        "FO",
        "MP",
        "MH",
        "KY",
        "CC",
        "VI",
        "TT",
        "SB",
        "TC",
        "WF",
        "BV",
        "HM",
        "IM",
        "MU",
        "CX",
        "NF",
        "OM",
        "PW",
        "PA",
        "PY",
        "PE",
        "PN",
        "CD",
        "CF",
        "CZ",
        "PR",
        "RE",
        "RW",
        "KN",
        "PM",
        "VC",
        "WS",
        "AS",
        "SH",
        "LC",
        "SM",
        "ST",
        "TD",
        "SL",
        "SG",
        "LK",
        "SS",
        "US",
        "SR",
        "SJ",
        "SX",
        "TA",
        "TL",
        "TK",
        "TG",
        "TO",
        "TV",
        "UG",
        "UZ",
        "UY",
        "VU",
        "VE",
        "VN",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "An Domhan");
    namesMap.put("002", "An Afraic");
    namesMap.put("009", "An Aigéine");
    namesMap.put("013", "Meiriceá Láir");
    namesMap.put("017", "An Afraic Láir");
    namesMap.put("019", "Na Meiriceánna");
    namesMap.put("053", "An Astráil agus an Nua-Shéalainn");
    namesMap.put("054", "An Mheilinéis");
    namesMap.put("057", "An Réigiún Micrinéiseach");
    namesMap.put("061", "An Pholainéis");
    namesMap.put("142", "An Áise");
    namesMap.put("143", "An Áise Láir");
    namesMap.put("150", "An Eoraip");
    namesMap.put("419", "Meiriceá Laidineach agus an Mhuir Chairib");
    namesMap.put("AD", "Andóra");
    namesMap.put("AE", "Aontas na nÉimíríochtaí Arabacha");
    namesMap.put("AF", "An Afganastáin");
    namesMap.put("AG", "Aintíge agus Barbúda");
    namesMap.put("AL", "An Albáin");
    namesMap.put("AM", "An Airméin");
    namesMap.put("AN", "Antillí na hÍsiltíre");
    namesMap.put("AO", "Angóla");
    namesMap.put("AQ", "An Antartaice");
    namesMap.put("AR", "An Airgintín");
    namesMap.put("AS", "Samó Meiriceánach");
    namesMap.put("AT", "An Ostair");
    namesMap.put("AU", "An Astráil");
    namesMap.put("AW", "Arúba");
    namesMap.put("AX", "Oileáin Alaind");
    namesMap.put("AZ", "An Asarbaiseáin");
    namesMap.put("BA", "An Bhoisnia agus Heirseagóvéin");
    namesMap.put("BB", "Barbadós");
    namesMap.put("BD", "An Bhanglaidéis");
    namesMap.put("BE", "An Bheilg");
    namesMap.put("BF", "Buircíne Fasó");
    namesMap.put("BG", "An Bhulgáir");
    namesMap.put("BH", "Bairéin");
    namesMap.put("BI", "An Bhurúin");
    namesMap.put("BJ", "Beinin");
    namesMap.put("BM", "Beirmiúda");
    namesMap.put("BN", "Brúiné");
    namesMap.put("BO", "An Bholaiv");
    namesMap.put("BR", "An Bhrasaíl");
    namesMap.put("BS", "Na Bahámaí");
    namesMap.put("BT", "An Bhútáin");
    namesMap.put("BV", "Oileán Bouvet");
    namesMap.put("BW", "An Bhotsuáin");
    namesMap.put("BY", "An Bhealarúis");
    namesMap.put("BZ", "An Bheilís");
    namesMap.put("CA", "Ceanada");
    namesMap.put("CC", "Oileáin na gCócónna");
    namesMap.put("CD", "Poblacht Dhaonlathach an Chongó");
    namesMap.put("CF", "Poblacht na hAfraice Láir");
    namesMap.put("CG", "An Congó");
    namesMap.put("CH", "An Eilvéis");
    namesMap.put("CI", "An Cósta Eabhair");
    namesMap.put("CK", "Oileáin Cook");
    namesMap.put("CL", "An tSile");
    namesMap.put("CM", "Camarún");
    namesMap.put("CN", "An tSín");
    namesMap.put("CO", "An Cholóim");
    namesMap.put("CR", "Cósta Ríce");
    namesMap.put("CS", "An tSeirbia agus Montainéagró");
    namesMap.put("CU", "Cúba");
    namesMap.put("CV", "An Rinn Ghlas");
    namesMap.put("CX", "Oileán na Nollag");
    namesMap.put("CY", "An Chipir");
    namesMap.put("CZ", "Poblacht na Seice");
    namesMap.put("DE", "An Ghearmáin");
    namesMap.put("DK", "An Danmhairg");
    namesMap.put("DM", "Doiminice");
    namesMap.put("DO", "An Phoblacht Dhoiminiceach");
    namesMap.put("DZ", "An Ailgéir");
    namesMap.put("EC", "Eacuadór");
    namesMap.put("EE", "An Eastóin");
    namesMap.put("EG", "An Éigipt");
    namesMap.put("EH", "An Sahára Thiar");
    namesMap.put("ER", "An Eiritré");
    namesMap.put("ES", "An Spáinn");
    namesMap.put("ET", "An Aetóip");
    namesMap.put("EU", "An tAontas Eorpach");
    namesMap.put("FI", "An Fhionlainn");
    namesMap.put("FJ", "Fidsí");
    namesMap.put("FK", "Oileáin Fháclainne");
    namesMap.put("FM", "An Mhicrinéis");
    namesMap.put("FO", "Oileáin Fharó");
    namesMap.put("FR", "An Fhrainc");
    namesMap.put("GA", "An Ghabúin");
    namesMap.put("GB", "An Ríocht Aontaithe");
    namesMap.put("GE", "An tSeoirsia");
    namesMap.put("GF", "An Ghuáin Fhrancach");
    namesMap.put("GG", "Geansaí");
    namesMap.put("GH", "Gána");
    namesMap.put("GI", "Giobráltar");
    namesMap.put("GL", "An Ghraonlainn");
    namesMap.put("GM", "An Ghaimbia");
    namesMap.put("GN", "An Ghuine");
    namesMap.put("GP", "Guadalúip");
    namesMap.put("GQ", "An Ghuine Mheánchriosach");
    namesMap.put("GR", "An Ghréig");
    namesMap.put("GS", "An tSeoirsia Theas agus Oileáin Sandwich Theas");
    namesMap.put("GT", "Guatamala");
    namesMap.put("GW", "An Ghuine-Bhissau");
    namesMap.put("GY", "An Ghuáin");
    namesMap.put("HK", "Hong Cong");
    namesMap.put("HM", "Oileán Heard agus Oileáin McDonald");
    namesMap.put("HN", "Hondúras");
    namesMap.put("HR", "An Chróit");
    namesMap.put("HT", "Háití");
    namesMap.put("HU", "An Ungáir");
    namesMap.put("ID", "An Indinéis");
    namesMap.put("IE", "Éire");
    namesMap.put("IL", "Iosrael");
    namesMap.put("IM", "Oileán Mhanann");
    namesMap.put("IN", "An India");
    namesMap.put("IO", "Críocha Briotanacha an Aigéin Indiagh");
    namesMap.put("IQ", "An Iaráic");
    namesMap.put("IR", "An Iaráin");
    namesMap.put("IS", "An Íoslainn");
    namesMap.put("IT", "An Iodáil");
    namesMap.put("JE", "Geirsí");
    namesMap.put("JM", "Iamáice");
    namesMap.put("JO", "An Iordáin");
    namesMap.put("JP", "An tSeapáin");
    namesMap.put("KE", "An Chéinia");
    namesMap.put("KG", "An Chirgeastáin");
    namesMap.put("KH", "An Chambóid");
    namesMap.put("KI", "Ciribeas");
    namesMap.put("KM", "Oileáin Chomóra");
    namesMap.put("KN", "Saint Kitts agus Nevis");
    namesMap.put("KP", "An Chóiré Thuaidh");
    namesMap.put("KR", "An Chóiré Theas");
    namesMap.put("KW", "Cuáit");
    namesMap.put("KY", "Oileáin na gCadhman");
    namesMap.put("KZ", "An Chasacstáin");
    namesMap.put("LB", "An Liobáin");
    namesMap.put("LC", "San Lúisia");
    namesMap.put("LI", "Lichtinstéin");
    namesMap.put("LK", "Srí Lanca");
    namesMap.put("LR", "An Libéir");
    namesMap.put("LS", "Leosóta");
    namesMap.put("LT", "An Liotuáin");
    namesMap.put("LU", "Lucsamburg");
    namesMap.put("LV", "An Laitvia");
    namesMap.put("LY", "An Libia");
    namesMap.put("MA", "Maracó");
    namesMap.put("MC", "Monacó");
    namesMap.put("MD", "An Mholdóiv");
    namesMap.put("ME", "Montainéagró");
    namesMap.put("MH", "Oileáin Marshall");
    namesMap.put("MK", "An Mhacadóin");
    namesMap.put("ML", "Mailí");
    namesMap.put("MM", "Maenmar");
    namesMap.put("MN", "An Mhongóil");
    namesMap.put("MO", "Macáó");
    namesMap.put("MP", "Oileáin Mariana Thuaidh");
    namesMap.put("MQ", "Martainíc");
    namesMap.put("MR", "An Mharatáin");
    namesMap.put("MS", "Montsarat");
    namesMap.put("MT", "Málta");
    namesMap.put("MU", "Oileán Mhuirís");
    namesMap.put("MV", "Na Maildiví");
    namesMap.put("MW", "An Mhaláiv");
    namesMap.put("MX", "Meicsiceo");
    namesMap.put("MY", "An Mhalaeisia");
    namesMap.put("MZ", "Mósaimbíc");
    namesMap.put("NA", "An Namaib");
    namesMap.put("NC", "An Nua-Chaladóin");
    namesMap.put("NE", "An Nígir");
    namesMap.put("NF", "Oileán Norfolk");
    namesMap.put("NG", "An Nigéir");
    namesMap.put("NI", "Nicearagua");
    namesMap.put("NL", "An Ísiltír");
    namesMap.put("NO", "An Iorua");
    namesMap.put("NP", "Neipeal");
    namesMap.put("NR", "Nárú");
    namesMap.put("NU", "Nívé");
    namesMap.put("NZ", "An Nua-Shéalainn");
    namesMap.put("OM", "Óman");
    namesMap.put("PE", "Peiriú");
    namesMap.put("PF", "An Pholainéis Fhrancach");
    namesMap.put("PG", "Nua-Ghuine Phapua");
    namesMap.put("PH", "Na hOileáin Fhilipíneacha");
    namesMap.put("PK", "An Phacastáin");
    namesMap.put("PL", "An Pholainn");
    namesMap.put("PM", "Saint Pierre agus Miquelon");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PR", "Portó Ríce");
    namesMap.put("PS", "Na Críocha Pailistíneacha");
    namesMap.put("PT", "An Phortaingéil");
    namesMap.put("PY", "Paragua");
    namesMap.put("QA", "Catar");
    namesMap.put("QO", "An Aigéine Imeallach");
    namesMap.put("RO", "An Rómáin");
    namesMap.put("RS", "An tSeirbia");
    namesMap.put("RU", "Cónaidhm na Rúise");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "An Araib Shádach");
    namesMap.put("SB", "Oileáin Sholaimh");
    namesMap.put("SC", "Na Séiséil");
    namesMap.put("SD", "An tSúdáin");
    namesMap.put("SE", "An tSualainn");
    namesMap.put("SG", "Singeapór");
    namesMap.put("SH", "San Héilin");
    namesMap.put("SI", "An tSlóvéin");
    namesMap.put("SJ", "Svalbard agus Jan Mayen");
    namesMap.put("SK", "An tSlóvaic");
    namesMap.put("SL", "Siarra Leon");
    namesMap.put("SM", "San Mairíne");
    namesMap.put("SN", "An tSeineagáil");
    namesMap.put("SO", "An tSomáil");
    namesMap.put("SR", "Suranam");
    namesMap.put("ST", "Sao Tome agus Principe");
    namesMap.put("SV", "An tSalvadóir");
    namesMap.put("SY", "An tSiria");
    namesMap.put("SZ", "An tSuasalainn");
    namesMap.put("TC", "Oileáin Turks agus Caicos");
    namesMap.put("TD", "Sead");
    namesMap.put("TF", "Críocha Deisceartacha na Fraince");
    namesMap.put("TG", "Tóga");
    namesMap.put("TH", "An Téalainn");
    namesMap.put("TJ", "An Táidsíceastáin");
    namesMap.put("TK", "Tócalá");
    namesMap.put("TL", "Tíomór Thoir");
    namesMap.put("TM", "An Tuircméanastáin");
    namesMap.put("TN", "An Túinéis");
    namesMap.put("TR", "An Tuirc");
    namesMap.put("TT", "Oileáin na Tríonóide agus Tobága");
    namesMap.put("TV", "Túválú");
    namesMap.put("TW", "An Téaváin");
    namesMap.put("TZ", "An Tansáin");
    namesMap.put("UA", "An Úcráin");
    namesMap.put("UG", "Úganda");
    namesMap.put("UM", "Mion-Oileáin Imeallacha S.A.M.");
    namesMap.put("US", "Stáit Aontaithe Mheiriceá");
    namesMap.put("UY", "Urugua");
    namesMap.put("UZ", "Úisbéiceastáin");
    namesMap.put("VA", "An Vatacáin");
    namesMap.put("VC", "Saint Vincent agus na Grenadines");
    namesMap.put("VE", "Veiniséala");
    namesMap.put("VG", "Oileáin Bhriotanacha na Maighdean");
    namesMap.put("VI", "Oileáin na Maighdean S.A.M.");
    namesMap.put("VN", "Vít Neam");
    namesMap.put("VU", "Vanuatú");
    namesMap.put("WF", "Oileáin Vailís agus Futúna");
    namesMap.put("WS", "Samó");
    namesMap.put("YE", "Éimin");
    namesMap.put("ZA", "An Afraic Theas");
    namesMap.put("ZM", "An tSaimbia");
    namesMap.put("ZW", "An tSiombáib");
    namesMap.put("ZZ", "Réigiún Anaithnid nó Neamhbhailí");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "An Domhan",
        "002": "An Afraic",
        "009": "An Aigéine",
        "013": "Meiriceá Láir",
        "017": "An Afraic Láir",
        "019": "Na Meiriceánna",
        "053": "An Astráil agus an Nua-Shéalainn",
        "054": "An Mheilinéis",
        "057": "An Réigiún Micrinéiseach",
        "061": "An Pholainéis",
        "142": "An Áise",
        "143": "An Áise Láir",
        "150": "An Eoraip",
        "419": "Meiriceá Laidineach agus an Mhuir Chairib",
        "AD": "Andóra",
        "AE": "Aontas na nÉimíríochtaí Arabacha",
        "AF": "An Afganastáin",
        "AG": "Aintíge agus Barbúda",
        "AL": "An Albáin",
        "AM": "An Airméin",
        "AN": "Antillí na hÍsiltíre",
        "AO": "Angóla",
        "AQ": "An Antartaice",
        "AR": "An Airgintín",
        "AS": "Samó Meiriceánach",
        "AT": "An Ostair",
        "AU": "An Astráil",
        "AW": "Arúba",
        "AX": "Oileáin Alaind",
        "AZ": "An Asarbaiseáin",
        "BA": "An Bhoisnia agus Heirseagóvéin",
        "BB": "Barbadós",
        "BD": "An Bhanglaidéis",
        "BE": "An Bheilg",
        "BF": "Buircíne Fasó",
        "BG": "An Bhulgáir",
        "BH": "Bairéin",
        "BI": "An Bhurúin",
        "BJ": "Beinin",
        "BM": "Beirmiúda",
        "BN": "Brúiné",
        "BO": "An Bholaiv",
        "BR": "An Bhrasaíl",
        "BS": "Na Bahámaí",
        "BT": "An Bhútáin",
        "BV": "Oileán Bouvet",
        "BW": "An Bhotsuáin",
        "BY": "An Bhealarúis",
        "BZ": "An Bheilís",
        "CA": "Ceanada",
        "CC": "Oileáin na gCócónna",
        "CD": "Poblacht Dhaonlathach an Chongó",
        "CF": "Poblacht na hAfraice Láir",
        "CG": "An Congó",
        "CH": "An Eilvéis",
        "CI": "An Cósta Eabhair",
        "CK": "Oileáin Cook",
        "CL": "An tSile",
        "CM": "Camarún",
        "CN": "An tSín",
        "CO": "An Cholóim",
        "CR": "Cósta Ríce",
        "CS": "An tSeirbia agus Montainéagró",
        "CU": "Cúba",
        "CV": "An Rinn Ghlas",
        "CX": "Oileán na Nollag",
        "CY": "An Chipir",
        "CZ": "Poblacht na Seice",
        "DE": "An Ghearmáin",
        "DK": "An Danmhairg",
        "DM": "Doiminice",
        "DO": "An Phoblacht Dhoiminiceach",
        "DZ": "An Ailgéir",
        "EC": "Eacuadór",
        "EE": "An Eastóin",
        "EG": "An Éigipt",
        "EH": "An Sahára Thiar",
        "ER": "An Eiritré",
        "ES": "An Spáinn",
        "ET": "An Aetóip",
        "EU": "An tAontas Eorpach",
        "FI": "An Fhionlainn",
        "FJ": "Fidsí",
        "FK": "Oileáin Fháclainne",
        "FM": "An Mhicrinéis",
        "FO": "Oileáin Fharó",
        "FR": "An Fhrainc",
        "GA": "An Ghabúin",
        "GB": "An Ríocht Aontaithe",
        "GE": "An tSeoirsia",
        "GF": "An Ghuáin Fhrancach",
        "GG": "Geansaí",
        "GH": "Gána",
        "GI": "Giobráltar",
        "GL": "An Ghraonlainn",
        "GM": "An Ghaimbia",
        "GN": "An Ghuine",
        "GP": "Guadalúip",
        "GQ": "An Ghuine Mheánchriosach",
        "GR": "An Ghréig",
        "GS": "An tSeoirsia Theas agus Oileáin Sandwich Theas",
        "GT": "Guatamala",
        "GW": "An Ghuine-Bhissau",
        "GY": "An Ghuáin",
        "HK": "Hong Cong",
        "HM": "Oileán Heard agus Oileáin McDonald",
        "HN": "Hondúras",
        "HR": "An Chróit",
        "HT": "Háití",
        "HU": "An Ungáir",
        "ID": "An Indinéis",
        "IE": "Éire",
        "IL": "Iosrael",
        "IM": "Oileán Mhanann",
        "IN": "An India",
        "IO": "Críocha Briotanacha an Aigéin Indiagh",
        "IQ": "An Iaráic",
        "IR": "An Iaráin",
        "IS": "An Íoslainn",
        "IT": "An Iodáil",
        "JE": "Geirsí",
        "JM": "Iamáice",
        "JO": "An Iordáin",
        "JP": "An tSeapáin",
        "KE": "An Chéinia",
        "KG": "An Chirgeastáin",
        "KH": "An Chambóid",
        "KI": "Ciribeas",
        "KM": "Oileáin Chomóra",
        "KN": "Saint Kitts agus Nevis",
        "KP": "An Chóiré Thuaidh",
        "KR": "An Chóiré Theas",
        "KW": "Cuáit",
        "KY": "Oileáin na gCadhman",
        "KZ": "An Chasacstáin",
        "LB": "An Liobáin",
        "LC": "San Lúisia",
        "LI": "Lichtinstéin",
        "LK": "Srí Lanca",
        "LR": "An Libéir",
        "LS": "Leosóta",
        "LT": "An Liotuáin",
        "LU": "Lucsamburg",
        "LV": "An Laitvia",
        "LY": "An Libia",
        "MA": "Maracó",
        "MC": "Monacó",
        "MD": "An Mholdóiv",
        "ME": "Montainéagró",
        "MH": "Oileáin Marshall",
        "MK": "An Mhacadóin",
        "ML": "Mailí",
        "MM": "Maenmar",
        "MN": "An Mhongóil",
        "MO": "Macáó",
        "MP": "Oileáin Mariana Thuaidh",
        "MQ": "Martainíc",
        "MR": "An Mharatáin",
        "MS": "Montsarat",
        "MT": "Málta",
        "MU": "Oileán Mhuirís",
        "MV": "Na Maildiví",
        "MW": "An Mhaláiv",
        "MX": "Meicsiceo",
        "MY": "An Mhalaeisia",
        "MZ": "Mósaimbíc",
        "NA": "An Namaib",
        "NC": "An Nua-Chaladóin",
        "NE": "An Nígir",
        "NF": "Oileán Norfolk",
        "NG": "An Nigéir",
        "NI": "Nicearagua",
        "NL": "An Ísiltír",
        "NO": "An Iorua",
        "NP": "Neipeal",
        "NR": "Nárú",
        "NU": "Nívé",
        "NZ": "An Nua-Shéalainn",
        "OM": "Óman",
        "PE": "Peiriú",
        "PF": "An Pholainéis Fhrancach",
        "PG": "Nua-Ghuine Phapua",
        "PH": "Na hOileáin Fhilipíneacha",
        "PK": "An Phacastáin",
        "PL": "An Pholainn",
        "PM": "Saint Pierre agus Miquelon",
        "PN": "Pitcairn",
        "PR": "Portó Ríce",
        "PS": "Na Críocha Pailistíneacha",
        "PT": "An Phortaingéil",
        "PY": "Paragua",
        "QA": "Catar",
        "QO": "An Aigéine Imeallach",
        "RO": "An Rómáin",
        "RS": "An tSeirbia",
        "RU": "Cónaidhm na Rúise",
        "RW": "Ruanda",
        "SA": "An Araib Shádach",
        "SB": "Oileáin Sholaimh",
        "SC": "Na Séiséil",
        "SD": "An tSúdáin",
        "SE": "An tSualainn",
        "SG": "Singeapór",
        "SH": "San Héilin",
        "SI": "An tSlóvéin",
        "SJ": "Svalbard agus Jan Mayen",
        "SK": "An tSlóvaic",
        "SL": "Siarra Leon",
        "SM": "San Mairíne",
        "SN": "An tSeineagáil",
        "SO": "An tSomáil",
        "SR": "Suranam",
        "ST": "Sao Tome agus Principe",
        "SV": "An tSalvadóir",
        "SY": "An tSiria",
        "SZ": "An tSuasalainn",
        "TC": "Oileáin Turks agus Caicos",
        "TD": "Sead",
        "TF": "Críocha Deisceartacha na Fraince",
        "TG": "Tóga",
        "TH": "An Téalainn",
        "TJ": "An Táidsíceastáin",
        "TK": "Tócalá",
        "TL": "Tíomór Thoir",
        "TM": "An Tuircméanastáin",
        "TN": "An Túinéis",
        "TR": "An Tuirc",
        "TT": "Oileáin na Tríonóide agus Tobága",
        "TV": "Túválú",
        "TW": "An Téaváin",
        "TZ": "An Tansáin",
        "UA": "An Úcráin",
        "UG": "Úganda",
        "UM": "Mion-Oileáin Imeallacha S.A.M.",
        "US": "Stáit Aontaithe Mheiriceá",
        "UY": "Urugua",
        "UZ": "Úisbéiceastáin",
        "VA": "An Vatacáin",
        "VC": "Saint Vincent agus na Grenadines",
        "VE": "Veiniséala",
        "VG": "Oileáin Bhriotanacha na Maighdean",
        "VI": "Oileáin na Maighdean S.A.M.",
        "VN": "Vít Neam",
        "VU": "Vanuatú",
        "WF": "Oileáin Vailís agus Futúna",
        "WS": "Samó",
        "YE": "Éimin",
        "ZA": "An Afraic Theas",
        "ZM": "An tSaimbia",
        "ZW": "An tSiombáib",
        "ZZ": "Réigiún Anaithnid nó Neamhbhailí"
    };
  }-*/;
}
