/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.java.storage;

import com.gradle.obfuscation.KeepNameAndProperties;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonCreator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@KeepNameAndProperties
public final class StorageSize
implements Comparable<StorageSize> {
    public static final StorageSize ZERO = new StorageSize(0L);
    private static final Pattern a = Pattern.compile("^([+-]?\\d+) ?((?:[KMGTPE]i)?B?)$");
    private static final MathContext b = new MathContext(String.valueOf(1024L).length() + 1, RoundingMode.FLOOR);
    private final long c;

    @JsonCreator
    public static StorageSize parse(String string) {
        Matcher matcher = a.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Does not match the expected pattern: " + string);
        }
        long l2 = Long.parseLong(matcher.group(1));
        String string2 = matcher.group(2);
        if (string2 == null) {
            string2 = "B";
        } else if (!string2.endsWith("B")) {
            string2 = string2 + "B";
        }
        a a2 = com.gradle.enterprise.java.storage.StorageSize$a.valueOf(string2);
        return StorageSize.b(l2, a2);
    }

    @JsonCreator
    public static StorageSize ofBytes(long l2) {
        return StorageSize.b(l2, com.gradle.enterprise.java.storage.StorageSize$a.B);
    }

    public static StorageSize a(long l2) {
        return StorageSize.b(l2, com.gradle.enterprise.java.storage.StorageSize$a.MiB);
    }

    private static StorageSize b(long l2, a a2) {
        if (l2 == 0L) {
            return ZERO;
        }
        return new StorageSize(StorageSize.c(l2, a2));
    }

    private static long c(long l2, a a2) {
        return l2 << a2.ordinal() * 10;
    }

    private StorageSize(long l2) {
        this.c = l2;
    }

    @JsonValue
    public long getBytes() {
        return this.c;
    }

    public int getBytesAsInt() {
        if (this.c > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (this.c < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)this.c;
    }

    public boolean isPositive() {
        return this.c > 0L;
    }

    public boolean isZero() {
        return this.c == 0L;
    }

    public boolean isNegative() {
        return this.c < 0L;
    }

    public int a(StorageSize storageSize) {
        return Long.compare(this.c, storageSize.c);
    }

    public String toString() {
        return this.a();
    }

    public String a() {
        return StorageSize.b(this.c);
    }

    public static String b(long l2) {
        if (l2 < 0L) {
            return "-" + StorageSize.b(-l2);
        }
        int n2 = (63 - Long.numberOfLeadingZeros(l2)) / 10;
        a a2 = com.gradle.enterprise.java.storage.StorageSize$a.values()[n2];
        return StorageSize.a(l2, a2);
    }

    public static String a(long l2, a a2) {
        return StorageSize.a(l2, a2, true);
    }

    public static String a(long l2, a a2, boolean bl2) {
        if (l2 < 0L) {
            return "-" + StorageSize.b(-l2);
        }
        int n2 = a2.ordinal();
        BigDecimal bigDecimal = BigDecimal.valueOf(1L << n2 * 10);
        BigDecimal bigDecimal2 = BigDecimal.valueOf(l2).divide(bigDecimal, b).setScale(1, RoundingMode.FLOOR).stripTrailingZeros();
        String string = bigDecimal2.toPlainString();
        if (bl2) {
            return string + " " + (Object)((Object)a2);
        }
        return string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StorageSize storageSize = (StorageSize)object;
        return this.c == storageSize.c;
    }

    public int hashCode() {
        return Objects.hash(this.c);
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.a((StorageSize)object);
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a B = new a();
        public static final /* enum */ a KiB = new a();
        public static final /* enum */ a MiB = new a();
        public static final /* enum */ a GiB = new a();
        public static final /* enum */ a TiB = new a();
        public static final /* enum */ a PiB = new a();
        public static final /* enum */ a EiB = new a();
        private static final /* synthetic */ a[] a;

        public static a[] values() {
            return (a[])a.clone();
        }

        public static a valueOf(String string) {
            return Enum.valueOf(a.class, string);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{B, KiB, MiB, GiB, TiB, PiB, EiB};
        }

        static {
            a = com.gradle.enterprise.java.storage.StorageSize$a.a();
        }
    }
}

