/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jsr310.ser;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.type.WritableTypeId;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jsr310.ser.JSR310FormattedSerializerBase;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class LocalDateSerializer
extends JSR310FormattedSerializerBase<LocalDate> {
    public static final LocalDateSerializer INSTANCE = new LocalDateSerializer();

    protected LocalDateSerializer() {
        super(LocalDate.class);
    }

    protected LocalDateSerializer(LocalDateSerializer localDateSerializer, Boolean bl2, DateTimeFormatter dateTimeFormatter, JsonFormat.Shape shape) {
        super(localDateSerializer, bl2, dateTimeFormatter, shape);
    }

    protected LocalDateSerializer withFormat(Boolean bl2, DateTimeFormatter dateTimeFormatter, JsonFormat.Shape shape) {
        return new LocalDateSerializer(this, bl2, dateTimeFormatter, shape);
    }

    @Override
    public void serialize(LocalDate localDate, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.useTimestamp(serializerProvider)) {
            if (this._shape == JsonFormat.Shape.NUMBER_INT) {
                jsonGenerator.writeNumber(localDate.toEpochDay());
            } else {
                jsonGenerator.writeStartArray();
                this._serializeAsArrayContents(localDate, jsonGenerator, serializerProvider);
                jsonGenerator.writeEndArray();
            }
        } else {
            jsonGenerator.writeString(this._formatter == null ? localDate.toString() : localDate.format(this._formatter));
        }
    }

    @Override
    public void serializeWithType(LocalDate localDate, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        WritableTypeId writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(localDate, this.serializationShape(serializerProvider)));
        switch (writableTypeId.valueShape) {
            case START_ARRAY: {
                this._serializeAsArrayContents(localDate, jsonGenerator, serializerProvider);
                break;
            }
            case VALUE_NUMBER_INT: {
                jsonGenerator.writeNumber(localDate.toEpochDay());
                break;
            }
            default: {
                jsonGenerator.writeString(this._formatter == null ? localDate.toString() : localDate.format(this._formatter));
            }
        }
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    protected void _serializeAsArrayContents(LocalDate localDate, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeNumber(localDate.getYear());
        jsonGenerator.writeNumber(localDate.getMonthValue());
        jsonGenerator.writeNumber(localDate.getDayOfMonth());
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        boolean bl2;
        SerializerProvider serializerProvider = jsonFormatVisitorWrapper.getProvider();
        boolean bl3 = bl2 = serializerProvider != null && this.useTimestamp(serializerProvider);
        if (bl2) {
            this._acceptTimestampVisitor(jsonFormatVisitorWrapper, javaType);
        } else {
            JsonStringFormatVisitor jsonStringFormatVisitor = jsonFormatVisitorWrapper.expectStringFormat(javaType);
            if (jsonStringFormatVisitor != null) {
                jsonStringFormatVisitor.format(JsonValueFormat.DATE);
            }
        }
    }

    @Override
    protected JsonToken serializationShape(SerializerProvider serializerProvider) {
        if (this.useTimestamp(serializerProvider)) {
            if (this._shape == JsonFormat.Shape.NUMBER_INT) {
                return JsonToken.VALUE_NUMBER_INT;
            }
            return JsonToken.START_ARRAY;
        }
        return JsonToken.VALUE_STRING;
    }
}

