/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.google.common.collect;

import com.gradle.scan.plugin.internal.dep.com.google.common.base.Preconditions;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.ImmutableCollection;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.ImmutableList;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.ImmutableMap;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.ImmutableMapEntry;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.ImmutableMapEntrySet;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.ImmutableMapKeySet;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.ImmutableMapValues;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.ImmutableSet;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.Maps;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.RegularImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;

final class JdkBackedImmutableMap<K, V>
extends ImmutableMap<K, V> {
    private final transient Map<K, V> delegateMap;
    private final transient ImmutableList<Map.Entry<K, V>> entries;

    static <K, V> ImmutableMap<K, V> create(int n2, Map.Entry<K, V>[] entryArray, boolean bl2) {
        Map.Entry<K, V> entry;
        HashMap<K, V> hashMap = Maps.newHashMapWithExpectedSize(n2);
        HashMap<K, Object> hashMap2 = null;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            V v2;
            entryArray[i2] = RegularImmutableMap.makeImmutable(Objects.requireNonNull(entryArray[i2]));
            K k2 = entryArray[i2].getKey();
            entry = hashMap.put(k2, v2 = entryArray[i2].getValue());
            if (entry == null) continue;
            if (bl2) {
                throw JdkBackedImmutableMap.conflictException("key", entryArray[i2], entryArray[i2].getKey() + "=" + entry);
            }
            if (hashMap2 == null) {
                hashMap2 = new HashMap<K, Object>();
            }
            hashMap2.put(k2, v2);
            ++n3;
        }
        if (hashMap2 != null) {
            Map.Entry[] entryArray2 = new Map.Entry[n2 - n3];
            int n4 = 0;
            for (int i3 = 0; i3 < n2; ++i3) {
                entry = Objects.requireNonNull(entryArray[i3]);
                K k3 = entry.getKey();
                if (hashMap2.containsKey(k3)) {
                    Object v3 = hashMap2.get(k3);
                    if (v3 == null) continue;
                    entry = new ImmutableMapEntry(k3, v3);
                    hashMap2.put(k3, null);
                }
                entryArray2[n4++] = entry;
            }
            entryArray = entryArray2;
        }
        return new JdkBackedImmutableMap(hashMap, ImmutableList.asImmutableList(entryArray, n2));
    }

    JdkBackedImmutableMap(Map<K, V> map, ImmutableList<Map.Entry<K, V>> immutableList) {
        this.delegateMap = map;
        this.entries = immutableList;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    @CheckForNull
    public V get(@CheckForNull Object object) {
        return this.delegateMap.get(object);
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new ImmutableMapEntrySet.RegularEntrySet<K, V>(this, this.entries);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        Preconditions.checkNotNull(biConsumer);
        this.entries.forEach((Consumer<Map.Entry<K, V>>)((Consumer<Map.Entry>)entry -> biConsumer.accept((Object)entry.getKey(), (Object)entry.getValue())));
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return new ImmutableMapKeySet(this);
    }

    @Override
    ImmutableCollection<V> createValues() {
        return new ImmutableMapValues(this);
    }
}

