/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.dev.failsafe.internal.util;

import com.gradle.scan.plugin.internal.dep.dev.failsafe.spi.Scheduler;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class DelegatingScheduler
implements Scheduler {
    public static final DelegatingScheduler INSTANCE = new DelegatingScheduler();
    private static volatile ForkJoinPool FORK_JOIN_POOL;
    private static volatile ScheduledThreadPoolExecutor DELAYER;
    private final ExecutorService executorService = null;

    private DelegatingScheduler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ScheduledExecutorService delayer() {
        if (DELAYER != null) return DELAYER;
        Class<DelegatingScheduler> clazz = DelegatingScheduler.class;
        synchronized (DelegatingScheduler.class) {
            if (DELAYER != null) return DELAYER;
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, new DelayerThreadFactory());
            scheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
            DELAYER = scheduledThreadPoolExecutor;
            // ** MonitorExit[var0] (shouldn't be in output)
            return DELAYER;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExecutorService executorService() {
        if (this.executorService != null) {
            return this.executorService;
        }
        if (FORK_JOIN_POOL != null) return FORK_JOIN_POOL;
        Class<DelegatingScheduler> clazz = DelegatingScheduler.class;
        synchronized (DelegatingScheduler.class) {
            if (FORK_JOIN_POOL != null) return FORK_JOIN_POOL;
            FORK_JOIN_POOL = ForkJoinPool.getCommonPoolParallelism() > 1 ? ForkJoinPool.commonPool() : new ForkJoinPool(2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return FORK_JOIN_POOL;
        }
    }

    @Override
    public ScheduledFuture<?> schedule(Callable<?> callable, long l2, TimeUnit timeUnit) {
        ScheduledCompletableFuture scheduledCompletableFuture = new ScheduledCompletableFuture(l2, timeUnit);
        ExecutorService executorService = this.executorService();
        boolean bl2 = executorService instanceof ForkJoinPool;
        Callable<Object> callable2 = () -> {
            ScheduledCompletableFuture scheduledCompletableFuture2;
            try {
                if (bl2) {
                    scheduledCompletableFuture2 = scheduledCompletableFuture;
                    synchronized (scheduledCompletableFuture2) {
                        scheduledCompletableFuture.forkJoinPoolThread = Thread.currentThread();
                    }
                }
                scheduledCompletableFuture.complete(callable.call());
            }
            catch (Throwable throwable) {
                scheduledCompletableFuture.completeExceptionally(throwable);
            }
            finally {
                if (bl2) {
                    scheduledCompletableFuture2 = scheduledCompletableFuture;
                    synchronized (scheduledCompletableFuture2) {
                        scheduledCompletableFuture.forkJoinPoolThread = null;
                    }
                }
            }
            return null;
        };
        scheduledCompletableFuture.delegate = l2 == 0L ? executorService.submit(callable2) : DelegatingScheduler.delayer().schedule(() -> {
            ScheduledCompletableFuture scheduledCompletableFuture2 = scheduledCompletableFuture;
            synchronized (scheduledCompletableFuture2) {
                if (!scheduledCompletableFuture.isCancelled()) {
                    scheduledCompletableFuture.delegate = executorService.submit(callable2);
                }
            }
        }, l2, timeUnit);
        return scheduledCompletableFuture;
    }

    static final class ScheduledCompletableFuture<V>
    extends CompletableFuture<V>
    implements ScheduledFuture<V> {
        volatile Future<V> delegate;
        Thread forkJoinPoolThread;
        private final long time;

        ScheduledCompletableFuture(long l2, TimeUnit timeUnit) {
            this.time = System.nanoTime() + timeUnit.toNanos(l2);
        }

        @Override
        public long getDelay(TimeUnit timeUnit) {
            return timeUnit.convert(this.time - System.nanoTime(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed delayed) {
            if (delayed == this) {
                return 0;
            }
            if (delayed instanceof ScheduledCompletableFuture) {
                return Long.compare(this.time, ((ScheduledCompletableFuture)delayed).time);
            }
            return Long.compare(this.getDelay(TimeUnit.NANOSECONDS), delayed.getDelay(TimeUnit.NANOSECONDS));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean bl2) {
            boolean bl3 = super.cancel(bl2);
            ScheduledCompletableFuture scheduledCompletableFuture = this;
            synchronized (scheduledCompletableFuture) {
                if (this.delegate != null) {
                    bl3 = this.delegate.cancel(bl2);
                }
                if (this.forkJoinPoolThread != null && bl2) {
                    this.forkJoinPoolThread.interrupt();
                }
            }
            return bl3;
        }
    }

    private static final class DelayerThreadFactory
    implements ThreadFactory {
        private DelayerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            thread.setName("FailsafeDelayScheduler");
            return thread;
        }
    }
}

