/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.buffer;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.AbstractByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.AbstractReferenceCountedByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.AdaptiveByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBufUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.UnpooledDuplicatedByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.UnpooledSlicedByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ByteProcessor;
import com.gradle.scan.plugin.internal.dep.io.netty.util.IllegalReferenceCountException;
import com.gradle.scan.plugin.internal.dep.io.netty.util.NettyRuntime;
import com.gradle.scan.plugin.internal.dep.io.netty.util.Recycler;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ReferenceCounted;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.FastThreadLocal;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.FastThreadLocalThread;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectPool;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ThreadExecutorMap;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.Arrays;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.StampedLock;

final class AdaptivePoolingAllocator
implements AdaptiveByteBufAllocator.AdaptiveAllocatorApi {
    private static final int MAX_STRIPES = NettyRuntime.availableProcessors() * 2;
    private static final int CENTRAL_QUEUE_CAPACITY = SystemPropertyUtil.getInt("com.gradle.scan.plugin.internal.dep.io.netty.allocator.centralQueueCapacity", NettyRuntime.availableProcessors());
    private static final Object NO_MAGAZINE = Boolean.TRUE;
    private final ChunkAllocator chunkAllocator;
    private final Queue<Chunk> centralQueue;
    private final StampedLock magazineExpandLock;
    private volatile Magazine[] magazines;
    private final FastThreadLocal<Object> threadLocalMagazine;
    private final Set<Magazine> liveCachedMagazines;

    AdaptivePoolingAllocator(ChunkAllocator chunkAllocator, MagazineCaching magazineCaching) {
        ObjectUtil.checkNotNull(chunkAllocator, "chunkAllocator");
        ObjectUtil.checkNotNull(magazineCaching, "magazineCaching");
        this.chunkAllocator = chunkAllocator;
        this.centralQueue = ObjectUtil.checkNotNull(AdaptivePoolingAllocator.createSharedChunkQueue(), "centralQueue");
        this.magazineExpandLock = new StampedLock();
        if (magazineCaching != MagazineCaching.None) {
            assert (magazineCaching == MagazineCaching.EventLoopThreads || magazineCaching == MagazineCaching.FastThreadLocalThreads);
            final boolean bl2 = magazineCaching == MagazineCaching.FastThreadLocalThreads;
            final CopyOnWriteArraySet<Magazine> copyOnWriteArraySet = new CopyOnWriteArraySet<Magazine>();
            this.threadLocalMagazine = new FastThreadLocal<Object>(){

                @Override
                protected Object initialValue() {
                    if (bl2 || ThreadExecutorMap.currentExecutor() != null) {
                        Magazine magazine = new Magazine(AdaptivePoolingAllocator.this, false);
                        copyOnWriteArraySet.add(magazine);
                        return magazine;
                    }
                    return NO_MAGAZINE;
                }

                @Override
                protected void onRemoval(Object object) throws Exception {
                    if (object != NO_MAGAZINE) {
                        copyOnWriteArraySet.remove(object);
                    }
                }
            };
            this.liveCachedMagazines = copyOnWriteArraySet;
        } else {
            this.threadLocalMagazine = null;
            this.liveCachedMagazines = null;
        }
        Magazine[] magazineArray = new Magazine[4];
        for (int i2 = 0; i2 < magazineArray.length; ++i2) {
            magazineArray[i2] = new Magazine(this);
        }
        this.magazines = magazineArray;
    }

    private static Queue<Chunk> createSharedChunkQueue() {
        return PlatformDependent.newFixedMpmcQueue(CENTRAL_QUEUE_CAPACITY);
    }

    @Override
    public ByteBuf allocate(int n2, int n3) {
        if (n2 <= 0xA00000) {
            boolean bl2;
            AdaptiveByteBuf adaptiveByteBuf;
            Thread thread = Thread.currentThread();
            AdaptiveByteBuf adaptiveByteBuf2 = this.allocate(n2, n3, thread, adaptiveByteBuf = AdaptiveByteBuf.newInstance(bl2 = FastThreadLocalThread.willCleanupFastThreadLocals(thread)));
            if (adaptiveByteBuf2 != null) {
                return adaptiveByteBuf2;
            }
            adaptiveByteBuf.release();
        }
        return this.chunkAllocator.allocate(n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdaptiveByteBuf allocate(int n2, int n3, Thread thread, AdaptiveByteBuf adaptiveByteBuf) {
        Magazine[] magazineArray;
        Object object;
        int n4 = AllocationStatistics.sizeBucket(n2);
        FastThreadLocal<Object> fastThreadLocal = this.threadLocalMagazine;
        if (fastThreadLocal != null && thread instanceof FastThreadLocalThread && (object = fastThreadLocal.get()) != NO_MAGAZINE) {
            return ((Magazine)object).allocate(n2, n4, n3, adaptiveByteBuf);
        }
        long l2 = thread.getId();
        int n5 = 0;
        do {
            magazineArray = this.magazines;
            int n6 = magazineArray.length - 1;
            int n7 = (int)(l2 & (long)n6);
            int n8 = Integer.numberOfTrailingZeros(~n6);
            for (int i2 = 0; i2 < n8; ++i2) {
                Magazine magazine = magazineArray[n7 + i2 & n6];
                long l3 = magazine.tryWriteLock();
                if (l3 == 0L) continue;
                try {
                    AdaptiveByteBuf adaptiveByteBuf2 = magazine.allocate(n2, n4, n3, adaptiveByteBuf);
                    return adaptiveByteBuf2;
                }
                finally {
                    magazine.unlockWrite(l3);
                }
            }
        } while (++n5 <= 3 && this.tryExpandMagazines(magazineArray.length));
        return null;
    }

    void allocate(int n2, int n3, AdaptiveByteBuf adaptiveByteBuf) {
        Magazine magazine = adaptiveByteBuf.chunk.magazine;
        AdaptiveByteBuf adaptiveByteBuf2 = this.allocate(n2, n3, Thread.currentThread(), adaptiveByteBuf);
        if (adaptiveByteBuf2 == null) {
            AbstractByteBuf abstractByteBuf = (AbstractByteBuf)this.chunkAllocator.allocate(n2, n3);
            Chunk chunk = new Chunk(abstractByteBuf, magazine, false);
            chunk.readInitInto(adaptiveByteBuf, n2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryExpandMagazines(int n2) {
        if (n2 >= MAX_STRIPES) {
            return true;
        }
        long l2 = this.magazineExpandLock.tryWriteLock();
        if (l2 != 0L) {
            try {
                Magazine[] magazineArray = this.magazines;
                if (magazineArray.length >= MAX_STRIPES || magazineArray.length > n2) {
                    boolean bl2 = true;
                    return bl2;
                }
                Magazine[] magazineArray2 = Arrays.copyOf(magazineArray, magazineArray.length * 2);
                int n3 = magazineArray2.length;
                for (int i2 = magazineArray.length; i2 < n3; ++i2) {
                    magazineArray2[i2] = new Magazine(this);
                }
                this.magazines = magazineArray2;
            }
            finally {
                this.magazineExpandLock.unlockWrite(l2);
            }
        }
        return true;
    }

    private boolean offerToQueue(Chunk chunk) {
        return this.centralQueue.offer(chunk);
    }

    public static interface ChunkAllocator {
        public ByteBuf allocate(int var1, int var2);
    }

    private static final class PooledNonRetainedSlicedByteBuf
    extends UnpooledSlicedByteBuf {
        private final ReferenceCounted referenceCountDelegate;

        PooledNonRetainedSlicedByteBuf(ReferenceCounted referenceCounted, AbstractByteBuf abstractByteBuf, int n2, int n3) {
            super(abstractByteBuf, n2, n3);
            this.referenceCountDelegate = referenceCounted;
        }

        @Override
        boolean isAccessible0() {
            return this.referenceCountDelegate.refCnt() != 0;
        }

        @Override
        int refCnt0() {
            return this.referenceCountDelegate.refCnt();
        }

        @Override
        ByteBuf retain0() {
            this.referenceCountDelegate.retain();
            return this;
        }

        @Override
        ByteBuf touch0() {
            this.referenceCountDelegate.touch();
            return this;
        }

        @Override
        ByteBuf touch0(Object object) {
            this.referenceCountDelegate.touch(object);
            return this;
        }

        @Override
        boolean release0() {
            return this.referenceCountDelegate.release();
        }

        @Override
        public ByteBuf duplicate() {
            this.ensureAccessible();
            return new PooledNonRetainedSlicedByteBuf(this.referenceCountDelegate, this.unwrap(), this.idx(0), this.capacity()).setIndex(this.readerIndex(), this.writerIndex());
        }

        @Override
        public ByteBuf retainedDuplicate() {
            return this.duplicate().retain();
        }

        @Override
        public ByteBuf slice(int n2, int n3) {
            this.checkIndex(n2, n3);
            return new PooledNonRetainedSlicedByteBuf(this.referenceCountDelegate, this.unwrap(), this.idx(n2), n3);
        }

        @Override
        public ByteBuf retainedSlice() {
            return this.retainedSlice(0, this.capacity());
        }

        @Override
        public ByteBuf retainedSlice(int n2, int n3) {
            return this.slice(n2, n3).retain();
        }
    }

    private static final class PooledNonRetainedDuplicateByteBuf
    extends UnpooledDuplicatedByteBuf {
        private final ReferenceCounted referenceCountDelegate;

        PooledNonRetainedDuplicateByteBuf(ReferenceCounted referenceCounted, AbstractByteBuf abstractByteBuf) {
            super(abstractByteBuf);
            this.referenceCountDelegate = referenceCounted;
        }

        @Override
        boolean isAccessible0() {
            return this.referenceCountDelegate.refCnt() != 0;
        }

        @Override
        int refCnt0() {
            return this.referenceCountDelegate.refCnt();
        }

        @Override
        ByteBuf retain0() {
            this.referenceCountDelegate.retain();
            return this;
        }

        @Override
        ByteBuf touch0() {
            this.referenceCountDelegate.touch();
            return this;
        }

        @Override
        ByteBuf touch0(Object object) {
            this.referenceCountDelegate.touch(object);
            return this;
        }

        @Override
        boolean release0() {
            return this.referenceCountDelegate.release();
        }

        @Override
        public ByteBuf duplicate() {
            this.ensureAccessible();
            return new PooledNonRetainedDuplicateByteBuf(this.referenceCountDelegate, this.unwrap());
        }

        @Override
        public ByteBuf retainedDuplicate() {
            return this.duplicate().retain();
        }

        @Override
        public ByteBuf slice(int n2, int n3) {
            this.checkIndex(n2, n3);
            return new PooledNonRetainedSlicedByteBuf(this.referenceCountDelegate, this.unwrap(), n2, n3);
        }

        @Override
        public ByteBuf retainedSlice() {
            return this.retainedSlice(this.readerIndex(), this.capacity());
        }

        @Override
        public ByteBuf retainedSlice(int n2, int n3) {
            return this.slice(n2, n3).retain();
        }
    }

    static final class AdaptiveByteBuf
    extends AbstractReferenceCountedByteBuf {
        static final ObjectPool<AdaptiveByteBuf> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<AdaptiveByteBuf>(){

            @Override
            public AdaptiveByteBuf newObject(ObjectPool.Handle<AdaptiveByteBuf> handle) {
                return new AdaptiveByteBuf(handle);
            }
        });
        private final ObjectPool.Handle<AdaptiveByteBuf> handle;
        int adjustment;
        private AbstractByteBuf rootParent;
        private Chunk chunk;
        private int length;
        private ByteBuffer tmpNioBuf;
        private boolean hasArray;
        private boolean hasMemoryAddress;

        static AdaptiveByteBuf newInstance(boolean bl2) {
            if (bl2) {
                AdaptiveByteBuf adaptiveByteBuf = RECYCLER.get();
                adaptiveByteBuf.resetRefCnt();
                adaptiveByteBuf.discardMarks();
                return adaptiveByteBuf;
            }
            return new AdaptiveByteBuf(null);
        }

        AdaptiveByteBuf(ObjectPool.Handle<AdaptiveByteBuf> handle) {
            super(0);
            this.handle = handle;
        }

        void init(AbstractByteBuf abstractByteBuf, Chunk chunk, int n2, int n3, int n4, int n5, int n6) {
            this.adjustment = n4;
            this.chunk = chunk;
            this.length = n5;
            this.maxCapacity(n6);
            this.setIndex0(n2, n3);
            this.hasArray = abstractByteBuf.hasArray();
            this.hasMemoryAddress = abstractByteBuf.hasMemoryAddress();
            this.rootParent = abstractByteBuf;
            this.tmpNioBuf = abstractByteBuf.internalNioBuffer(n4, n5).slice();
        }

        private AbstractByteBuf rootParent() {
            AbstractByteBuf abstractByteBuf = this.rootParent;
            if (abstractByteBuf != null) {
                return abstractByteBuf;
            }
            throw new IllegalReferenceCountException();
        }

        @Override
        public int capacity() {
            return this.length;
        }

        @Override
        public ByteBuf capacity(int n2) {
            if (n2 == this.capacity()) {
                this.ensureAccessible();
                return this;
            }
            this.checkNewCapacity(n2);
            if (n2 < this.capacity()) {
                this.length = n2;
                this.setIndex0(Math.min(this.readerIndex(), n2), Math.min(this.writerIndex(), n2));
                return this;
            }
            ByteBuffer byteBuffer = this.tmpNioBuf;
            byteBuffer.clear();
            this.tmpNioBuf = null;
            Chunk chunk = this.chunk;
            Magazine magazine = chunk.magazine;
            AdaptivePoolingAllocator adaptivePoolingAllocator = magazine.parent;
            int n3 = this.readerIndex;
            int n4 = this.writerIndex;
            adaptivePoolingAllocator.allocate(n2, this.maxCapacity(), this);
            this.tmpNioBuf.put(byteBuffer);
            this.tmpNioBuf.clear();
            chunk.release();
            this.readerIndex = n3;
            this.writerIndex = n4;
            return this;
        }

        @Override
        public ByteBufAllocator alloc() {
            return this.rootParent().alloc();
        }

        @Override
        public ByteOrder order() {
            return this.rootParent().order();
        }

        @Override
        public ByteBuf unwrap() {
            return null;
        }

        @Override
        public boolean isDirect() {
            return this.rootParent().isDirect();
        }

        @Override
        public int arrayOffset() {
            return this.idx(this.rootParent().arrayOffset());
        }

        @Override
        public boolean hasMemoryAddress() {
            return this.hasMemoryAddress;
        }

        @Override
        public long memoryAddress() {
            this.ensureAccessible();
            return this.rootParent().memoryAddress() + (long)this.adjustment;
        }

        @Override
        public ByteBuffer nioBuffer(int n2, int n3) {
            this.checkIndex(n2, n3);
            return this.rootParent().nioBuffer(this.idx(n2), n3);
        }

        @Override
        public ByteBuffer internalNioBuffer(int n2, int n3) {
            this.checkIndex(n2, n3);
            return (ByteBuffer)this.internalNioBuffer().position(n2).limit(n2 + n3);
        }

        private ByteBuffer internalNioBuffer() {
            return (ByteBuffer)this.tmpNioBuf.clear();
        }

        @Override
        public ByteBuffer[] nioBuffers(int n2, int n3) {
            this.checkIndex(n2, n3);
            return this.rootParent().nioBuffers(this.idx(n2), n3);
        }

        @Override
        public boolean hasArray() {
            return this.hasArray;
        }

        @Override
        public byte[] array() {
            this.ensureAccessible();
            return this.rootParent().array();
        }

        @Override
        public ByteBuf slice(int n2, int n3) {
            this.checkIndex(n2, n3);
            return new PooledNonRetainedSlicedByteBuf(this, this.rootParent, this.idx(n2), n3);
        }

        @Override
        public ByteBuf retainedSlice(int n2, int n3) {
            return this.slice(n2, n3).retain();
        }

        @Override
        public ByteBuf duplicate() {
            this.ensureAccessible();
            return new PooledNonRetainedDuplicateByteBuf(this, this).setIndex(this.readerIndex(), this.writerIndex());
        }

        @Override
        public ByteBuf retainedDuplicate() {
            return this.duplicate().retain();
        }

        @Override
        public int nioBufferCount() {
            return this.rootParent().nioBufferCount();
        }

        @Override
        public byte getByte(int n2) {
            this.checkIndex(n2, 1);
            return this.rootParent().getByte(this.idx(n2));
        }

        @Override
        protected byte _getByte(int n2) {
            return this.rootParent()._getByte(this.idx(n2));
        }

        @Override
        public short getShort(int n2) {
            this.checkIndex(n2, 2);
            return this.rootParent().getShort(this.idx(n2));
        }

        @Override
        protected short _getShort(int n2) {
            return this.rootParent()._getShort(this.idx(n2));
        }

        @Override
        public short getShortLE(int n2) {
            this.checkIndex(n2, 2);
            return this.rootParent().getShortLE(this.idx(n2));
        }

        @Override
        protected short _getShortLE(int n2) {
            return this.rootParent()._getShortLE(this.idx(n2));
        }

        @Override
        public int getUnsignedMedium(int n2) {
            this.checkIndex(n2, 3);
            return this.rootParent().getUnsignedMedium(this.idx(n2));
        }

        @Override
        protected int _getUnsignedMedium(int n2) {
            return this.rootParent()._getUnsignedMedium(this.idx(n2));
        }

        @Override
        public int getUnsignedMediumLE(int n2) {
            this.checkIndex(n2, 3);
            return this.rootParent().getUnsignedMediumLE(this.idx(n2));
        }

        @Override
        protected int _getUnsignedMediumLE(int n2) {
            return this.rootParent()._getUnsignedMediumLE(this.idx(n2));
        }

        @Override
        public int getInt(int n2) {
            this.checkIndex(n2, 4);
            return this.rootParent().getInt(this.idx(n2));
        }

        @Override
        protected int _getInt(int n2) {
            return this.rootParent()._getInt(this.idx(n2));
        }

        @Override
        public int getIntLE(int n2) {
            this.checkIndex(n2, 4);
            return this.rootParent().getIntLE(this.idx(n2));
        }

        @Override
        protected int _getIntLE(int n2) {
            return this.rootParent()._getIntLE(this.idx(n2));
        }

        @Override
        public long getLong(int n2) {
            this.checkIndex(n2, 8);
            return this.rootParent().getLong(this.idx(n2));
        }

        @Override
        protected long _getLong(int n2) {
            return this.rootParent()._getLong(this.idx(n2));
        }

        @Override
        public long getLongLE(int n2) {
            this.checkIndex(n2, 8);
            return this.rootParent().getLongLE(this.idx(n2));
        }

        @Override
        protected long _getLongLE(int n2) {
            return this.rootParent()._getLongLE(this.idx(n2));
        }

        @Override
        public ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
            this.checkIndex(n2, n4);
            this.rootParent().getBytes(this.idx(n2), byteBuf, n3, n4);
            return this;
        }

        @Override
        public ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
            this.checkIndex(n2, n4);
            this.rootParent().getBytes(this.idx(n2), byArray, n3, n4);
            return this;
        }

        @Override
        public ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
            this.checkIndex(n2, byteBuffer.remaining());
            this.rootParent().getBytes(this.idx(n2), byteBuffer);
            return this;
        }

        @Override
        public ByteBuf setByte(int n2, int n3) {
            this.checkIndex(n2, 1);
            this.rootParent().setByte(this.idx(n2), n3);
            return this;
        }

        @Override
        protected void _setByte(int n2, int n3) {
            this.rootParent()._setByte(this.idx(n2), n3);
        }

        @Override
        public ByteBuf setShort(int n2, int n3) {
            this.checkIndex(n2, 2);
            this.rootParent().setShort(this.idx(n2), n3);
            return this;
        }

        @Override
        protected void _setShort(int n2, int n3) {
            this.rootParent()._setShort(this.idx(n2), n3);
        }

        @Override
        public ByteBuf setMedium(int n2, int n3) {
            this.checkIndex(n2, 3);
            this.rootParent().setMedium(this.idx(n2), n3);
            return this;
        }

        @Override
        protected void _setMedium(int n2, int n3) {
            this.rootParent()._setMedium(this.idx(n2), n3);
        }

        @Override
        public ByteBuf setInt(int n2, int n3) {
            this.checkIndex(n2, 4);
            this.rootParent().setInt(this.idx(n2), n3);
            return this;
        }

        @Override
        protected void _setInt(int n2, int n3) {
            this.rootParent()._setInt(this.idx(n2), n3);
        }

        @Override
        public ByteBuf setLong(int n2, long l2) {
            this.checkIndex(n2, 8);
            this.rootParent().setLong(this.idx(n2), l2);
            return this;
        }

        @Override
        protected void _setLong(int n2, long l2) {
            this.rootParent()._setLong(this.idx(n2), l2);
        }

        @Override
        public ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
            this.checkIndex(n2, n4);
            this.rootParent().setBytes(this.idx(n2), byArray, n3, n4);
            return this;
        }

        @Override
        public ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
            this.checkIndex(n2, n4);
            this.rootParent().setBytes(this.idx(n2), byteBuf, n3, n4);
            return this;
        }

        @Override
        public ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
            this.checkIndex(n2, byteBuffer.remaining());
            this.rootParent().setBytes(this.idx(n2), byteBuffer);
            return this;
        }

        @Override
        public int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) throws IOException {
            return gatheringByteChannel.write(this.internalNioBuffer(n2, n3).duplicate());
        }

        @Override
        public int setBytes(int n2, InputStream inputStream, int n3) throws IOException {
            this.checkIndex(n2, n3);
            AbstractByteBuf abstractByteBuf = this.rootParent();
            if (abstractByteBuf.hasArray()) {
                return abstractByteBuf.setBytes(this.idx(n2), inputStream, n3);
            }
            byte[] byArray = ByteBufUtil.threadLocalTempArray(n3);
            int n4 = inputStream.read(byArray, 0, n3);
            if (n4 <= 0) {
                return n4;
            }
            this.setBytes(n2, byArray, 0, n4);
            return n4;
        }

        @Override
        public int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) throws IOException {
            try {
                return scatteringByteChannel.read(this.internalNioBuffer(n2, n3).duplicate());
            }
            catch (ClosedChannelException closedChannelException) {
                return -1;
            }
        }

        @Override
        public int forEachByte(int n2, int n3, ByteProcessor byteProcessor) {
            this.checkIndex(n2, n3);
            int n4 = this.rootParent().forEachByte(this.idx(n2), n3, byteProcessor);
            if (n4 < this.adjustment) {
                return -1;
            }
            return n4 - this.adjustment;
        }

        @Override
        public boolean isContiguous() {
            return this.rootParent().isContiguous();
        }

        private int idx(int n2) {
            return n2 + this.adjustment;
        }

        @Override
        protected void deallocate() {
            if (this.chunk != null) {
                this.chunk.release();
            }
            this.tmpNioBuf = null;
            this.chunk = null;
            this.rootParent = null;
            if (this.handle instanceof Recycler.EnhancedHandle) {
                ((Recycler.EnhancedHandle)this.handle).unguardedRecycle(this);
            } else if (this.handle != null) {
                this.handle.recycle(this);
            }
        }
    }

    private static final class Chunk {
        private static final AtomicIntegerFieldUpdater<Chunk> REF_CNT_UP_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Chunk.class, "refCntUp");
        private static final AtomicIntegerFieldUpdater<Chunk> REF_CNT_DOWN_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Chunk.class, "refCntDown");
        private final AbstractByteBuf delegate;
        private final Magazine magazine;
        private final int capacity;
        private final boolean pooled;
        private int allocatedBytes;
        private volatile int refCntUp;
        private volatile int refCntDown;

        Chunk(AbstractByteBuf abstractByteBuf, Magazine magazine, boolean bl2) {
            this.delegate = abstractByteBuf;
            this.magazine = magazine;
            this.pooled = bl2;
            this.capacity = abstractByteBuf.capacity();
            magazine.usedMemory.getAndAdd(this.capacity);
            REF_CNT_UP_UPDATER.lazySet(this, 1);
        }

        protected void deallocate() {
            Magazine magazine = this.magazine;
            AdaptivePoolingAllocator adaptivePoolingAllocator = magazine.parent;
            int n2 = magazine.preferredChunkSize();
            int n3 = this.delegate.capacity();
            if (!this.pooled || n3 < n2 || n3 > n2 + (n2 >> 1)) {
                magazine.usedMemory.getAndAdd(-this.capacity());
                this.delegate.release();
            } else {
                REF_CNT_UP_UPDATER.lazySet(this, 1);
                REF_CNT_DOWN_UPDATER.lazySet(this, 0);
                this.delegate.setIndex(0, 0);
                this.allocatedBytes = 0;
                if (!magazine.trySetNextInLine(this) && !adaptivePoolingAllocator.offerToQueue(this)) {
                    this.delegate.release();
                }
            }
        }

        public AdaptiveByteBuf readInitInto(AdaptiveByteBuf adaptiveByteBuf, int n2, int n3) {
            int n4 = this.allocatedBytes;
            this.allocatedBytes = n4 + n2;
            this.unguardedRetain();
            adaptiveByteBuf.init(this.delegate, this, 0, 0, n4, n2, n3);
            return adaptiveByteBuf;
        }

        public int remainingCapacity() {
            return this.capacity - this.allocatedBytes;
        }

        public int capacity() {
            return this.capacity;
        }

        private void unguardedRetain() {
            REF_CNT_UP_UPDATER.lazySet(this, this.refCntUp + 1);
        }

        public void release() {
            boolean bl2;
            int n2;
            do {
                int n3;
                int n4;
                if ((n4 = (n3 = this.refCntUp) - (n2 = this.refCntDown)) <= 0) {
                    throw new IllegalStateException("RefCnt is already 0");
                }
                boolean bl3 = bl2 = n4 == 1;
            } while (!REF_CNT_DOWN_UPDATER.compareAndSet(this, n2, n2 + 1));
            if (bl2) {
                this.deallocate();
            }
        }
    }

    private static final class Magazine
    extends AllocationStatistics {
        private static final AtomicReferenceFieldUpdater<Magazine, Chunk> NEXT_IN_LINE = AtomicReferenceFieldUpdater.newUpdater(Magazine.class, Chunk.class, "nextInLine");
        private Chunk current;
        private volatile Chunk nextInLine;
        private final AtomicLong usedMemory = new AtomicLong();

        Magazine(AdaptivePoolingAllocator adaptivePoolingAllocator) {
            this(adaptivePoolingAllocator, true);
        }

        Magazine(AdaptivePoolingAllocator adaptivePoolingAllocator, boolean bl2) {
            super(adaptivePoolingAllocator, bl2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AdaptiveByteBuf allocate(int n2, int n3, int n4, AdaptiveByteBuf adaptiveByteBuf) {
            AdaptiveByteBuf adaptiveByteBuf2;
            this.recordAllocationSize(n3);
            Chunk chunk = this.current;
            if (chunk != null && chunk.remainingCapacity() >= n2) {
                if (chunk.remainingCapacity() == n2) {
                    this.current = null;
                    try {
                        AdaptiveByteBuf adaptiveByteBuf3 = chunk.readInitInto(adaptiveByteBuf, n2, n4);
                        return adaptiveByteBuf3;
                    }
                    finally {
                        chunk.release();
                    }
                }
                return chunk.readInitInto(adaptiveByteBuf, n2, n4);
            }
            if (chunk != null) {
                chunk.release();
            }
            if (this.nextInLine != null) {
                chunk = NEXT_IN_LINE.getAndSet(this, null);
            } else {
                chunk = (Chunk)this.parent.centralQueue.poll();
                if (chunk == null) {
                    chunk = this.newChunkAllocation(n2);
                }
            }
            this.current = chunk;
            if (chunk.remainingCapacity() > n2) {
                adaptiveByteBuf2 = chunk.readInitInto(adaptiveByteBuf, n2, n4);
            } else if (chunk.remainingCapacity() == n2) {
                adaptiveByteBuf2 = chunk.readInitInto(adaptiveByteBuf, n2, n4);
                chunk.release();
                this.current = null;
            } else {
                Chunk chunk2 = this.newChunkAllocation(n2);
                adaptiveByteBuf2 = chunk2.readInitInto(adaptiveByteBuf, n2, n4);
                if (chunk.remainingCapacity() < 4096) {
                    chunk.release();
                    this.current = chunk2;
                } else if (!NEXT_IN_LINE.compareAndSet(this, null, chunk2) && !this.parent.offerToQueue(chunk2)) {
                    chunk2.release();
                }
            }
            return adaptiveByteBuf2;
        }

        private Chunk newChunkAllocation(int n2) {
            int n3 = Math.max(n2 * 10, this.preferredChunkSize());
            ChunkAllocator chunkAllocator = this.parent.chunkAllocator;
            Chunk chunk = new Chunk((AbstractByteBuf)chunkAllocator.allocate(n3, n3), this, true);
            return chunk;
        }

        boolean trySetNextInLine(Chunk chunk) {
            return NEXT_IN_LINE.compareAndSet(this, null, chunk);
        }
    }

    private static class AllocationStatistics
    extends StampedLock {
        protected final AdaptivePoolingAllocator parent;
        private final boolean shareable;
        private final short[][] histos = new short[][]{new short[8], new short[8], new short[8], new short[8]};
        private short[] histo = this.histos[0];
        private final int[] sums = new int[8];
        private int histoIndex;
        private int datumCount;
        private int datumTarget = 8192;
        private volatile int sharedPrefChunkSize = 131072;
        protected volatile int localPrefChunkSize = 131072;

        private AllocationStatistics(AdaptivePoolingAllocator adaptivePoolingAllocator, boolean bl2) {
            this.parent = adaptivePoolingAllocator;
            this.shareable = bl2;
        }

        protected void recordAllocationSize(int n2) {
            int n3 = n2;
            this.histo[n3] = (short)(this.histo[n3] + 1);
            if (this.datumCount++ == this.datumTarget) {
                this.rotateHistograms();
            }
        }

        static int sizeBucket(int n2) {
            int n3 = n2 - 1 >> 13 & 7;
            return 32 - Integer.numberOfLeadingZeros(n3);
        }

        private void rotateHistograms() {
            int n2;
            int n3;
            int n4;
            short[][] sArray = this.histos;
            for (n4 = 0; n4 < 8; ++n4) {
                this.sums[n4] = (sArray[0][n4] & 0xFFFF) + (sArray[1][n4] & 0xFFFF) + (sArray[2][n4] & 0xFFFF) + (sArray[3][n4] & 0xFFFF);
            }
            n4 = 0;
            int[] nArray = this.sums;
            int n5 = nArray.length;
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = nArray[n3];
                n4 += n2;
            }
            int n6 = (int)((double)n4 * 0.99);
            for (n5 = 0; n5 < this.sums.length && this.sums[n5] <= n6; n6 -= this.sums[n5], ++n5) {
            }
            n3 = 1 << n5 + 13;
            this.localPrefChunkSize = n2 = Math.max(n3 * 10, 131072);
            if (this.shareable) {
                for (Magazine magazine : this.parent.magazines) {
                    n2 = Math.max(n2, magazine.localPrefChunkSize);
                }
            }
            if (this.sharedPrefChunkSize != n2) {
                this.datumTarget = Math.max(this.datumTarget >> 1, 1024);
                this.sharedPrefChunkSize = n2;
            } else {
                this.datumTarget = Math.min(this.datumTarget << 1, 65534);
            }
            this.histoIndex = this.histoIndex + 1 & 3;
            this.histo = this.histos[this.histoIndex];
            this.datumCount = 0;
            Arrays.fill(this.histo, (short)0);
        }

        protected int preferredChunkSize() {
            return this.sharedPrefChunkSize;
        }
    }

    static enum MagazineCaching {
        EventLoopThreads,
        FastThreadLocalThreads,
        None;

    }
}

